package com.elitesland.tw.tw5.server.prd.office.controller;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiCodeEnums;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.file.payload.PrdFilePayload;
import com.elitesland.tw.tw5.api.prd.file.service.PrdFileService;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.file.config.FileProperties;
import com.elitesland.tw.tw5.server.prd.file.entity.PrdFileVersionDO;
import com.elitesland.tw.tw5.server.prd.file.service.PrdFileVersionService;
import com.elitesland.tw.tw5.server.prd.office.entities.Permission;
import com.elitesland.tw.tw5.server.prd.office.entities.User;
import com.elitesland.tw.tw5.server.prd.office.models.callback.ChangesHistory;
import com.elitesland.tw.tw5.server.prd.office.models.callback.Track;
import com.elitesland.tw.tw5.server.prd.office.models.enums.Action;
import com.elitesland.tw.tw5.server.prd.office.models.enums.Language;
import com.elitesland.tw.tw5.server.prd.office.models.enums.Mode;
import com.elitesland.tw.tw5.server.prd.office.models.enums.Type;
import com.elitesland.tw.tw5.server.prd.office.models.filemodel.Document;
import com.elitesland.tw.tw5.server.prd.office.models.filemodel.EditorConfig;
import com.elitesland.tw.tw5.server.prd.office.models.filemodel.FileModel;
import com.elitesland.tw.tw5.server.prd.office.service.configurers.FileConfigurer;
import com.elitesland.tw.tw5.server.prd.office.service.configurers.wrappers.DefaultFileWrapper;
import com.elitesland.tw.tw5.server.prd.office.storage.FileStorageMutator;
import com.elitesland.tw.tw5.server.prd.office.storage.FileStoragePathBuilder;
import com.elitesland.tw.tw5.server.prd.office.util.file.FileUtility;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;


/**
 * office在线编辑
 *
 * @author duwh
 * @date 2022/06/21
 */
@Api(value = "office在线编辑")
@Controller
@RequiredArgsConstructor
@RequestMapping("/api/office/")
@Slf4j
public class TwOfficeController {

    @Value("${office.files.docservice.url.site:http://192.168.118.33:9006/}")
    private String docserviceSite;

    @Value("${office.files.docservice.url.api:web-apps/apps/api/documents/api.js}")
    private String docserviceApiUrl;

    @Value("${office.files.callback.url.site:https://tw5-demo.tw.elitesland.com/ju1}")
    private String callBackUrl;

    @Autowired
    private FileConfigurer<DefaultFileWrapper> fileConfigurer;

    private final FileService fileService;

    @Autowired
    private HttpServletRequest request;
    @Autowired
    private FileUtility fileUtility;
    @Autowired
    private PrdFileService prdFileService;
    @Autowired
    private PrdFileVersionService prdFileVersionService;
    @Autowired
    private FileProperties fileProperties;
    @Autowired
    private FileStorageMutator storageMutator;
    @Autowired
    private FileStoragePathBuilder fileStoragePathBuilder;
    //    @Autowired
    private final ObjectMapper objectMapper;
    /**
     * 历史文件夹 后缀
     */
    private final String historyPostfix = "-hist";

    //    // @DubboReference(version = "${provider.service.version}")
    @Autowired
    private SysUserRpcService sysUserService;

    /**
     * 获取在线编辑配置信息
     *
     * @param fileId      文件标识
     * @param actionParam 操作参数
     * @param actionLink  行动联系
     * @param userId      用户id
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/react/edit")
    @ResponseBody
    public TwOutputUtil editDocFileReact(@RequestParam("fileId") Long fileId,
                                         @RequestParam(value = "action", required = false) String actionParam,
                                         @RequestParam(value = "actionLink", required = false) String actionLink,
                                         @RequestParam(value = "userId", required = false) Long userId) {
        // 获取当前用户
        //GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        SysUserDTO sysUserDTO = GlobalUtil.getLoginUser();
        //SysUserDTO sysUserDTO = sysUserService.getById(userId);
        if (sysUserDTO == null) {
            log.error("用户未登录");
            throw TwException.error("", "用户未登录");
        }

        Action action = Action.edit;
        Type type = Type.desktop;
        Language language = Language.zh;
        if (actionParam != null) {
            action = Action.valueOf(actionParam);
        }
        // 拿到最新版本的fileId
        // 根据fileId获取到
        final PrdFileVO prdFileVO = prdFileService.queryByKey(fileId);
        String fileName = prdFileVO.getFileName();
        final Long versionId = prdFileVO.getVersionId();
        String key = versionId != null ? versionId + "" : prdFileVO.getId() + "";

        User user = new User();
        user.setName(sysUserDTO.getUsername());
        Permission permission = new Permission();
        user.setPermissions(permission);
        user.setId(sysUserDTO.getId());

        // get file model with the default file parameters
        final DefaultFileWrapper wrapper = DefaultFileWrapper
                .builder()
                .fileName(fileName)
                .type(type)
                .lang(language)
                .action(action)
                .user(user)
                .actionData(actionLink)
                .build();
        FileModel fileModel = fileConfigurer.getFileModel(wrapper);
        final Document document = fileModel.getDocument();
        document.setTitle(fileName);  // set the title to the document config
        //final String downUrl = getServerUrl() + "/api/file/file/download/" + key;
        final String downUrl = callBackUrl + "/api/file/file/download/" + key;
        document.setUrl(downUrl);  // set the URL to download a file to the document config
        document.setUrlUser(downUrl);  // set the file URL to the document config
        document.setFileType(fileUtility.getFileExtension(fileName).replace(".", ""));  // set the file type to the document config
        //document.getInfo().setFavorite(wrapper.getFavorite());  // set the favorite parameter to the document config

        //String key =  serviceConverter.  // get the document key
        //                generateRevisionId(storagePathBuilder.getStorageLocation()
        //                + "/" + fileName + "/"
        //                + new File(storagePathBuilder.getFileLocation(fileName)).lastModified());
        // get the document key
        //String key = generateRevisionId(new File(prdFileVO.getServerPath()).lastModified() + "");

        document.setKey(key);  // set the key to the document config

        final EditorConfig config = fileModel.getEditorConfig();
        //config.setCallbackUrl(getServerUrl() + "/api/office/callBackPro?fileId=" + key + "&oldFileId=" + fileId);  // set the callback URL to the editorConfig
        config.setCallbackUrl(callBackUrl + "/api/office/callBackPro?fileId=" + key + "&oldFileId=" + fileId);  // set the callback URL to the editorConfig
        //config.setCreateUrl(userIsAnon ? null : documentManager.getCreateUrl(fileName, false));  // set the document URL where it will be created to the editorConfig if the user is not anonymous
        config.setLang(wrapper.getLang());  // set the language to the editorConfig
        Boolean canEdit = wrapper.getCanEdit();  // check if the file of the specified type can be edited or not
        Action action2 = wrapper.getAction();  // get the action parameter from the editorConfig wrapper

        //defaultCustomizationConfigurer.configure(config.getCustomization(), DefaultCustomizationWrapper.builder()  // define the customization configurer
        //    .action(action)
        //    .user(userIsAnon ? null : wrapper.getUser())
        //    .build());
        com.elitesland.tw.tw5.server.prd.office.models.filemodel.User fileModelUser = new com.elitesland.tw.tw5.server.prd.office.models.filemodel.User();
        fileModelUser.setId(user.getId() + "");
        fileModelUser.setName(user.getName());
        config.setUser(fileModelUser);
        config.setMode(canEdit && !action2.equals(Action.view) ? Mode.edit : Mode.view);

        // 历史版本
        //PrdFileVersionQuery versionQuery = new PrdFileVersionQuery();
        //versionQuery.setFileId(fileId);
        //final List<PrdFileVersionVO> versionList = prdFileVersionService.queryList(versionQuery);
        final Map history = getHistory(document, prdFileVO, key);
        //model.addAttribute("docserviceApiUrl", docserviceSite + docserviceApiUrl);  // create the document service api URL and add it to the model
        //model.addAttribute("model", fileModel);  // create the document service api URL and add it to the model
        //// 静态资源 css image 需要直通接口地址
        //model.addAttribute("apiUri", getServerUrl());
        Map<String, Object> result = new HashMap<>();
        result.put("config", fileModel);
        result.put("docserviceApiUrl", docserviceSite + docserviceApiUrl);
        result.put("fileHistoryArr", history);
        return TwOutputUtil.ok(result);
    }

    @SneakyThrows
    public Map getHistory(Document document, PrdFileVO prdFileVO, String documentKey) {  // get document history
        Map result = new HashMap();
        final String filePathPreStr = prdFileVO.getServerPath();
        Path histDirPath = Paths.get(fileStoragePathBuilder.getHistoryDir(filePathPreStr));
        final String histDirStr = histDirPath.toAbsolutePath().toString();
        Integer curVer = fileStoragePathBuilder.getFileVersion(histDirStr, false);  // get current file version

        if (curVer > 0) {  // check if the current file version is greater than 0
            List<Object> hist = new ArrayList<>();
            Map<String, Object> histData = new HashMap<>();

            for (Integer i = 1; i <= curVer; i++) {  // run through all the file versions
                Map<String, Object> obj = new HashMap<String, Object>();
                Map<String, Object> dataObj = new HashMap<String, Object>();
                String verDir = versionDir(histDirStr,  // get the file version directory
                        i, true);

                String key = i.equals(curVer) ? documentKey : readFileToEnd(new File(verDir + File.separator + "key.txt"));  // get document key
                obj.put("key", key);
                obj.put("version", i);

                if (i == 1) {  // check if the version number is equal to 1
                    //String createdInfo = readFileToEnd(new File(histDirPath + File.separator + "createdInfo.json"));  // get file with meta data
                    //JSONObject json = (JSONObject) parser.parse(createdInfo);  // and turn it into json object
                    //// write meta information to the object (user information and creation date)
                    //obj.put("created", json.get("created"));
                    //Map<String, Object> user = new HashMap<String, Object>();
                    //user.put("id", json.get("id"));
                    //user.put("name", json.get("name"));
                    //obj.put("user", user);
                    obj.put("created", prdFileVO.getCreateTime());
                    Map<String, Object> user = new HashMap<String, Object>();
                    user.put("id", prdFileVO.getCreateUserId());
                    user.put("name", prdFileVO.getCreator());
                    obj.put("user", user);
                }

                dataObj.put("fileType", prdFileVO.getSuffix());
                dataObj.put("key", key);
                final String serverPath = callBackUrl + "/api/office/";
                String filePathPrev = serverPath + "downloadhistory?fileId=" + prdFileVO.getId()
                        + "&ver=" + i + "&file=" + "prev." + prdFileVO.getSuffix();
                dataObj.put("url", i.equals(curVer) ? document.getUrl() :
                        filePathPrev);
                dataObj.put("version", i);

                if (i > 1) {  //check if the version number is greater than 1
                    // if so, get the path to the changes.json file
                    final cn.hutool.json.JSONObject changes = JSONUtil.parseObj(readFileToEnd(new File(versionDir(histDirStr, i - 1, true) + File.separator + "changes.json")));
                    cn.hutool.json.JSONObject change = (cn.hutool.json.JSONObject) ((cn.hutool.json.JSONArray) changes.get("changes")).get(0);
                    //// write information about changes to the object
                    obj.put("changes", changes.get("changes"));
                    obj.put("serverVersion", changes.get("serverVersion"));
                    obj.put("created", change.get("created"));
                    obj.put("user", change.get("user"));

                    Map<String, Object> prev = (Map<String, Object>) histData.get(Integer.toString(i - 2));  // get the history data from the previous file version
                    Map<String, Object> prevInfo = new HashMap<String, Object>();
                    prevInfo.put("fileType", prev.get("fileType"));
                    prevInfo.put("key", prev.get("key"));  // write key and URL information about previous file version
                    prevInfo.put("url", prev.get("url"));
                    dataObj.put("previous", prevInfo);  // write information about previous file version to the data object
                    // write the path to the diff.zip archive with differences in this file version
                    Integer verdiff = i - 1;
                    String filePathDiff = serverPath + "downloadhistory?fileId=" + prdFileVO.getId()
                            + "&ver=" + verdiff + "&file=" + "diff.zip";
                    dataObj.put("changesUrl", filePathDiff);
                }
                hist.add(obj);
                histData.put(Integer.toString(i - 1), dataObj);
            }

            // write history information about the current file version to the history object
            Map<String, Object> histObj = new HashMap<String, Object>();
            histObj.put("currentVersion", curVer);
            histObj.put("history", hist);

            result.put("hist", histObj);
            result.put("histData", histData);
            return result;
        }
        return result;
    }

    // read a file
    public static String readFileToEnd(File file) {
        String output = "";
        try {
            try (FileInputStream is = new FileInputStream(file)) {
                Scanner scanner = new Scanner(is);  // read data from the source
                scanner.useDelimiter("\\A");
                while (scanner.hasNext()) {
                    output += scanner.next();
                }
                scanner.close();
            }
        } catch (Exception e) {
        }
        return output;
    }

    /**
     * 下载历史版本文件
     *
     * @param request 请求
     * @param fileId  文件标识
     * @param version 版本
     * @param file    文件
     * @return {@link ResponseEntity}<{@link Resource}>
     */
    @GetMapping("/downloadhistory")
    public ResponseEntity<Resource> downloadHistory(HttpServletRequest request,// download a file
                                                    @RequestParam("fileId") String fileId,
                                                    @RequestParam("ver") String version,
                                                    @RequestParam("file") String file) { // history file
        try {
            final PrdFileVO prdFileVO = prdFileService.queryByKey(Long.valueOf(fileId));
            final String filePathPreStr = prdFileVO.getServerPath();
            return downloadFileHistory(filePathPreStr, version, file);  // download data from the specified file
        } catch (Exception e) {
            return null;
        }
    }

    // download data from the specified history file
    private ResponseEntity<Resource> downloadFileHistory(String filePathPreStr, String version, String file) {
        Resource resource = loadFileAsResourceHistory(filePathPreStr, version, file);  // load the specified file as a resource
        String contentType = "application/octet-stream";
        // create a response with the content type, header and body with the file data
        return ResponseEntity.ok()
                .contentType(MediaType.parseMediaType(contentType))
                .header(HttpHeaders.CONTENT_DISPOSITION, "attachment; filename=\"" + resource.getFilename() + "\"")
                .body(resource);
    }

    public Resource loadFileAsResourceHistory(String filePathPreStr, String version, String file) {
        String fileLocation = filePathPreStr + "-hist" + File.separator + version + File.separator + file;  // get it by the file name
        try {
            Path filePath = Paths.get(fileLocation);  // get the path to the file location
            Resource resource = new UrlResource(filePath.toUri());  // convert the file path to URL
            if (resource.exists()) {
                return resource;
            }
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @GetMapping("/editPro")
    public String editDocFilePro(@RequestParam("fileId") Long fileId,
                                 @RequestParam(value = "action", required = false) String actionParam,
                                 @RequestParam(value = "actionLink", required = false) String actionLink,
                                 Long userId,
                                 Model model) {
        // 获取当前用户
        //SysUserDTO sysUserDTO = GlobalUtil.getLoginUser();
        SysUserDTO sysUserDTO = sysUserService.getById(userId);
        if (sysUserDTO == null) {
            log.error("用户未登录");
            return "index";
        }

        Action action = Action.edit;
        Type type = Type.desktop;
        Language language = Language.zh;
        if (actionParam != null) {
            action = Action.valueOf(actionParam);
        }
        // 拿到最新版本的fileId
        // 根据fileId获取到
        final PrdFileVO prdFileVO = prdFileService.queryByKey(fileId);
        String fileName = prdFileVO.getFileName();
        final Long versionId = prdFileVO.getVersionId();

        User user = new User();
        user.setName(sysUserDTO.getUsername());
        Permission permission = new Permission();
        user.setPermissions(permission);
        user.setId(sysUserDTO.getId());

        String key = versionId != null ? versionId + "" : prdFileVO.getId() + "";


        // get file model with the default file parameters
        final DefaultFileWrapper wrapper = DefaultFileWrapper
                .builder()
                .fileName(fileName)
                .type(type)
                .lang(language)
                .action(action)
                .user(user)
                .actionData(actionLink)
                .build();
        FileModel fileModel = fileConfigurer.getFileModel(wrapper);
        final Document document = fileModel.getDocument();
        document.setTitle(fileName);  // set the title to the document config
        final String downUrl = callBackUrl + "/api/file/file/download/" + key;
        document.setUrl(downUrl);  // set the URL to download a file to the document config
        document.setUrlUser(downUrl);  // set the file URL to the document config
        document.setFileType(fileUtility.getFileExtension(fileName).replace(".", ""));  // set the file type to the document config
        //document.getInfo().setFavorite(wrapper.getFavorite());  // set the favorite parameter to the document config

        //String key =  serviceConverter.  // get the document key
        //                generateRevisionId(storagePathBuilder.getStorageLocation()
        //                + "/" + fileName + "/"
        //                + new File(storagePathBuilder.getFileLocation(fileName)).lastModified());
        // get the document key
        //String key = generateRevisionId(new File(prdFileVO.getServerPath()).lastModified() + "");

        document.setKey(key);  // set the key to the document config

        final EditorConfig config = fileModel.getEditorConfig();
        config.setCallbackUrl(callBackUrl + "/api/office/callBackPro?fileId=" + key + "&oldFileId=" + fileId);  // set the callback URL to the editorConfig
        //config.setCreateUrl(userIsAnon ? null : documentManager.getCreateUrl(fileName, false));  // set the document URL where it will be created to the editorConfig if the user is not anonymous
        config.setLang(wrapper.getLang());  // set the language to the editorConfig
        Boolean canEdit = wrapper.getCanEdit();  // check if the file of the specified type can be edited or not
        Action action2 = wrapper.getAction();  // get the action parameter from the editorConfig wrapper

        //defaultCustomizationConfigurer.configure(config.getCustomization(), DefaultCustomizationWrapper.builder()  // define the customization configurer
        //    .action(action)
        //    .user(userIsAnon ? null : wrapper.getUser())
        //    .build());
        com.elitesland.tw.tw5.server.prd.office.models.filemodel.User fileModelUser = new com.elitesland.tw.tw5.server.prd.office.models.filemodel.User();
        BeanUtils.copyProperties(user, fileModelUser);
        config.setUser(fileModelUser);
        config.setMode(canEdit && !action2.equals(Action.view) ? Mode.edit : Mode.view);

        model.addAttribute("docserviceApiUrl", docserviceSite + docserviceApiUrl);  // create the document service api URL and add it to the model
        model.addAttribute("model", fileModel);  // create the document service api URL and add it to the model
        // 静态资源 css image 需要直通接口地址
        model.addAttribute("apiUri", callBackUrl);
        return "editor";
    }


    /**
     * 编辑器回调
     *
     * @param request   请求
     * @param response  响应
     * @param fileId    文件标识
     * @param oldFileId 旧文件id
     */
    @SneakyThrows
    @RequestMapping("/callBackPro")
    public void callBackPro(@RequestBody Track body, HttpServletRequest request, HttpServletResponse response, Long fileId, Long oldFileId) {
        PrintWriter writer = response.getWriter();
        /**
         * 定义文档的状态。可以具有以下值：
         * 1 - 正在编辑文档，
         * 2 - 文档已准备好保存，
         * 3 - 发生文档保存错误，
         * 4 - 文稿已关闭，没有更改，
         * 6 - 正在编辑文档，但保存了当前的文档状态，
         * 7 - 强制保存文档时出错。
         */
        log.info("[office info] callback status:{}", body.getStatus());
        //if ((Integer) jsonObj.get("status") == 2) {
        if (body.getStatus() == 2) {
            log.info("[office info] callback status ==2 ;json:{}", body);
            final PrdFileVO prdFileVO = prdFileService.queryByKey(fileId);
            final PrdFileVO oldPrdFileVO = prdFileService.queryByKey(oldFileId);
            final String realName = prdFileVO.getRealName();
            // Test123.docx
            final String fileName = prdFileVO.getFileName();
            final String suffix = FileUtil.getExtensionName(realName);

            String downloadUri = body.getUrl();
            String changesUri = body.getChangesurl();
            String key = body.getKey();

            //String storagePath = prdFileVO.getServerPath();
            Path lastVersion = Paths.get(prdFileVO.getServerPath());
            if (lastVersion.toFile().exists()) {  // if the last file version exists
                //Path histDir = Paths.get(fileStoragePathBuilder.getHistoryDir(storagePath));  // get the history directory
                // get the history directory
                Path histDir = Paths.get(fileStoragePathBuilder.getHistoryDir(oldPrdFileVO.getServerPath()));
                storageMutator.createDirectory(histDir);  // and create it

                final int fileVersion = fileStoragePathBuilder.getFileVersion(histDir.toAbsolutePath().toString(), false);
                String versionDir = versionDir(histDir.toAbsolutePath().toString(),  // get the file version directory
                        fileVersion, true);
                log.info("[office info] versionDir:=========={}", versionDir);
                Path ver = Paths.get(versionDir);
                // 原项目文件路径 /Users/duwh/temp4/文档/Test123-20220927104912430.docx
                //Path toSave = Paths.get(storagePath);
                // 新建版本文件
                final String filePath = prdFileService.getFilePath(prdFileVO.getFileTypeDesc());
                final String changeFileName = FileUtil.generateFileNameAndCheckPath(fileName, filePath);
                final String changeFilePathStr = filePath + changeFileName;
                log.info("[office info] ver======{}", ver);
                // create the file version directory
                storageMutator.createDirectory(ver);
                //storageMutator.moveFile(lastVersion, Paths.get(versionDir + File.separator + "prev." + suffix));  // move the last file version to the file version directory with the "prev" postfix
                storageMutator.copyFile(lastVersion, Paths.get(versionDir + File.separator + "prev." + suffix));  // move the last file version to the file version directory with the "prev" postfix
                // 版本不同
                // save file changes to the diff.zip archive
                downloadToFile(changesUri, Path.of(versionDir + File.separator + "diff.zip"));

                // 覆盖原有文件
                //downloadToFile(downloadUri, toSave);  // save file to the storage path

                // 修改后的文件保存为新文件
                final Path changeFilePath = Paths.get(changeFilePathStr);
                log.info("[office info] changeFilePath:=========={}", changeFilePath);
                downloadToFile(downloadUri, changeFilePath);  // save file to the storage path

                // 历史版本本地存储 （暂未用）
                // create a json object for document changes
                JSONObject jsonChanges = new JSONObject();
                final List<ChangesHistory> changes = body.getHistory().getChanges();
                String changeUserName = "";
                String changeUserId = "0";
                if (!CollectionUtils.isEmpty(changes)) {
                    final String createdTime = changes.get(0).getCreated();
                    log.info("[office info] createdTime:=========={}", createdTime);
                    changeUserId = changes.get(0).getUser().getId();
                    log.info("[office info] changeUserId:=========={}", changeUserId);
                    changeUserName = changes.get(0).getUser().getName();
                }
                // put the changes to the json object
                jsonChanges.put("changes", changes);
                // put the server version to the json object
                jsonChanges.put("serverVersion", body.getHistory().getServerVersion());
                String history = objectMapper.writeValueAsString(jsonChanges);
                if (history == null && body.getHistory() != null) {
                    history = objectMapper.writeValueAsString(body.getHistory());
                }
                if (history != null && !history.isEmpty()) {
                    // write the history changes to the changes.json file
                    storageMutator.writeToFile(versionDir + File.separator + "changes.json", history);
                }
                // write the key value to the key.txt file
                storageMutator.writeToFile(versionDir + File.separator + "key.txt", key);

                // 历史文件 生成新的文件 存储一条记录
                final long length = changeFilePath.toFile().length();
                final PrdFilePayload changeFile = PrdFilePayload.builder()
                        .name(prdFileVO.getName())
                        .folderId(prdFileVO.getFolderId())
                        .fileName(fileName)
                        .realName(changeFileName)
                        .serverPath(changeFilePathStr)
                        .fileType(prdFileVO.getFileType())
                        .fileTypeDesc(prdFileVO.getFileTypeDesc())
                        .fileSize(length)
                        .fileSizeDesc(FileUtil.getSize(length))
                        // 版本文件
                        .versionFlag(1)
                        .build();
                // 更新主文件中的 最新版本信息
                final PrdFileVO changeFileReturn = prdFileService.insert(changeFile);
                PrdFilePayload update = PrdFilePayload.builder()
                        .versionId(changeFileReturn.getId())
                        .versionNo("" + fileVersion)
                        .build();
                update.setId(oldFileId);
                prdFileService.update(update);

                // 文件、历史版本 关系记录
                PrdFileVersionDO fileVersionDO = new PrdFileVersionDO();
                fileVersionDO.setFileId(prdFileVO.getId());
                fileVersionDO.setVersionNo("" + fileVersion);
                fileVersionDO.setFileId(oldFileId);
                fileVersionDO.setOldFileId(fileId);
                fileVersionDO.setNewFileId(changeFileReturn.getId());
                final Long createUserId = Long.valueOf(changeUserId);
                fileVersionDO.setCreateUserId(createUserId);
                fileVersionDO.setCreator(changeUserName);
                fileVersionDO.setModifyUserId(createUserId);
                fileVersionDO.setUpdater(changeUserName);
                prdFileVersionService.insert(fileVersionDO);

                //storageMutator.deleteFile(storagePathBuilder.getForcesavePath(newFileName, false));  // get the path to the forcesaved file version and remove it
            }
        }
        writer.write("{\"error\":0}");

    }


    /**
     * 编辑文档文件
     *
     * @param fileCode    文件代码
     * @param actionParam 操作参数
     * @param actionLink  行动联系
     * @param model       模型
     * @return {@link String}
     */
    @GetMapping("/edit")
    public String editDocFile(@RequestParam("fileCode") String fileCode,
                              @RequestParam(value = "action", required = false) String actionParam,
                              @RequestParam(value = "actionLink", required = false) String actionLink,
                              Long userId,
                              Model model) {
        // 获取当前用户
        //GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        //SysUserDTO userDTO = currentUser.getUser();

        SysUserDTO sysUserDTO = sysUserService.getById(userId);
        if (sysUserDTO == null) {
            log.error("用户未登录");
            return "index";
        }

        Action action = Action.edit;
        Type type = Type.desktop;
        Language language = Language.zh;
        if (actionParam != null) {
            action = Action.valueOf(actionParam);
        }

        // TODO 根据fileCode 查看自己业务系统维护的版本-新文件fileCode的对应关系；
        // 拿到最新版本的fileCode
        // 根据fileCode获取到
        String fileName = "文件不存在";
        final ApiResult apiResult = fileService.get(fileCode);
        if (apiResult.getCode() == ApiCodeEnums.SUCCESS.getCode()) {
            final FileObjRespVO data = (FileObjRespVO) apiResult.getData();
            fileName = data.getOriginalName();
        }

        User user = new User();
        user.setName(sysUserDTO.getUsername());
        Permission permission = new Permission();
        user.setPermissions(permission);
        user.setId(sysUserDTO.getId());

        // get file model with the default file parameters
        final DefaultFileWrapper wrapper = DefaultFileWrapper
                .builder()
                .fileName(fileName)
                .type(type)
                .lang(language)
                .action(action)
                .user(user)
                .actionData(actionLink)
                .build();
        FileModel fileModel = fileConfigurer.getFileModel(wrapper);
        final Document document = fileModel.getDocument();
        document.setTitle(fileName);  // set the title to the document config
        final String downUrl = callBackUrl + "/com/file/v1/" + fileCode + "/download";
        document.setUrl(downUrl);  // set the URL to download a file to the document config
        document.setUrlUser(downUrl);  // set the file URL to the document config
        document.setFileType(fileUtility.getFileExtension(fileName).replace(".", ""));  // set the file type to the document config
        //document.getInfo().setFavorite(wrapper.getFavorite());  // set the favorite parameter to the document config

        //String key =  serviceConverter.  // get the document key
        //                generateRevisionId(storagePathBuilder.getStorageLocation()
        //                + "/" + fileName + "/"
        //                + new File(storagePathBuilder.getFileLocation(fileName)).lastModified());

        document.setKey(fileCode);  // set the key to the document config

        final EditorConfig config = fileModel.getEditorConfig();
        config.setCallbackUrl(callBackUrl + "/api/office/callBack?fileCode=" + fileCode);  // set the callback URL to the editorConfig
        //config.setCreateUrl(userIsAnon ? null : documentManager.getCreateUrl(fileName, false));  // set the document URL where it will be created to the editorConfig if the user is not anonymous
        config.setLang(wrapper.getLang());  // set the language to the editorConfig
        Boolean canEdit = wrapper.getCanEdit();  // check if the file of the specified type can be edited or not
        Action action2 = wrapper.getAction();  // get the action parameter from the editorConfig wrapper

        //defaultCustomizationConfigurer.configure(config.getCustomization(), DefaultCustomizationWrapper.builder()  // define the customization configurer
        //    .action(action)
        //    .user(userIsAnon ? null : wrapper.getUser())
        //    .build());
        com.elitesland.tw.tw5.server.prd.office.models.filemodel.User fileModelUser = new com.elitesland.tw.tw5.server.prd.office.models.filemodel.User();
        fileModelUser.setId(user.getId() + "");
        fileModelUser.setName(user.getName());
        fileModelUser.setGroup("EL-GROUP");
        config.setUser(fileModelUser);
        config.setMode(canEdit && !action2.equals(Action.view) ? Mode.edit : Mode.view);

        model.addAttribute("docserviceApiUrl", docserviceSite + docserviceApiUrl);  // create the document service api URL and add it to the model
        model.addAttribute("model", fileModel);  // create the document service api URL and add it to the model
        // 静态资源 css image 需要直通接口地址
        model.addAttribute("apiUri", callBackUrl);

        return "editor";
    }


    @SneakyThrows
    @RequestMapping("/callBack")
    public void callBack(HttpServletRequest request, HttpServletResponse response, String fileCode) throws IOException {

        PrintWriter writer = response.getWriter();

        Scanner scanner = new Scanner(request.getInputStream()).useDelimiter("\\A");
        String body = scanner.hasNext() ? scanner.next() : "";

        JSONObject jsonObj = JSONObject.parseObject(body);

        /**
         * 定义文档的状态。可以具有以下值：
         * 1 - 正在编辑文档，
         * 2 - 文档已准备好保存，
         * 3 - 发生文档保存错误，
         * 4 - 文稿已关闭，没有更改，
         * 6 - 正在编辑文档，但保存了当前的文档状态，
         * 7 - 强制保存文档时出错。
         */
        log.info("[office info] callback status:{}", jsonObj.get("status").toString());
        if ((Integer) jsonObj.get("status") == 2) {
            // TODO 保存文件待实现
            // 1、调用文件服务 生成新文件；
            // 2、业务系统 维护 新文件-版本-老文件的关系；
            // 3、
            log.info("[office info] callback status ==2 ;json:{}", body);
            String downloadUri = (String) jsonObj.get("url");

            URL url = new URL(downloadUri);
            java.net.HttpURLConnection connection = (java.net.HttpURLConnection) url.openConnection();
            InputStream stream = connection.getInputStream();

            File savedFile = new File("/User/duwh/temp4");
            try (FileOutputStream out = new FileOutputStream(savedFile)) {
                int read;
                final byte[] bytes = new byte[1024];
                while ((read = stream.read(bytes)) != -1) {
                    out.write(bytes, 0, read);
                }

                out.flush();
            }

            connection.disconnect();
        }
        writer.write("{\"error\":0}");

    }


    @GetMapping("/index")
    public String test(Model model) {
        System.out.println("index");
        return "index";
    }

    public String getServerUrl() {
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
    }

    // save file information from the URL to the file specified
    private void downloadToFile(String url, Path path) throws Exception {
        if (url == null || url.isEmpty()) {
            throw new RuntimeException("Url argument is not specified");  // URL isn't specified
        }
        if (path == null) {
            throw new RuntimeException("Path argument is not specified");  // file isn't specified
        }

        URL uri = new URL(url);
        java.net.HttpURLConnection connection = (java.net.HttpURLConnection) uri.openConnection();
        InputStream stream = connection.getInputStream();  // get input stream of the file information from the URL

        if (stream == null) {
            connection.disconnect();
            throw new RuntimeException("Input stream is null");
        }

        storageMutator.createOrUpdateFile(path, stream);  // update a file or create a new one
    }

    // generate document key
    public String generateRevisionId(String expectedKey) {
        if (expectedKey.length() > 20)  // if the expected key length is greater than 20
        {
            expectedKey = Integer.toString(expectedKey.hashCode());  // the expected key is hashed and a fixed length value is stored in the string format
        }

        String key = expectedKey.replace("[^0-9-.a-zA-Z_=]", "_");

        return key.substring(0, Math.min(key.length(), 20));  // the resulting key length is 20 or less
    }

    public String versionDir(String path, Integer version, boolean historyPath) {
        if (!historyPath) {
            return fileStoragePathBuilder.getHistoryDir(fileStoragePathBuilder.getFileLocation(path)) + version;
        }
        return path + File.separator + version;
    }

    //public String getForcesavePath(String fileName, Boolean create) {
    //    String directory = getStorageLocation();
    //
    //    Path path = Paths.get(directory);  // get the storage directory
    //    if (!Files.exists(path)) return "";
    //
    //    directory = getFileLocation(fileName) + historyPostfix + File.separator;
    //
    //    path = Paths.get(directory);   // get the history file directory
    //    if (!create && !Files.exists(path)) return "";
    //
    //    createDirectory(path);  // create a new directory where all the forcely saved file versions will be saved
    //
    //    directory = directory + fileName;
    //    path = Paths.get(directory);
    //    if (!create && !Files.exists(path)) {
    //        return "";
    //    }
    //
    //    return directory;
    //}


}
