package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * 员工管理异步service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AsyncEmployeeServiceImpl {
    private final PrdOrgEmployeeDAO dao;
    private final QyWxCommunicationService qyWxCommunicationService;

    /**
     * 异步更新企业微信ID
     *
     * @param employeeVO
     */
    @Transactional(propagation = Propagation.REQUIRED)
//    @Async
    public void queryWecomId(PrdOrgEmployeeVO employeeVO) {
        String wecom = qyWxCommunicationService.getQyWxuserid(employeeVO.getMobile());
        if (!"".equals(wecom)) {
            dao.updateWecomId(employeeVO.getUserId(), wecom);
        }
    }
}
