package com.elitesland.tw.tw5.server.prd.partner.common.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookContactsPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookContactsQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookContactsVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BookAddressDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BookContactsDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBookContactsDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BookContactsRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 业务伙伴-联系信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Repository
@RequiredArgsConstructor
public class BookContactsDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BookContactsRepo repo;
    private final QBookContactsDO qdo = QBookContactsDO.bookContactsDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BookContactsVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BookContactsVO.class,
                qdo.id,
                qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 地址薄id
                qdo.bookId,
                // 联系人类型
                qdo.contactsType,
                // 联系人姓名
                qdo.contactsName,
                // 联系人手机
                qdo.contactsPhone,
                // 联系人电话
                qdo.contactsTelephone,
                // 邮箱
                qdo.contactsEmail,
                // 联系地址
                qdo.contactsAddress,
                // 社交账户类型
                qdo.socialAccountType,
                // 社交账户
                qdo.socialAccount,
                // 部门
                qdo.contactsDepartment,
                // 岗位
                qdo.contactsPosition,
                // 联系人关系
                qdo.contactsRelation,
                // 性别 udc[org:employee:sex]
                qdo.sex,
                // 生日
                qdo.birthday,
                // 是否是关键决策人
                qdo.isKeyPerson,
                // 联系人编号
                qdo.contactsNo,
                // 联系人状态
                qdo.contactsStatus,
                // 是否为默认联系人信息
                qdo.isDefault,
                // 业务伙伴名称
                qBusinessPartnerDO.partnerName.as("bookName")
        )).from(qdo).leftJoin(qBusinessPartnerDO).on(qBusinessPartnerDO.bookId.eq(qdo.bookId));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BookContactsVO> getJpaQueryWhere(BookContactsQuery query) {
        JPAQuery<BookContactsVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qBusinessPartnerDO.deleteFlag.eq(0));
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
        //    jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BookContactsQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.leftJoin(qBusinessPartnerDO).on(qBusinessPartnerDO.bookId.eq(qdo.bookId));
        jpaQuery.where(qBusinessPartnerDO.deleteFlag.eq(0));
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BookContactsQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 地址薄id 精确 */
        if (!ObjectUtils.isEmpty(query.getBookId())) {
            list.add(qdo.bookId.eq(query.getBookId()));
        }
        /** 地址薄id 精确 */
        if (!CollectionUtils.isEmpty(query.getBookIdList())) {
            list.add(qdo.bookId.in(query.getBookIdList()));
        }
        /** 联系人类型 精确 */
        if (!ObjectUtils.isEmpty(query.getContactsType())) {
            list.add(qdo.contactsType.eq(query.getContactsType()));
        }
        /** 联系人姓名 精确 */
        if (!ObjectUtils.isEmpty(query.getContactsName())) {
            list.add(qdo.contactsName.eq(query.getContactsName()));
        }
        /** 联系人手机 精确 */
        if (!ObjectUtils.isEmpty(query.getContactsPhone())) {
            list.add(qdo.contactsPhone.eq(query.getContactsPhone()));
        }
        /** 联系人电话 精确 */
        if (!ObjectUtils.isEmpty(query.getContactsTelephone())) {
            list.add(qdo.contactsTelephone.eq(query.getContactsTelephone()));
        }
        /** 邮箱 精确 */
        if (!ObjectUtils.isEmpty(query.getContactsEmail())) {
            list.add(qdo.contactsEmail.eq(query.getContactsEmail()));
        }
        /** 联系地址 精确 */
        if (!ObjectUtils.isEmpty(query.getContactsAddress())) {
            list.add(qdo.contactsAddress.eq(query.getContactsAddress()));
        }
        /** 社交账户类型 精确 */
        if (!ObjectUtils.isEmpty(query.getSocialAccountType())) {
            list.add(qdo.socialAccountType.eq(query.getSocialAccountType()));
        }
        /** 社交账户 精确 */
        if (!ObjectUtils.isEmpty(query.getSocialAccount())) {
            list.add(qdo.socialAccount.eq(query.getSocialAccount()));
        }
        /** 部门 精确 */
        if (!ObjectUtils.isEmpty(query.getContactsDepartment())) {
            list.add(qdo.contactsDepartment.eq(query.getContactsDepartment()));
        }
        /** 岗位 精确 */
        if (!ObjectUtils.isEmpty(query.getContactsPosition())) {
            list.add(qdo.contactsPosition.eq(query.getContactsPosition()));
        }
        /** 联系人关系 精确 */
        if (!ObjectUtils.isEmpty(query.getContactsRelation())) {
            list.add(qdo.contactsRelation.eq(query.getContactsRelation()));
        }
        /** 性别 udc[org:employee:sex] 精确 */
        if (!ObjectUtils.isEmpty(query.getSex())) {
            list.add(qdo.sex.eq(query.getSex()));
        }
        /** 生日 精确 */
        if (!ObjectUtils.isEmpty(query.getBirthday())) {
            list.add(qdo.birthday.eq(query.getBirthday()));
        }
        /** 是否是关键决策人 精确 */
        if (!ObjectUtils.isEmpty(query.getIsKeyPerson())) {
            list.add(qdo.isKeyPerson.eq(query.getIsKeyPerson()));
        }
        /** 联系人编号 精确 */
        if (!ObjectUtils.isEmpty(query.getContactsNo())) {
            list.add(qdo.contactsNo.eq(query.getContactsNo()));
        }
        /** 联系人状态 精确 */
        if (!ObjectUtils.isEmpty(query.getContactsStatus())) {
            list.add(qdo.contactsStatus.eq(query.getContactsStatus()));
        }
        /** 是否为默认联系人信息 精确 */
        if (!ObjectUtils.isEmpty(query.getIsDefault())) {
            list.add(qdo.isDefault.eq(query.getIsDefault()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BookContactsVO queryByKey(Long id) {
        JPAQuery<BookContactsVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据bookId查询默认
     *
     * @param bookId bookId
     * @return {@link BookContactsVO}
     */
    public BookContactsVO queryDefaultByBookId(Long bookId) {
        JPAQuery<BookContactsVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.bookId.eq(bookId));
        jpaQuery.where(qdo.isDefault.eq(Boolean.TRUE));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BookContactsVO> queryListDynamic(BookContactsQuery query) {
        JPAQuery<BookContactsVO> jpaQuery = getJpaQueryWhere(query);
        OrderItem sortNoOrderItem = OrderItem.desc("isDefault");
        OrderItem createTimeOrderItem = OrderItem.desc("createTime");
        List<OrderItem> OrderItemList = new ArrayList<>();
        OrderItemList.add(sortNoOrderItem);
        OrderItemList.add(createTimeOrderItem);
        query.setOrders(OrderItemList);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BookContactsVO> queryPaging(BookContactsQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BookContactsVO> jpaQuery = getJpaQueryWhere(query);
        List<BookContactsVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BookContactsVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BookContactsDO save(BookContactsDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BookContactsDO> saveAll(List<BookContactsDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BookContactsPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 地址薄id
        if (payload.getBookId() != null) {
            update.set(qdo.bookId, payload.getBookId());
        }
        // 联系人类型
        if (payload.getContactsType() != null) {
            update.set(qdo.contactsType, payload.getContactsType());
        }
        // 联系人姓名
        if (payload.getContactsName() != null) {
            update.set(qdo.contactsName, payload.getContactsName());
        }
        // 联系人手机
        if (payload.getContactsPhone() != null) {
            update.set(qdo.contactsPhone, payload.getContactsPhone());
        }
        // 联系人电话
        if (payload.getContactsTelephone() != null) {
            update.set(qdo.contactsTelephone, payload.getContactsTelephone());
        }
        // 邮箱
        if (payload.getContactsEmail() != null) {
            update.set(qdo.contactsEmail, payload.getContactsEmail());
        }
        // 联系地址
        if (payload.getContactsAddress() != null) {
            update.set(qdo.contactsAddress, payload.getContactsAddress());
        }
        // 社交账户类型
        if (payload.getSocialAccountType() != null) {
            update.set(qdo.socialAccountType, payload.getSocialAccountType());
        }
        // 社交账户
        if (payload.getSocialAccount() != null) {
            update.set(qdo.socialAccount, payload.getSocialAccount());
        }
        // 部门
        if (payload.getContactsDepartment() != null) {
            update.set(qdo.contactsDepartment, payload.getContactsDepartment());
        }
        // 岗位
        if (payload.getContactsPosition() != null) {
            update.set(qdo.contactsPosition, payload.getContactsPosition());
        }
        // 联系人关系
        if (payload.getContactsRelation() != null) {
            update.set(qdo.contactsRelation, payload.getContactsRelation());
        }
        // 性别 udc[org:employee:sex]
        if (payload.getSex() != null) {
            update.set(qdo.sex, payload.getSex());
        }
        // 生日
        if (payload.getBirthday() != null) {
            update.set(qdo.birthday, payload.getBirthday());
        }
        // 是否是关键决策人
        if (payload.getIsKeyPerson() != null) {
            update.set(qdo.isKeyPerson, payload.getIsKeyPerson());
        }
        // 联系人编号
        if (payload.getContactsNo() != null) {
            update.set(qdo.contactsNo, payload.getContactsNo());
        }
        // 联系人状态
        if (payload.getContactsStatus() != null) {
            update.set(qdo.contactsStatus, payload.getContactsStatus());
        }
        // 是否为默认联系人信息
        if (payload.getIsDefault() != null) {
            update.set(qdo.isDefault, payload.getIsDefault());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 地址薄id
            if (nullFields.contains("bookId")) {
                update.setNull(qdo.bookId);
            }
            // 联系人类型
            if (nullFields.contains("contactsType")) {
                update.setNull(qdo.contactsType);
            }
            // 联系人姓名
            if (nullFields.contains("contactsName")) {
                update.setNull(qdo.contactsName);
            }
            // 联系人手机
            if (nullFields.contains("contactsPhone")) {
                update.setNull(qdo.contactsPhone);
            }
            // 联系人电话
            if (nullFields.contains("contactsTelephone")) {
                update.setNull(qdo.contactsTelephone);
            }
            // 邮箱
            if (nullFields.contains("contactsEmail")) {
                update.setNull(qdo.contactsEmail);
            }
            // 联系地址
            if (nullFields.contains("contactsAddress")) {
                update.setNull(qdo.contactsAddress);
            }
            // 社交账户类型
            if (nullFields.contains("socialAccountType")) {
                update.setNull(qdo.socialAccountType);
            }
            // 社交账户
            if (nullFields.contains("socialAccount")) {
                update.setNull(qdo.socialAccount);
            }
            // 部门
            if (nullFields.contains("contactsDepartment")) {
                update.setNull(qdo.contactsDepartment);
            }
            // 岗位
            if (nullFields.contains("contactsPosition")) {
                update.setNull(qdo.contactsPosition);
            }
            // 联系人关系
            if (nullFields.contains("contactsRelation")) {
                update.setNull(qdo.contactsRelation);
            }
            // 性别 udc[org:employee:sex]
            if (nullFields.contains("sex")) {
                update.setNull(qdo.sex);
            }
            // 生日
            if (nullFields.contains("birthday")) {
                update.setNull(qdo.birthday);
            }
            // 是否是关键决策人
            if (nullFields.contains("isKeyPerson")) {
                update.setNull(qdo.isKeyPerson);
            }
            // 联系人编号
            if (nullFields.contains("contactsNo")) {
                update.setNull(qdo.contactsNo);
            }
            // 联系人状态
            if (nullFields.contains("contactsStatus")) {
                update.setNull(qdo.contactsStatus);
            }
            // 是否为默认联系人信息
            if (nullFields.contains("isDefault")) {
                update.setNull(qdo.isDefault);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
    /**
     * 根据bookId查询列表
     *
     * @param bookId bookId
     * @return {@link BookAddressDO}
     */
    public List<BookContactsDO> queryByBookId(Long bookId) {
        JPAQuery<BookContactsDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.bookId.eq(bookId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

//    public List<PrdAbContactsPayload> queryTwBookContactsListByBookId(List<Long> bookIdList){
//        return jpaQueryFactory.select(Projections.bean(PrdAbContactsPayload.class,
//                qdo.id,
//                qdo.remark,
//                //qdo.createUserId,
//                //qdo.creator,
//                //qdo.createTime,
//                //qdo.modifyUserId,
//                //qdo.updater,
//                //qdo.modifyTime,
//                // 地址薄id
//                qdo.bookId,
//                // 联系人类型
//                qdo.contactsType,
//                // 联系人姓名
//                qdo.contactsName,
//                // 联系人手机
//                qdo.contactsPhone,
//                // 联系人电话
//                qdo.contactsTelephone,
//                // 邮箱
//                qdo.contactsEmail,
//                // 联系地址
//                qdo.contactsAddress,
//                // 社交账户类型
//                qdo.socialAccountType,
//                // 社交账户
//                qdo.socialAccount,
//                // 部门
//                qdo.contactsDepartment,
//                // 岗位
//                qdo.contactsPosition,
//                // 联系人关系
//                qdo.contactsRelation,
//                // 性别 udc[org:employee:sex]
//                qdo.sex,
//                // 生日
//                qdo.birthday,
//                // 是否是关键决策人
//                qdo.isKeyPerson
//        )).from(qdo).where(qdo.deleteFlag.eq(0)).where(qdo.bookId.in(bookIdList)).fetch();
//    }
}

