package com.elitesland.tw.tw5.server.prd.partner.identity.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 业务伙伴-供应商信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Entity
@Table(name = "com_business_supplier_info", indexes = {
        @Index(name = "index_partner_id", columnList = "partner_id"),
        @Index(name="index_book_id",columnList = "book_id")
})
@org.hibernate.annotations.Table(appliesTo = "com_business_supplier_info", comment = "业务伙伴-供应商信息")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessSupplierInfoDO extends BaseModel implements Serializable {
    /**
     * 业务伙伴id business_partner.id
     */
    @Comment("业务伙伴id")
    @Column(name = "partner_id")
    private Long partnerId;

    /**
     * 地址薄id
     */
    @Comment("地址薄id")
    @Column(name = "book_id")
    private Long bookId;


    /**
     * 供应商编号
     */
    @Comment("供应商编号")
    @Column()
    private String supplierNo;
    /**
     * 供应商状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @Comment("供应商状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    @Column()
    @FieldUpdateLog(fieldName = "供应商状态", selectionKey = "CRM:BUSINESS_PARTNER:STATUS")
    @FieldCreateLog(fieldName = "供应商状态", selectionKey = "CRM:BUSINESS_PARTNER:STATUS")
    private String supplierStatus;
    /**
     * 供应商级别 udc[crm:customer_grade]
     */
    @Comment("供应商级别 udc[crm:customer_grade]")
    @Column()
    @FieldUpdateLog(fieldName = "供应商级别", selectionKey = "crm:customer_grade")
    @FieldCreateLog(fieldName = "供应商级别", selectionKey = "crm:customer_grade")
    private String supplierGradle;
    /**
     * 供应商产品
     */
    @Comment("供应商产品")
    @Column()
    @FieldCreateLog(fieldName = "供应商产品")
    @FieldUpdateLog(fieldName = "供应商产品")
    private String supplierProduct;
    /**
     * 供货开始时间
     */
    @Comment("供货开始时间")
    @Column()
    @FieldCreateLog(fieldName = "供货开始时间")
    @FieldUpdateLog(fieldName = "供货开始时间")
    private LocalDate startTime;
    /**
     * 供货结束时间
     */
    @Comment("供货结束时间")
    @Column()
    @FieldCreateLog(fieldName = "供货结束时间")
    @FieldUpdateLog(fieldName = "供货结束时间")
    private LocalDate endTime;
    /**
     * 结算周期
     */
    @Comment("结算周期")
    @Column()
    @FieldCreateLog(fieldName = "结算周期")
    @FieldUpdateLog(fieldName = "结算周期")
    private String settlementPeriod;
    /**
     * 供货期间说明
     */
    @Comment("供货期间说明")
    @Column()
    @FieldCreateLog(fieldName = "供货期间说明")
    @FieldUpdateLog(fieldName = "供货期间说明")
    private String supplyDescription;

    /**
     * 资质审核资料附件
     */
    @Comment("资质审核资料附件")
    @Column()
    private String fileCode1;

    /**
     * 实地考察资料 附件
     */
    @Comment("实地考察资料")
    @Column()
    private String fileCode2;

    /**
     * 扩展字段1
     */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /**
     * 扩展字段2
     */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /**
     * 扩展字段3
     */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /**
     * 扩展字段4
     */
    @Comment("扩展字段4")
    @Column()
    private String ext4;
    /**
     * 扩展字段5
     */
    @Comment("扩展字段5")
    @Column()
    private String ext5;
    /**
     * 是否同步过JDE
     */
    @Comment("是否同步过JDE")
    @Column()
    private Boolean syncJdeFlag;

    public void copy(BusinessSupplierInfoDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
