package com.elitesland.tw.tw5.server.prd.partner.identity.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessDistributorInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessDistributorInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessDistributorInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessDistributorInfoVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.partner.identity.convert.BusinessDistributorInfoConvert;
import com.elitesland.tw.tw5.server.prd.partner.identity.dao.BusinessDistributorInfoDAO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessDistributorInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessDistributorInfoRepo;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 业务伙伴-经销商信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessDistributorInfoServiceImpl extends BaseServiceImpl implements BusinessDistributorInfoService {

    private final BusinessDistributorInfoRepo businessDistributorInfoRepo;
    private final BusinessDistributorInfoDAO businessDistributorInfoDAO;
    private final FileUtil fileUtil;
//    private final ProductPriceDetailService productPriceDetailService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;

    @Override
    public PagingVO<BusinessDistributorInfoVO> queryPaging(BusinessDistributorInfoQuery query){
        return businessDistributorInfoDAO.queryPaging(query);
    }

    @Override
    public List<BusinessDistributorInfoVO> queryListDynamic(BusinessDistributorInfoQuery query){
        List<BusinessDistributorInfoVO> businessDistributorInfoVOS = businessDistributorInfoDAO.queryListDynamic(query);
        businessDistributorInfoVOS.stream().forEach(vo->{
            vo.setFileDatas1(fileUtil.getFileDatas(vo.getFileCodes1()));
            vo.setFileDatas2(fileUtil.getFileDatas(vo.getFileCodes2()));
         //   vo.setAuthProductDesc(translateAuthProduct(vo.getAuthProduct()));
        });
        return businessDistributorInfoVOS;
    }

    @Override
    public BusinessDistributorInfoVO queryByKey(Long key) {
        BusinessDistributorInfoDO entity = businessDistributorInfoRepo.findById(key).orElseGet(BusinessDistributorInfoDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessDistributorInfoVO vo = BusinessDistributorInfoConvert.INSTANCE.toVo(entity);
        vo.setFileDatas1(fileUtil.getFileDatas(vo.getFileCodes1()));
        vo.setFileDatas2(fileUtil.getFileDatas(vo.getFileCodes2()));
   //     vo.setAuthProductDesc(translateAuthProduct(vo.getAuthProduct()));
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDistributorInfoVO insert(BusinessDistributorInfoPayload payload) {
        BusinessDistributorInfoDO entityDo = BusinessDistributorInfoConvert.INSTANCE.toDo(payload);
        return BusinessDistributorInfoConvert.INSTANCE.toVo(businessDistributorInfoRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDistributorInfoVO update(BusinessDistributorInfoPayload payload) {
        BusinessDistributorInfoDO entity = businessDistributorInfoRepo.findById(payload.getId()).orElseGet(BusinessDistributorInfoDO::new);
        Assert.notNull(entity.getId(), "不存在");
        // 变更日志用
        BusinessDistributorInfoDO entityLog = new BusinessDistributorInfoDO();
        BeanUtils.copyProperties(entity, entityLog);
        BusinessDistributorInfoDO entityDo = BusinessDistributorInfoConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        // 操作记录
        if (null != payload.getPartnerId()) {
            // 授权产品需要自己翻译
//            String productLog = null;
//            if(payload.getAuthProduct()!=null){
//                 productLog = "授权产品由"+translateAuthProduct(entityLog.getAuthProduct())+" 修改为 "+translateAuthProduct(payload.getAuthProduct())+"\n";
//            }
            // 修改NULL值特殊处理
            final StringBuilder fieldsUpdateLog = changeFieldLogUtil.nullFieldsProcess(payload, entityLog, entity);
            //获取变更日志
         //   fieldsUpdateLog.append(productLog+changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
            fieldsUpdateLog.append(changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
            if (org.springframework.util.StringUtils.hasText(fieldsUpdateLog)) {
                logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
            }
        }
        return BusinessDistributorInfoConvert.INSTANCE.toVo(businessDistributorInfoRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessDistributorInfoDAO.deleteSoft(keys);
        }
    }

//    //翻译授权产品
//    public String translateAuthProduct(String authProduct){
//        if(!StringUtils.isEmpty(authProduct)) {
//            List<Long> skuIdList = Arrays.stream(authProduct.split(",")).map(skuId -> Long.valueOf(skuId)).collect(Collectors.toList());
//            List<ProductPriceDetailVO> productPriceDetailVOS = productPriceDetailService.queryListBySkuIds(skuIdList);
//            if(productPriceDetailVOS!=null&&productPriceDetailVOS.size()>0){
//                StringBuilder stringBuilder = new StringBuilder();
//                for(int i=0;i<productPriceDetailVOS.size();i++){
//                    if(i==productPriceDetailVOS.size()-1){
//                        stringBuilder.append(productPriceDetailVOS.get(i).getSkuName());
//                    }else{
//                        stringBuilder.append(productPriceDetailVOS.get(i).getSkuName()+",");
//                    }
//                }
//                return stringBuilder.toString();
//            }
//        }
//        return null;
//    }
}
