package com.elitesland.tw.tw5.server.prd.partner.team.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.partner.team.payload.BusinessTeamMemberPayload;
import com.elitesland.tw.tw5.api.prd.partner.team.query.BusinessTeamMemberQuery;
import com.elitesland.tw.tw5.api.prd.partner.team.vo.BusinessTeamMemberVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessTeamRoleEnum;
import com.elitesland.tw.tw5.server.prd.partner.team.entity.BusinessTeamMemberDO;
import com.elitesland.tw.tw5.server.prd.partner.team.entity.QBusinessTeamMemberDO;
import com.elitesland.tw.tw5.server.prd.partner.team.repo.BusinessTeamMemberRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 业务伙伴-团队成员
 *
 * @author wangly
 * @date 2023-05-16
 */
@Repository
@RequiredArgsConstructor
public class BusinessTeamMemberDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessTeamMemberRepo repo;
    private final QBusinessTeamMemberDO qdo = QBusinessTeamMemberDO.businessTeamMemberDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessTeamMemberVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessTeamMemberVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 业务id
                qdo.objectId,
                // 业务类型
                qdo.type,
                //  用户id
                qdo.userId,
                // 成员名称
                qdo.memberName,
                // 成员角色
                qdo.memberRole,
                // 成员角色名称
                qdo.memberRoleName,
                // 是否为创建者
                qdo.isCreator,
                // 组织id
                qdo.orgId,
                // 维度id
                qdo.dimensionId,
                // 组织改变前ID
                qdo.changeId,
                // 组织名称
                qdo.orgName,
                // 组织编号
                qdo.orgCode,
                // 组织状态
                qdo.orgStatus,
                // 排序号
                qdo.sortNo,
                // 扩展字段1
                qdo.ext1,
                // 扩展字段2
                qdo.ext2,
                // 扩展字段3
                qdo.ext3,
                // 扩展字段4
                qdo.ext4,
                // 扩展字段5
                qdo.ext5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessTeamMemberVO> getJpaQueryWhere(BusinessTeamMemberQuery query) {
        JPAQuery<BusinessTeamMemberVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        //    jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessTeamMemberQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessTeamMemberQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 业务id 精确 */
        if (!ObjectUtils.isEmpty(query.getObjectId())) {
            list.add(qdo.objectId.eq(query.getObjectId()));
        }
        /** 业务id集合 精确 */
        if (!CollectionUtils.isEmpty(query.getObjectIdList())) {
            list.add(qdo.objectId.in(query.getObjectIdList()));
        }
        /** 业务类型 精确 */
        if (!ObjectUtils.isEmpty(query.getType())) {
            list.add(qdo.type.eq(query.getType()));
        }
        /**  用户id 精确 */
        if (!ObjectUtils.isEmpty(query.getUserId())) {
            list.add(qdo.userId.eq(query.getUserId()));
        }
        /** 成员名称 精确 */
        if (!ObjectUtils.isEmpty(query.getMemberName())) {
            list.add(qdo.memberName.eq(query.getMemberName()));
        }
        /** 成员角色 精确 */
        if (!ObjectUtils.isEmpty(query.getMemberRole())) {
            list.add(qdo.memberRole.eq(query.getMemberRole()));
        }
        /** 成员角色名称 精确 */
        if (!ObjectUtils.isEmpty(query.getMemberRoleName())) {
            list.add(qdo.memberRoleName.eq(query.getMemberRoleName()));
        }
        /** 是否为创建者 精确 */
        if (!ObjectUtils.isEmpty(query.getIsCreator())) {
            list.add(qdo.isCreator.eq(query.getIsCreator()));
        }
        /** 组织id 精确 */
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            list.add(qdo.orgId.eq(query.getOrgId()));
        }
        /** 维度id 精确 */
        if (!ObjectUtils.isEmpty(query.getDimensionId())) {
            list.add(qdo.dimensionId.eq(query.getDimensionId()));
        }
        /** 组织改变前ID 精确 */
        if (!ObjectUtils.isEmpty(query.getChangeId())) {
            list.add(qdo.changeId.eq(query.getChangeId()));
        }
        /** 组织名称 精确 */
        if (!ObjectUtils.isEmpty(query.getOrgName())) {
            list.add(qdo.orgName.eq(query.getOrgName()));
        }
        /** 组织编号 精确 */
        if (!ObjectUtils.isEmpty(query.getOrgCode())) {
            list.add(qdo.orgCode.eq(query.getOrgCode()));
        }
        /** 组织状态 精确 */
        if (!ObjectUtils.isEmpty(query.getOrgStatus())) {
            list.add(qdo.orgStatus.eq(query.getOrgStatus()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 扩展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 扩展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 扩展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 扩展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 扩展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessTeamMemberVO queryByKey(Long id) {
        JPAQuery<BusinessTeamMemberVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessTeamMemberVO> queryListDynamic(BusinessTeamMemberQuery query) {
        JPAQuery<BusinessTeamMemberVO> jpaQuery = getJpaQueryWhere(query);
        OrderItem sortNoOrderItem = OrderItem.asc("sortNo");
        OrderItem createTimeOrderItem = OrderItem.desc("createTime");
        List<OrderItem> OrderItemList = new ArrayList<>();
        OrderItemList.add(sortNoOrderItem);
        OrderItemList.add(createTimeOrderItem);
        query.setOrders(OrderItemList);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessTeamMemberVO> queryPaging(BusinessTeamMemberQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<BusinessTeamMemberVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessTeamMemberVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessTeamMemberVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessTeamMemberDO save(BusinessTeamMemberDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessTeamMemberDO> saveAll(List<BusinessTeamMemberDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessTeamMemberPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 业务id
        if (payload.getObjectId() != null) {
            update.set(qdo.objectId, payload.getObjectId());
        }

        // 业务类型
        if (payload.getType() != null) {
            update.set(qdo.type, payload.getType());
        }
        //  用户id
        if (payload.getUserId() != null) {
            update.set(qdo.userId, payload.getUserId());
        }
        // 成员名称
        if (payload.getMemberName() != null) {
            update.set(qdo.memberName, payload.getMemberName());
        }
        // 成员角色
        if (payload.getMemberRole() != null) {
            update.set(qdo.memberRole, payload.getMemberRole());
        }
        // 成员角色名称
        if (payload.getMemberRoleName() != null) {
            update.set(qdo.memberRoleName, payload.getMemberRoleName());
        }
        // 是否为创建者
        if (payload.getIsCreator() != null) {
            update.set(qdo.isCreator, payload.getIsCreator());
        }
        // 组织id
        if (payload.getOrgId() != null) {
            update.set(qdo.orgId, payload.getOrgId());
        }
        // 维度id
        if (payload.getDimensionId() != null) {
            update.set(qdo.dimensionId, payload.getDimensionId());
        }
        // 组织改变前ID
        if (payload.getChangeId() != null) {
            update.set(qdo.changeId, payload.getChangeId());
        }
        // 组织名称
        if (payload.getOrgName() != null) {
            update.set(qdo.orgName, payload.getOrgName());
        }
        // 组织编号
        if (payload.getOrgCode() != null) {
            update.set(qdo.orgCode, payload.getOrgCode());
        }
        // 组织状态
        if (payload.getOrgStatus() != null) {
            update.set(qdo.orgStatus, payload.getOrgStatus());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 扩展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 扩展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 扩展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 扩展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 扩展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 业务id
            if (nullFields.contains("objectId")) {
                update.setNull(qdo.objectId);
            }
            // 业务类型
            if (nullFields.contains("type")) {
                update.setNull(qdo.type);
            }
            //  用户id
            if (nullFields.contains("userId")) {
                update.setNull(qdo.userId);
            }
            // 成员名称
            if (nullFields.contains("memberName")) {
                update.setNull(qdo.memberName);
            }
            // 成员角色
            if (nullFields.contains("memberRole")) {
                update.setNull(qdo.memberRole);
            }
            // 成员角色名称
            if (nullFields.contains("memberRoleName")) {
                update.setNull(qdo.memberRoleName);
            }
            // 是否为创建者
            if (nullFields.contains("isCreator")) {
                update.setNull(qdo.isCreator);
            }
            // 组织id
            if (nullFields.contains("orgId")) {
                update.setNull(qdo.orgId);
            }
            // 维度id
            if (nullFields.contains("dimensionId")) {
                update.setNull(qdo.dimensionId);
            }
            // 组织改变前ID
            if (nullFields.contains("changeId")) {
                update.setNull(qdo.changeId);
            }
            // 组织名称
            if (nullFields.contains("orgName")) {
                update.setNull(qdo.orgName);
            }
            // 组织编号
            if (nullFields.contains("orgCode")) {
                update.setNull(qdo.orgCode);
            }
            // 组织状态
            if (nullFields.contains("orgStatus")) {
                update.setNull(qdo.orgStatus);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 扩展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 扩展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 扩展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 扩展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 扩展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据objectId和角色查询对应的团队成员
     *
     * @param objectId 业务主键
     * @param role 角色
     */
    public List<BusinessTeamMemberVO> queryByObjectIdAndRole(Long objectId,String role){

        return jpaQueryFactory.select(Projections.bean(BusinessTeamMemberVO.class,
                        qdo.id,
                        qdo.type,
                        qdo.userId,
                        qdo.orgId,
                        qdo.memberName)).
                from(qdo).
                where(qdo.objectId.eq(objectId)).
                where(qdo.memberRole.eq(role)).
                where(qdo.deleteFlag.eq(0)).fetch();
    }

    /**
     * 根据角色查询对应的团队成员
     * @param objectIds 业务主键
     * @param role 角色
     */
    public List<BusinessTeamMemberVO> queryByObjectIdsAndRole(List<Long> objectIds,String role){

        return jpaQueryFactory.select(Projections.bean(BusinessTeamMemberVO.class,
                        qdo.id,
                        qdo.type,
                        qdo.userId,
                        qdo.orgId,
                        qdo.memberName)).
                from(qdo).
                where(qdo.objectId.in(objectIds)).
                where(qdo.memberRole.eq(role)).
                where(qdo.deleteFlag.eq(0)).fetch();
    }



    /**
     * 根据objectId和角色查询对应的团队成员
     *
     * @param objectId 业务主键
     */
    public List<BusinessTeamMemberVO> queryByObjectId(Long objectId){

        return jpaQueryFactory.select(Projections.bean(BusinessTeamMemberVO.class,
                        qdo.id,
                        qdo.type,
                        qdo.userId,
                        qdo.orgId,
                        qdo.memberRole,
                        qdo.memberName)).
                from(qdo).
                where(qdo.objectId.eq(objectId)).
                where(qdo.deleteFlag.eq(0)).fetch();
    }
    /**
     * 根据objectId和身份对应的角色更新对应的团队成员角色
     *
     * @param objectId 业务主键
     * @param roleList 身份对应的角色
     */
    public void updateTeamByIdentityChange(Long objectId,List<String> roleList){
        JPAUpdateClause update = jpaQueryFactory.update(qdo).
                set(qdo.memberRole, BusinessTeamRoleEnum.BASE.getCode()).
                set(qdo.memberRoleName, BusinessTeamRoleEnum.BASE.getDesc()).
                where(qdo.objectId.eq(objectId)).
                where(qdo.memberRole.in(roleList)).
                where(qdo.deleteFlag.eq(0));
        update.execute();
    }
    //删除除创建者之外的角色
    public void deleteByObjectIdAndNoCreator(Long objectId){
        JPAUpdateClause update = jpaQueryFactory.update(qdo).
                set(qdo.deleteFlag, 1).
                where(qdo.objectId.eq(objectId)).
                where(qdo.memberRole.ne(BusinessTeamRoleEnum.CREATOR.getCode())).
                where(qdo.deleteFlag.eq(0));
        update.execute();
    }
}

