package com.elitesland.tw.tw5.server.prd.pay.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 支付管理-付款发送记录
 *
 * @author wangly
 * @date 2023-12-12
 */
@Entity
@Table(name = "bk_pay_detail_record", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "bk_pay_detail_record", comment = "支付管理-付款发送记录")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BkPayDetailRecordDO extends BaseModel implements Serializable  {
    /** 付款明细表id */
    @Comment("付款明细表id")
    @Column()
    private Long bkPayDetailId;
    /** 流程实例号 */
    @Comment("流程实例号")
    @Column()
    private String reqnbr;
    /** 事件实例号 */
    @Comment("事件实例号")
    @Column()
    private String evtlst;
    /** 批次编号 */
    @Comment("批次编号")
    @Column()
    private String bthnbr;
    /** 业务参考号 */
    @Comment("业务参考号")
    @Column()
    private String yurref;
    /** 交易流水号 */
    @Comment("交易流水号")
    @Column()
    private String refnbr;
    /** 请求状态:OPR.数据接收中;AUT.等待审批;NTE.终审完毕;APW.银行人工审批;WRF.可疑;BNK.银行处理中。 */
    @Comment("请求状态:OPR.数据接收中;AUT.等待审批;NTE.终审完毕;APW.银行人工审批;WRF.可疑;BNK.银行处理中。")
    @Column()
    private String reqsta;
    /** 交易序号 */
    @Comment("交易序号")
    @Column()
    private String trxseq;
    /** 保留字段 */
    @Comment("保留字段")
    @Column()
    private String rsv100;
    /** 付款 状态：1.待发送 2.待查询 3.待支付 4,支付中  5.成功 6.失败 7.支付退票 */
    @Comment("付款 状态：1.待发送 2.待查询 3.待支付 4,支付中  5.成功 6.失败 7.支付退票")
    @Column()
    private Integer payStatus;
    /** 单据类型：1.代发 2.支付（用于接口区分数据） */
    @Comment("单据类型：1.代发 2.支付（用于接口区分数据）")
    @Column()
    private Integer orderType;
    /** 交易状态：E：失败 A: 登记 S: 成功 */
    @Comment("交易状态：E：失败 A: 登记 S: 成功")
    @Column()
    private String stscod;
    /** 收方开户行名称 */
    @Comment("收方开户行名称")
    @Column()
    private String crtbnk;
    /** 收方开户行地址 */
    @Comment("收方开户行地址")
    @Column()
    private String crtadr;
    /** 收方行联行号 */
    @Comment("收方行联行号")
    @Column()
    private String brdnbr;
    /** 交易金额 */
    @Comment("交易金额")
    @Column()
    private BigDecimal trsamt;
    /** 业务处理结果  ：S 成功 银行支付成功；F 失败 银行支付失败；B 退票 银行支付被退票；R 否决 企业审批否决；D 过期 企业过期不审批；C 撤消 企业撤销；U 银行挂账 */
    @Comment("业务处理结果  ：S 成功 银行支付成功；F 失败 银行支付失败；B 退票 银行支付被退票；R 否决 企业审批否决；D 过期 企业过期不审批；C 撤消 企业撤销；U 银行挂账")
    @Column()
    private String ftnflg;
    /** 银行失败码 */
    @Comment("银行失败码")
    @Column()
    private String errorCode;
    /** 批量标识:1.单条 2.批量  （用于支付接口） */
    @Comment("批量标识:1.单条 2.批量  （用于支付接口）")
    @Column()
    private Integer batchFlag;
    /** 失败原因 */
    @Comment("失败原因")
    @Column()
    private String errorReason;

    public void copy(BkPayDetailRecordDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
