package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.BuProjectMembersPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.BuProjectMembersQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectMembersService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectMembersVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * BU项目成员管理
 *
 * @author carl
 * @date 2023-11-29
 */
@Api(tags = "BU项目成员管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/bu/buProjectMembers")
@Slf4j
public class BuProjectMembersController {

    private final BuProjectMembersService buProjectMembersService;

    /**
     * BU项目成员管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("BU项目成员管理-新增")
    public TwOutputUtil<BuProjectMembersVO> insert(@RequestBody BuProjectMembersPayload payload) {
        return TwOutputUtil.ok(buProjectMembersService.insert(payload));
    }

    /**
     * BU项目成员管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("BU项目成员管理-更新")
    public TwOutputUtil<BuProjectMembersVO> update(@RequestBody BuProjectMembersPayload payload) {
        return TwOutputUtil.ok(buProjectMembersService.insert(payload));
    }

    /**
     * BU项目成员管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("BU项目成员管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BuProjectMembersPayload payload) {
        return TwOutputUtil.ok(buProjectMembersService.updateByKeyDynamic(payload));
    }

    /**
     * BU项目成员管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("BU项目成员管理-主键查询")
    public TwOutputUtil<BuProjectMembersVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(buProjectMembersService.queryByKey(key));
    }

    /**
     * BU项目成员管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("BU项目成员管理-分页")
    public TwOutputUtil<PagingVO<BuProjectMembersVO>> paging(BuProjectMembersQuery query) {
        return TwOutputUtil.ok(buProjectMembersService.queryPaging(query));
    }

    /**
     * BU项目成员管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("BU项目成员管理-查询列表")
    public TwOutputUtil<List<BuProjectMembersVO>> queryList(BuProjectMembersQuery query) {
        return TwOutputUtil.ok(buProjectMembersService.queryListDynamic(query));
    }

    /**
     * BU项目成员管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("BU项目成员管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        buProjectMembersService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

