package com.elitesland.tw.tw5.server.prd.pms.dao;


import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityProcessVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectActivityProcessDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectActivityProcessDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectActivityProcessRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * 项目活动 审批流程
 *
 * @author xxb
 * @date 2023-08-17
 */
@Repository
@RequiredArgsConstructor
public class PmsProjectActivityProcessDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectActivityProcessRepo repo;
    private final QPmsProjectActivityProcessDO qdo = QPmsProjectActivityProcessDO.pmsProjectActivityProcessDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectActivityProcessVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsProjectActivityProcessVO.class,
                qdo.id,
                //qdo.remark,
                qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 项目id
                qdo.projId,
                // 流程定义的KEY
                qdo.procDefKey,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 提交时间
                qdo.submitTime,
                // 审批时间
                qdo.approvedTime,
                // 活动状态
                qdo.activityStatus,
                // 变更前的活动
                qdo.preChangeContent,
                // 版本
                qdo.dataVersion,
                // 变更之后的活动
                qdo.changeContent
        )).from(qdo);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsProjectActivityProcessVO queryByKey(Long id) {
        JPAQuery<PmsProjectActivityProcessVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据项目id查询
     *
     * @param projId 项目id
     * @return 结果
     */
    public List<PmsProjectActivityProcessVO> queryByProjId(Long projId) {
        JPAQuery<PmsProjectActivityProcessVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.projId.eq(projId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 变更工作流相关数据
     *
     * @param
     * @return
     */
    public long updateWorkFlow(PmsProjectActivityProcessDO processDO) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(processDO.getId()));

        // 流程实例id
        if (!ObjectUtils.isEmpty(processDO.getProcInstId())) {
            update.set(qdo.procInstId, processDO.getProcInstId());
        }
        // 审批状态
        if (!ObjectUtils.isEmpty(processDO.getProcInstStatus())) {
            update.set(qdo.procInstStatus, processDO.getProcInstStatus());
        }
        // 提审时间
        if (!ObjectUtils.isEmpty(processDO.getSubmitTime())) {
            update.set(qdo.submitTime, processDO.getSubmitTime());
        }
        // 审批结束时间
        if (!ObjectUtils.isEmpty(processDO.getApprovedTime())) {
            update.set(qdo.approvedTime, processDO.getApprovedTime());
        }
        // 派发状态
        if (!ObjectUtils.isEmpty(processDO.getActivityStatus())) {
            update.set(qdo.activityStatus, processDO.getActivityStatus());
        }
        // 删除标识
        if (!ObjectUtils.isEmpty(processDO.getDeleteFlag())) {
            update.set(qdo.deleteFlag, processDO.getDeleteFlag());
        }
        // 变更后活动
        if (!ObjectUtils.isEmpty(processDO.getChangeContent())) {
            update.set(qdo.changeContent, processDO.getChangeContent());
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}
