package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 旧采购合同
 *
 * @author likunpeng
 * @date 2024-01-03
 */
@Entity
@Table(name = "t_purchase_contract", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_purchase_contract", comment = "旧采购合同")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PurchaseContractDO extends BaseModel implements Serializable  {
    /** 合同状态 */
    @Comment("合同状态")
    @Column()
    private String contractStatus;
    /** 主合同id */
    @Comment("主合同id")
    @Column()
    private Long mainContractId;
    /** 子合同id */
    @Comment("子合同id")
    @Column()
    private Long subContractId;
    /** 供应商id */
    @Comment("供应商id")
    @Column()
    private Long supplierId;
    /** 供应商bu_id */
    @Comment("供应商bu_id")
    @Column()
    private Long supplierBuId;
    /** 签约日期 */
    @Comment("签约日期")
    @Column()
    private LocalDate signDate;
    /** 平台合同类型 */
    @Comment("平台合同类型")
    @Column()
    private String platType;
    /** 采购类型 */
    @Comment("采购类型")
    @Column()
    private String purchaseType;
    /** 采购大类 */
    @Comment("采购大类")
    @Column()
    private String purchaseType1;
    /** 采购小类 */
    @Comment("采购小类")
    @Column()
    private String purchaseType2;
    /** 采购产品 */
    @Comment("采购产品")
    @Column()
    private String productName;
    /** 采购内容简述 */
    @Comment("采购内容简述")
    @Column()
    private String briefDesc;
    /** 合同金额 */
    @Comment("合同金额")
    @Column()
    private BigDecimal amt;
    /** 税率 */
    @Comment("税率")
    @Column()
    private Integer taxRate;
    /** 采购主体bu_id */
    @Comment("采购主体bu_id")
    @Column()
    private Long purchaseBuId;
    /** 签单bu_id */
    @Comment("签单bu_id")
    @Column()
    private Long signBuId;
    /** 销售人员资源id */
    @Comment("销售人员资源id")
    @Column()
    private Long salesmanResId;
    /** 交付bu_id */
    @Comment("交付bu_id")
    @Column()
    private Long deliBuId;
    /** 交付资源id */
    @Comment("交付资源id")
    @Column()
    private Long deliResId;
    /** 激活日期 */
    @Comment("激活日期")
    @Column()
    private LocalDate activateDate;
    /** 关闭日期 */
    @Comment("关闭日期")
    @Column()
    private LocalDate closeDate;
    /** 关闭原因 */
    @Comment("关闭原因")
    @Column()
    private String closeReason;
    /** 币种 */
    @Comment("币种")
    @Column()
    private String currCode;
    /** 是否第三方外包（是/否） */
    @Comment("是否第三方外包（是/否）")
    @Column()
    private Integer thirdPartFlag;
    /** 采购负责人 */
    @Comment("采购负责人")
    @Column()
    private Long purchaseInchargeResId;
    /** 特殊码 */
    @Comment("特殊码")
    @Column()
    private String specCode;
    /** 服务类型（用于区分采购类型和费用参与收益归属问题） */
    @Comment("服务类型（用于区分采购类型和费用参与收益归属问题）")
    @Column()
    private String serviceType;
    /** 采购合同编号 */
    @Comment("采购合同编号")
    @Column()
    private String contractNo;
    /** 采购合同名称 */
    @Comment("采购合同名称")
    @Column()
    private String contractName;
    /** 供应商法人地址簿号 */
    @Comment("供应商法人地址簿号")
    @Column()
    private Long supplierLegalBookId;

    /** 供应商法人地址簿号 */
    @Comment("供应商法人地址簿编号")
    @Column()
    private String supplierLegalNo;

    /** 采购法人地址簿号 */
    @Comment("采购法人地址簿号")
    @Column()
    private Long purchaseLegalBookId;

    /** 采购法人地址簿号 */
    @Comment("采购法人地址簿编号")
    @Column()
    private String purchaseLegalNo;

    /** 审批状态 */
    @Comment("审批状态")
    @Column()
    private String apprStatus;

    public void copy(PurchaseContractDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
