package com.elitesland.tw.tw5.server.prd.purchase.repo;

import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseContractManagerDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import javax.transaction.Transactional;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
public interface PurchaseContractManagerRepo extends JpaRepository<PurchaseContractManagerDO, Long>, JpaSpecificationExecutor<PurchaseContractManagerDO> {

    List<PurchaseContractManagerDO> queryByPurchaseContractIdV4In(List<Long> tw4PurchaseContractIds);

    @Transactional
    @Modifying
    @Query(value = "UPDATE PurchaseContractManagerDO PC \n" +
            "SET PC.CONTRACT_STATUS = 'CLOSE',\n" +
            "PC.MODIFY_TIME = SYSDATE() \n" +
            "WHERE\n" +
            "	PC.CONTRACT_NO IN (\n" +
            "	SELECT\n" +
            "		RLT.CONTRACT_NO \n" +
            "	FROM\n" +
            "		(\n" +
            "		SELECT\n" +
            "			PCM.CONTRACT_NO \n" +
            "		FROM\n" +
            "			PurchaseContractManagerDO PCM,\n" +
            "			PurchasePaymentPlanDO PPP,\n" +
            "			PurchasePaymentDO PP \n" +
            "		WHERE\n" +
            "			PCM.CONTRACT_NO = PPP.CONTRACT_NO -- AND PPP.DOC_TYPE = ''\n" +
            "			\n" +
            "			AND PPP.PAYMENT_APPLY_ID = PP.ID \n" +
            "			AND PPP.DOC_TYPE = 'CONTRACT' \n" +
            "			AND ((\n" +
            "					PP.PAYMENT_APPLICATION_TYPE = 'CONTRACT' \n" +
            "					AND PP.STATE = 'PAID' \n" +
            "					) -- 合同付款 并且 已支付\n" +
            "				\n" +
            "			OR ( PP.PAYMENT_APPLICATION_TYPE = 'ADVANCEPAYWRITEOFF' AND PP.STATE = 'APPROVED' )) -- 预付款核销 并且 已审批\n" +
            "			\n" +
            "			AND PCM.CONTRACT_STATUS = 'ACTIVE' -- 只看采购合同为激活的\n" +
            "			\n" +
            "			AND PCM.DEL_FLAG = 0 \n" +
            "			AND PP.DEL_FLAG = 0 \n" +
            "			AND PPP.DEL_FLAG = 0 \n" +
            "		GROUP BY\n" +
            "			PCM.CONTRACT_NO,\n" +
            "			PCM.AMT \n" +
            "		HAVING\n" +
            "			PCM.AMT = SUM( PPP.PAYMENT_AMT ) \n" +
            "		) RLT \n" +
            "	);",nativeQuery = true)
    int purchaseContractCloseBatch();



    /**
     * 根据采购合同编号查询采购合同
     * @param purchaseConNo 采购合同编号
     * @return 采购合同
     */
    Optional<PurchaseContractManagerDO> findByPurchaseContractNo(String purchaseConNo);

    /**
     * 应付金额计算
     * @param contractId 采购合同id
     * @return 应付金额
     */
    @Query(value = "SELECT " +
            "SUM(IFNULL( PPP.payment_amt, 0 ) - IFNULL( PPP.current_payment_amt, 0 ) + IF( PP.state = 'write_off_part', P2.curr_payment_amt, 0 )) " +
            "AS payable_amt " +
            "FROM t_purchase_payment_plan PPP " +
            "LEFT JOIN t_purchase_payment PP ON PPP.payment_apply_id = PP.id " +
            "LEFT JOIN (SELECT PP2.payment_no, SUM( PP2.curr_payment_amt ) AS curr_payment_amt FROM t_purchase_payment PP2 WHERE PP2.delete_flag = 0 AND PP2.payment_no IS NOT NULL GROUP BY PP2.payment_no ) P2 ON P2.payment_no = PP.payment_no " +
            "WHERE PPP.delete_flag = 0 AND ( PP.state <> 'written_off' OR PP.state IS NULL )" +
            "AND PPP.contract_id = ?1 AND PPP.doc_type = 'contract'" +
            "GROUP BY PPP.contract_id,PPP.contract_no ",nativeQuery = true)
    BigDecimal findPayableAmt(Long contractId);


    /**
     * 应付金额计算
     */
    @Query(value = "SELECT " +
            "amt - IFNULL( sum_amt, 0 ) " +
            "FROM " +
            "t_purchase_contract_manager AS con  " +
            "LEFT JOIN (SELECT SUM(current_payment_amt) AS sum_amt , contract_id " +
                        "FROM t_purchase_payment_plan ppp LEFT JOIN t_purchase_payment pp ON ppp.payment_apply_id = pp.id " +
                        "WHERE ppp.delete_flag = 0 AND ppp.payment_apply_id IS NOT NULL " +
                        "AND ppp.contract_id = ?1 AND pp.payment_application_type <> 'advance_pay_write_off' ) AS plan " +
            "ON con.id = plan.contract_id " +
            "WHERE con.id = ?1 " ,nativeQuery = true)
    BigDecimal findPayableAmtNew(Long contractId);
}
