package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvBatchPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * 合同开票批次
 *
 * @author likunpeng
 * @date 2023-07-19
 */
@Api(tags = "合同开票批次")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/conInvBatch")
@Slf4j
public class ConInvBatchController {

    private final ConInvBatchService conInvBatchService;

    /**
     * 合同开票批次-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    //@GlobalTransactional
    @ApiOperation("合同开票批次-新增")
    public TwOutputUtil<ConInvBatchVO> insert(@RequestBody ConInvBatchPayload payload) {
        return TwOutputUtil.ok(conInvBatchService.insert(payload));
    }

    /**
     * 合同开票批次-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("合同开票批次-更新")
    public TwOutputUtil<ConInvBatchVO> update(@RequestBody ConInvBatchPayload payload) {
        return TwOutputUtil.ok(conInvBatchService.update(payload));
    }

    /**
     * 合同开票批次-更新是否自动开票
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/updateInvFlag")
    @ApiOperation("合同开票批次-更新是否自动开票")
    public TwOutputUtil<ConInvBatchVO> updateInvFlag(@RequestBody ConInvBatchPayload payload) {
        conInvBatchService.updateInvFlag(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 合同开票发起合同开票审批流程
     *
     * @param key 有效载荷
     * @return {@link TwOutputUtil}
     */
    @GetMapping("submit/apply/{key}")
    @ApiOperation("合同开票批次-流程提交")
    public TwOutputUtil<ConInvBatchVO> submit(@PathVariable Long key) {
        conInvBatchService.submitProc(key);
        return TwOutputUtil.ok();
    }


    /**
     * 合同开票批次-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("合同开票批次-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody ConInvBatchPayload payload) {
        return TwOutputUtil.ok(conInvBatchService.updateByKeyDynamic(payload));
    }

    /**
     * 合同开票批次-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("合同开票批次-主键查询")
    public TwOutputUtil<ConInvBatchVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conInvBatchService.queryByKey(key));
    }

    /**
     * 合同开票批次-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("合同开票批次-分页")
    public TwOutputUtil<PagingVO<ConInvBatchVO>> paging(ConInvBatchQuery query) {
        return TwOutputUtil.ok(conInvBatchService.queryPaging(query));
    }

    /**
     * 合同开票批次-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("合同开票批次-查询列表")
    public TwOutputUtil<List<ConInvBatchVO>> queryList(ConInvBatchQuery query) {
        return TwOutputUtil.ok(conInvBatchService.queryListDynamic(query));
    }

    /**
     * 合同开票批次-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("合同开票批次-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        conInvBatchService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @ApiOperation("发票退票流程")
    @PutMapping("/invBatchs/returnTicket")
    public TwOutputUtil returnTicket(@RequestParam("invBatchId") Long invBatchId, @RequestParam("disDisc") String disDisc) {
        try {
            conInvBatchService.returnTicket(invBatchId, disDisc);
            return TwOutputUtil.ok();
        } catch (TwException e) {
            return TwOutputUtil.addTwException(e);
        } catch (Exception e) {
            return TwOutputUtil.addException(e);
        }
    }


    /**
     * 根据批次号查询该批次的合同收款计划列表
     *
     * @param key 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("recvplan/list/{key}")
    @ApiOperation("根据批次号查询该批次的合同收款计划列表")
    public TwOutputUtil queryRecvplanList(@PathVariable Long key) {
        return TwOutputUtil.ok(conInvBatchService.queryRecvplanList(key));
    }


    /**
     * 根据客户id查询历史开票记录，且主合同一致的放最前面
     *
     * @param custId
     * @param contractId
     * @return
     */
    @ApiOperation("根据客户id查询历史开票记录，且主合同一致的放最前面")
    @GetMapping("/invBatchs/getHistoryInv")
    public TwOutputUtil getHistoryInv(@RequestParam("custId") Long custId, @RequestParam("contractId") Long contractId) {
        return TwOutputUtil.ok(conInvBatchService.getHistoryInv(custId, contractId));
    }

    /**
     * 合同开票 -- 完成开票
     *
     * @param payload
     * @return
     */
    @PatchMapping("/invBatchs/completeInvBatch")
    public TwOutputUtil completeInvBatch(@RequestBody ConInvBatchPayload payload) {
        return TwOutputUtil.ok(conInvBatchService.completeInvBatch(payload));
    }

    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @GetMapping("/batchExport")
    public void batchExport(HttpServletResponse response, ConInvBatchQuery query) {
        conInvBatchService.downloadBatch(response, query);
    }


    /**
     * 已开票待收款记录退回到开票退回状态
     *
     * @param ids
     * @return
     */
    @GetMapping("/reject/{ids}")
    public TwOutputUtil reject(@PathVariable Long[] ids) {
        if (ids == null || ids.length < 0) {
            return TwOutputUtil.error("", "参数不能为空！", "");
        }
        String msg = conInvBatchService.reject(ids);
        if (StringUtils.hasText(msg)) {
            return TwOutputUtil.error("", msg, null);
        }
        return TwOutputUtil.ok();
    }


}

