package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivableDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivableQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivableDService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivableService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivableVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.prd.my.repo.TaskAuthorizedRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConReceivableConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvBatchDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivableDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivablePlanDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvBatchInvdtlDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivableDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivableRepo;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 合同收款
 *
 * @author lemon
 * @date 2023-08-31
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConReceivableServiceImpl implements ConReceivableService {

    private final PrdMessageConfigService messageConfigService;
    private final ConReceivableRepo conReceivableRepo;
    private final ConReceivableDAO conReceivableDAO;
    private final ConReceivablePlanDAO conReceivablePlanDAO;

    private final ConReceivableDService  conReceivableDService;
    private final ConReceivablePlanRepo planRepo;
    private final ConReceivablePlanDAO planDAO;
    private final ConInvBatchDAO invBatchDAO;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService prdOrgOrganizationService;

    private final PrdOrgSyncLogDAO daoLog;
    private final HttpUtil httpUtil;
//    @Value("${tw4.url}")
//    private String tw4_url;

    @Value("${tw4.sale.conReceivable}")
    private String conReceivable;


    @Override
    public PagingVO<ConReceivableVO> queryPaging(ConReceivableQuery query){
        return conReceivableDAO.queryPaging(query);
    }

    @Override
    public List<ConReceivableVO> queryListDynamic(ConReceivableQuery query){
        return conReceivableDAO.queryListDynamic(query);
    }

    @Override
    public ConReceivableVO queryByKey(Long key) {
        ConReceivableVO vo = conReceivableDAO.queryByKey(key);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insert(ConReceivablePayload payload) {
        ConReceivableDO conReceivableDO = insertContractRecv(payload);
        log.debug("开始生成邮件：：：：：：：：");
        // todo 收款计划批量生成分配规则
        // 发送收款录入通知邮件
        Long invBatchId = payload.getSourceId();//通过开票批次id查询收款计划
        ConReceivablePlanVO conReceivablePlanVO = conReceivablePlanDAO.queryByInvBatchId(invBatchId);
        PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode("MC20231127001501");
        Map<String, Object> result = new HashMap<>();
        result.put("custName", conReceivablePlanVO.getCustName());
        result.put("contractName", conReceivablePlanVO.getSaleConName());
        result.put("phaseDesc", conReceivablePlanVO.getReceStage());
        result.put("recvDate", conReceivableDO.getRecvDate().toString());
        result.put("recvAmt", conReceivableDO.getRecvAmt()==null?BigDecimal.valueOf(0).setScale(2):conReceivableDO.getRecvAmt().setScale(2, RoundingMode.HALF_UP));
        // 通知人列表
        List<String> noticeSourceList = new ArrayList<>();
        if(conReceivablePlanVO.getSaleManUserId()!=null){
            noticeSourceList.add(conReceivablePlanVO.getSaleManUserId()+"");
        }else{
            log.error("","销售负责人缺失，无法将收款录入邮件发送给销售负责人！");
        }
        if(conReceivablePlanVO.getDeliUserId()!=null) {
            noticeSourceList.add(conReceivablePlanVO.getDeliUserId() + "");
        }else{
            log.error("","交付负责人缺失，无法将收款录入邮件发送给交付负责人！");
        }
        if(conReceivablePlanVO.getCreateUserId()!=null) {
            noticeSourceList.add(conReceivablePlanVO.getCreateUserId() + "");
        }else{
            log.error("","开票发起人缺失，无法将收款录入邮件发送给开票发起人！");
        }
        if(conReceivablePlanVO.getPmUserId()!=null) {
            noticeSourceList.add(conReceivablePlanVO.getPmUserId() + "");
        }else{
            log.error("","项目经理缺失，无法将收款录入邮件发送给项目经理！");
        }
        // 先获取交付BU,查询bu负责人
        if(conReceivablePlanVO.getDeliBuId()!=null) {
            PrdOrgOrganizationVO prdOrgOrganizationVO = prdOrgOrganizationService.queryDetailSimpleByOrgId(conReceivablePlanVO.getDeliBuId());
            Long manageId = prdOrgOrganizationVO.getManageId();
            noticeSourceList.add(manageId+"");
        }else{
            log.error("","交付BU负责人缺失，无法将收款录入邮件发送给交负责人！");
        }
        // 先获取签单bu,查询bu负责人
        Long signBuId = conReceivablePlanVO.getSignBuId();
        if (signBuId !=null){
            PrdOrgOrganizationVO prdOrgOrganizationVO = prdOrgOrganizationService.queryDetailSimpleByOrgId(signBuId);
            Long manageId = prdOrgOrganizationVO.getManageId();
            noticeSourceList.add(manageId+"");
        }else{
            log.error("","签单BU负责人缺失，无法将收款录入邮件发送给签单BU负责人！");
        }
        log.debug("签单bu负责人列表：：：：："+noticeSourceList);
        if (!ObjectUtils.isEmpty(noticeSourceList)) {
            String noticeSource = String.join(",", noticeSourceList);
            log.debug("发送邮件：：：：："+noticeSource);
            messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSource);
            log.debug("发送邮件完成：：：：："+noticeSource);
        }
        return 1;
    }

    public ConReceivableDO insertContractRecv(ConReceivablePayload payload) {
        // 收款金额校验
        validateRecvAmt(payload);
        ConReceivableDO entityDo = ConReceivableConvert.INSTANCE.toDo(payload);
        ConReceivableDO save = conReceivableRepo.save(entityDo);//保存数据
        for (ConReceivableDPayload recvd : payload.getDetailList()) {
            recvd.setRecvId(save.getId());
            conReceivableDService.insert(recvd);
            planRepo.increamentActualRecvAmt(recvd.getRecvplanId(), recvd.getRecvAmt(), payload.getRecvDate());
            planRepo.setRecvStatus(recvd.getRecvplanId(), "3");
            setInvBatchStatus(recvd.getRecvplanId());
        }
        return save;
    }
    public void validateRecvAmt(ConReceivablePayload entity) {
        BigDecimal recvdAmtSum = new BigDecimal("0.00");
        List<ConReceivableDPayload> recvds = entity.getDetailList();
        for (ConReceivableDPayload recvd : recvds) {
            recvdAmtSum = recvdAmtSum.add(recvd.getRecvAmt());
        }
        if (recvdAmtSum.compareTo(entity.getRecvAmt()) != 0) {
            throw TwException.error("","收款明细表金额:" + recvdAmtSum + "与" + "收款主表金额:" + entity.getRecvAmt() + "不相等。");
        }
    }

    private void setInvBatchStatus(long recvPlanId) {
        ConReceivablePlanVO planVO = planDAO.queryByKey(recvPlanId);
        Long invBatchId = planVO.getInvBatchId();
        if (invBatchId != null) {
            ConReceivablePlanQuery planQuery = new ConReceivablePlanQuery();
            planQuery.setInvBatchId(invBatchId);
            List<ConReceivablePlanVO> plans = planDAO.queryListDynamic(planQuery);
            boolean isComplete = true;
            if (plans != null) {
                for (val plan : plans) {
                    if (!plan.getReceStatus().equals("3")) {
                        invBatchDAO.updateBatchStatusById(invBatchId, "6");
                        isComplete = false;
                        break;
                    }
                }
                if (isComplete) {
                    invBatchDAO.updateBatchStatusById(invBatchId, "7");
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConReceivableVO update(ConReceivablePayload payload) {
        ConReceivableDO entity = conReceivableRepo.findById(payload.getId()).orElseGet(ConReceivableDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConReceivableDO entityDo = ConReceivableConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConReceivableConvert.INSTANCE.toVo(conReceivableRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(ConReceivablePayload payload) {
        ConReceivableDO entity = conReceivableRepo.findById(payload.getId()).orElseGet(ConReceivableDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = conReceivableDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conReceivableDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional
    public Integer updateRecvAccount(Long invId, String accountNo, String ledgerDate) {
        conReceivableDAO.updateRecvAccount(invId, accountNo, ledgerDate);
        return 1;
    }

    /**
     * 同步4.0
     * @param param
     */
    @Override
    public void syncConReceivableTo4(String param) {
        String syncType = "con_receivable_to4";
        LocalDateTime syncTime;
        if(StringUtils.hasText(param)){
            syncTime = LocalDateTime.parse(param);
        }else{
            syncTime = daoLog.queryOrgSyncLog(syncType);
            if(syncTime == null){
                syncTime = LocalDateTime.of(2023, 11, 1, 0, 0);
            }else{
                //将同步时间提前30秒，防止拉数据遗漏
                syncTime = syncTime.minusSeconds(30);
            }
        }
        XxlJobLogger.log("合同收款同步到4.0开始...");
        XxlJobLogger.log("syncContractInvBatchTo4 localDateTime：" + syncTime);

        // 查询待同步数据
        String format = DateUtil.format(syncTime, "yyyy-MM-dd HH:mm:ss");
        List<ConReceivableDO> conReceivableDOS = conReceivableRepo.findByModifyTimeStart(format);
        // 同步内容
        String syncData = "";
        LocalDateTime syncNow = LocalDateTime.now();
        if (!ObjectUtils.isEmpty(conReceivableDOS)) {
            Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            int failNum = 0;
            for (ConReceivableDO temDo : conReceivableDOS) {
                LocalDateTime syncStartTime = LocalDateTime.now();
                try {
                    Map<String, Object> map = BeanUtil.beanToMap(temDo);
                    map.put("delFlag",temDo.getDeleteFlag());
                    // 翻译创建人与更新人
                    map.put("createUserId", v4AndV5UserIds.get(temDo.getCreateUserId()));
                    map.put("modifyUserId", v4AndV5UserIds.get(temDo.getModifyUserId()));
//                    String resultMain = httpUtil.sendPost(tw4_url + conReceivable, map);
//                    Map<String, Object> data = (Map) JSON.parse(resultMain);
                    Map<String, Object> data = new HashMap<>();
                    if ((data.get("ok") + "").equals("true")) {
                        Long idV4 = Long.parseLong(data.get("datum").toString());
                        conReceivableRepo.updateConReceivableIdV4(idV4, temDo.getId());
                    } else{
                        LocalDateTime syncEndTime = LocalDateTime.now();
                        this.saveSyncLog(syncType + "_exception", "合同收款id" + temDo.getId() + "同步异常，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "详情：" + data.get("datum"), null);
                        //更新该条合同的更新时间，下一次处理;
                        conReceivableRepo.updateRemark(temDo.getId());
                        failNum++;
                    }
                } catch (Exception e) {
                    XxlJobLogger.log("合同收款" + temDo.getRecvNo() + "同步异常......" + e);
                    LocalDateTime syncEndTime = LocalDateTime.now();
                    this.saveSyncLog(syncType + "_exception", "合同收款id" + temDo.getId() + "同步异常，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "详情：" + e, null);
                    failNum++;
                    //更新该条合同的更新时间，下一次处理;
                    conReceivableRepo.updateRemark(temDo.getId());
                }
            }
            syncData = "更新了" + (conReceivableDOS.size() - failNum) + "数据,有" + failNum + "条数据更新失败！";
        } else {
            syncData = "合同收款数据未变化";
        }
        // 记录同步日志
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, syncData, syncNow);
        XxlJobLogger.log("同步合同收款发票结束..." + logDO);
    }
    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime){
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        return logDO;
    }

}
