package com.elitesland.tw.tw5.server.prd.schedule.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdActivityCalendarPayload;
import com.elitesland.tw.tw5.api.prd.schedule.query.PrdActivityCalendarQuery;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdActivityCalendarService;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdActivityCalendarAbleVO;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdActivityCalendarVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

@Api(tags = "活动日历")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/prdActivityCalendar")
@Slf4j
public class PrdActivityCalendarController {

    private final PrdActivityCalendarService prdActivityCalendarService;

    /**
     * 活动日历-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("活动日历-新增")
    public TwOutputUtil<PrdActivityCalendarVO> insert(@RequestBody @Validated PrdActivityCalendarPayload payload) {
        return TwOutputUtil.ok(prdActivityCalendarService.insert(payload));
    }

    /**
     * 活动日历-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("活动日历-更新")
    public TwOutputUtil<PrdActivityCalendarVO> update(@RequestBody PrdActivityCalendarPayload payload) {
        return TwOutputUtil.ok(prdActivityCalendarService.update(payload));
    }

    /**
     * 活动日历-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("活动日历-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PrdActivityCalendarPayload payload) {
        return TwOutputUtil.ok(prdActivityCalendarService.updateByKeyDynamic(payload));
    }

    /**
     * 活动日历-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("活动日历-主键查询")
    public TwOutputUtil<PrdActivityCalendarVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(prdActivityCalendarService.queryByKey(key));
    }

    /**
     * 活动日历-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("活动日历-分页")
    public TwOutputUtil<PagingVO<PrdActivityCalendarVO>> paging(PrdActivityCalendarQuery query) {
        return TwOutputUtil.ok(prdActivityCalendarService.queryPaging(query));
    }

    /**
     * 活动日历-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("活动日历-查询列表")
    public TwOutputUtil<List<PrdActivityCalendarVO>> queryList(PrdActivityCalendarQuery query) {
        return TwOutputUtil.ok(prdActivityCalendarService.queryListDynamic(query));
    }

    /**
     * 活动日历-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("活动日历-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        prdActivityCalendarService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 活动日历-查询列表APP
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list/all")
    @UdcNameClass
    @ApiOperation("活动日历-查询列表APP")
    public TwOutputUtil<PrdActivityCalendarAbleVO> queryAllList(PrdActivityCalendarQuery query) {
        return TwOutputUtil.ok(prdActivityCalendarService.queryList(query));
    }

    /**
     * 活动日历-同步企业微信日程
     *
     * @param
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/syncSchedule")
    @ApiOperation("活动日历-同步企业微信日程")
    public TwOutputUtil syncSchedule(Long id, String type) {
        prdActivityCalendarService.syncSchedule(id, type);
        return TwOutputUtil.ok();
    }


}

