package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldObjRoleFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldVO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemPermissionFieldDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * TODO
 *
 * @author : JS
 * @date 2023/10/11
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemPermissionFieldDAO {

    private final JPAQueryFactory jpaQueryFactory;

    private final QPrdSystemPermissionFieldDO qdo = QPrdSystemPermissionFieldDO.prdSystemPermissionFieldDO;

    public void deleteByIds(List<Long> ids){
        jpaQueryFactory.delete(qdo)
                .where(qdo.id.in(ids).and(qdo.deleteFlag.eq(0)))
                .execute();
    }

    public void deleteByFunctionObjectIds(List<Long> functionObjectIds){
        jpaQueryFactory.delete(qdo)
                .where(qdo.functionObjectId.in(functionObjectIds).and(qdo.deleteFlag.eq(0)))
                .execute();
    }

    /**
     * 根据功能对象ID查询字段
     * @param functionObjectId
     * @return
     */
    public List<PrdSystemPermissionFieldVO> queryByFunctionObjectId(Long functionObjectId) {
        JPAQuery<PrdSystemPermissionFieldVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.functionObjectId.eq(functionObjectId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }


    /**
     * 拼接查询字段
     *
     * @return JPAQuery 对象
     */
    private JPAQuery<PrdSystemPermissionFieldVO> getJpaQuerySelect(){
        return jpaQueryFactory.select(Projections.bean(PrdSystemPermissionFieldVO.class,
                qdo.id,
                qdo.fieldType,
                qdo.field,
                qdo.fieldName,
                qdo.fieldTypeName,
                qdo.showType,
                qdo.showTypeName,
                qdo.showAttr,
                qdo.functionObjectId
        )).from(qdo);
    }

    /**
     * 根据功能对象ID集合查询字段
     * @param functionObjectIds
     * @return
     */
    public List<PrdSystemPermissionFieldVO> queryByFunctionObjectIds(Set<Long> functionObjectIds) {
        JPAQuery<PrdSystemPermissionFieldVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.functionObjectId.in(functionObjectIds));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }
}
