package com.elitesland.tw.tw5.server.prd.system.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 评价表
 *
 * @author duwh
 * @date 2022/11/22
 */
@Entity
@Table(name = "prd_comment")
@org.hibernate.annotations.Table(appliesTo = "prd_comment", comment = "评价表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdCommentDO extends BaseModel {


    @Comment("业务类型：枚举：经营计划：OPER_PLAN  ....")
    @Column()
    private String objType;

    @Comment("业务主键")
    @Column()
    private Long objId;

    @Column(
        name = "content",
        columnDefinition = "varchar(4000) comment '评论回复内容' "
    )
    private String content;

    @Column(
        name = "ann_user_ids",
        columnDefinition = "varchar(2000) comment '安特@用户id集合 英文逗号隔开 11,22,33' "
    )
    private String annUserIds;

    @Comment("评论人主键")
    @Column()
    private Long userId;

    @Comment("评论人姓名 冗余")
    @Column()
    private String userName;

    @Comment("评论人头像 冗余")
    @Column()
    private String userLogo;

    @Comment("回复对象主键")
    @Column()
    private Long replyId;

    @Comment("回复人主键")
    @Column()
    private Long replyUserId;

    @Comment("回复人姓名 冗余")
    @Column()
    private String replyUserName;

    @Comment("回复人头像 冗余")
    @Column()
    private String replyUserLogo;

    @Column(
        name = "zan_num",
        columnDefinition = "int(10) default '0' comment '点赞数量' "
    )
    private Integer zanNum = 0;

    @Column(
        name = "collect_num",
        columnDefinition = "int(10) default '0' comment '收藏数量' "
    )
    private Integer collectNum = 0;

    @Comment("状态 预留")
    @Column()
    private String status;

    @Comment("ip 预留")
    @Column()
    private String ip;

    @Comment("地点 预留")
    @Column()
    private String place;

    @Comment("拓展1")
    @Column()
    private String ext1;

    @Comment("拓展2")
    @Column()
    private String ext2;

    @Comment("拓展3")
    @Column()
    private String ext3;

    @Comment("拓展4")
    @Column()
    private String ext4;

    @Comment("拓展5")
    @Column()
    private String ext5;


    public PrdCommentDO() {
    }

    public void copy(PrdCommentDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
