package com.elitesland.tw.tw5.server.prd.system.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;

/**
 * 阶梯毛利率设置
 *
 * @author likunpeng
 * @date 2023-04-03
 */
@Entity
@Table(name = "prd_system_gross_margin", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_system_gross_margin", comment = "阶梯毛利率设置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemGrossMarginDO extends BaseModel implements Serializable  {
    /** BU_ID */
    @Comment("BU_ID")
    @Column()
    private Long buId;
    /** 年度 */
    @Comment("年度")
    @Column()
    private Integer yearly;
    /** 合同金额 */
    @Comment("合同金额")
    @Column()
    private BigDecimal amt;
    /** BU负责人ID */
    @Comment("BU负责人ID")
    @Column()
    private Long buDirectorId;
    /** BU毛利率 */
    @Comment("BU毛利率")
    @Column()
    private Integer buGrossMargin;
    /** 阶梯毛利率1 */
    @Comment("阶梯毛利率1")
    @Column()
    private Integer ladderGrossMargin1;
    /** 阶梯负责人1ID */
    @Comment("阶梯负责人1ID")
    @Column()
    private Long ladderDirectorId1;
    /** 阶梯毛利率2 */
    @Comment("阶梯毛利率2")
    @Column()
    private Integer ladderGrossMargin2;
    /** 阶梯负责人2ID */
    @Comment("阶梯负责人2ID")
    @Column()
    private Long ladderDirectorId2;

    public void copy(PrdSystemGrossMarginDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
