package com.elitesland.tw.tw5.server.prd.system.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 数据权限规则明细
 *
 * @Author Bill
 * @Date 2023/9/25 13:27
 **/
@Entity
@Table(name = "prd_system_permission_rule_detail")
@org.hibernate.annotations.Table(appliesTo = "prd_system_permission_rule_detail", comment = "数据权限规则明细")
@Data
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PrdSystemPermissionRuleDetailDO extends BaseModel {

    private static final long serialVersionUID = -4437819233981658592L;

    @Comment("规则主键")
    @Column(name = "rule_id")
    private Long ruleId;

    @Comment("规则明细编号")
    @Column(name = "rule_detail_code")
    private String ruleDetailCode;

    @Comment("规则属性")
    @Column(name = "rule_field")
    private String ruleField;

    @Comment("规则条件类型")
    @Column(name = "rule_condition_type")
    private String ruleConditionType;

    @Comment("规则条件")
    @Column(name = "rule_condition")
    private String ruleCondition;

    @Comment("规则值")
    @Column(name = "rule_value")
    private String ruleValue;

    @Comment("规则值名称")
    @Column(name = "rule_value_name")
    private String ruleValueName;

    @Comment("规则属性名称")
    @Column(name = "rule_field_name")
    private String ruleFieldName;

    @Comment("自定义sql")
    @Column(name = "rule_sql")
    private String ruleSql;

    @Comment("业务类型")
    @Column(name = "show_type")
    private String showType;

    @Comment("业务属性")
    @Column(name = "show_attr")
    private String showAttr;

    @Comment("是否下钻")
    @Column(name = "deep")
    private Integer deep;

    public void copy(PrdSystemPermissionRuleDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
