/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayload;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmBusitripApplyService;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocStatusEnum;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimTaskKey;
import com.elitesland.tw.tw5.server.prd.inv.common.InvoiceReimStatusEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/ACC_TRIP/callBack"})
@Transactional
public class AccReimTripOrNotCallbackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(AccReimTripOrNotCallbackController.class);
    private final AccReimService accReimService;
    private final InvInvoiceService invInvoiceService;
    private final AdmBusitripApplyService busitripApplyService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        String taskKey = payload.getTaskKey();
        String businessKey = payload.getBusinessKey();
        AccReimPayload accReimPayload = new AccReimPayload();
        accReimPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        AccReimVO accReimVO = this.accReimService.queryByKey(accReimPayload.getId());
        if (StringUtils.hasText((String)accReimVO.getProcTaskKey()) && accReimVO.getProcTaskKey().equals(taskKey)) {
            accReimPayload.setReimStatus(AccReimDocStatusEnum.PENDING_RECEIVE.getCode());
        }
        if (AccReimTaskKey.Activity_0irtcqu.getCode().equals(taskKey)) {
            accReimPayload.setFinPicApprTime(LocalDateTime.now());
        }
        if (AccReimTaskKey.Activity_09og85d.getCode().equals(taskKey) || AccReimTaskKey.Activity_0irtcqu.getCode().equals(taskKey)) {
            accReimPayload.setReimStatus(AccReimDocStatusEnum.FINANCIAL_AUDIT.getCode());
        }
        this.accReimService.partialUpdate(accReimPayload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        Long reimId = Long.valueOf(businessKey);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        AccReimPayload accReimPayload = new AccReimPayload();
        accReimPayload.setId(reimId);
        AccReimVO accReimVO = this.accReimService.queryOneByKey(reimId);
        if (!ObjectUtils.isEmpty((Object)accReimVO)) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    accReimPayload.setReimStatus(AccReimDocStatusEnum.CREATE.getCode());
                    accReimPayload.setApprStatus(ProcInstStatus.NOTSUBMIT.name());
                    break;
                }
                case INTERRUPT: {
                    this.invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.NEW.getCode());
                    this.busitripApplyService.unbindReim(reimId);
                    break;
                }
                case INVALID: {
                    accReimPayload.setApprStatus(ProcInstStatus.INVALID.name());
                    accReimPayload.setReimStatus(AccReimDocStatusEnum.CREATE.getCode());
                    accReimPayload.setDeleteFlag(Integer.valueOf(1));
                    this.invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.NEW.getCode());
                    this.busitripApplyService.unbindReim(reimId);
                    break;
                }
                case REJECTED: {
                    accReimPayload.setApprStatus(ProcInstStatus.REJECTED.name());
                    accReimPayload.setReimStatus(AccReimDocStatusEnum.CREATE.getCode());
                    String taskDefKey = payload.getCommentInfo().getTaskDefKey();
                    if (!AccReimTaskKey.Activity_09og85d.getCode().equals(taskDefKey)) break;
                    accReimPayload.setFinRejectFlag(Integer.valueOf(1));
                    break;
                }
                case APPROVED: {
                    accReimPayload.setApprStatus(ProcInstStatus.APPROVED.name());
                    accReimPayload.setReimStatus(AccReimDocStatusEnum.PENDING_CHARGE.getCode());
                    this.invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.APPROVED.getCode());
                    break;
                }
                case APPROVING: {
                    accReimPayload.setApprStatus(ProcInstStatus.APPROVING.name());
                }
            }
            this.accReimService.partialUpdate(accReimPayload);
        }
        return WorkflowResult.success(null);
    }

    public AccReimTripOrNotCallbackController(AccReimService accReimService, InvInvoiceService invInvoiceService, AdmBusitripApplyService busitripApplyService) {
        this.accReimService = accReimService;
        this.invInvoiceService = invInvoiceService;
        this.busitripApplyService = busitripApplyService;
    }
}

