/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpenseaPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpenseaQuery;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpenseaDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpenseaRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPotentialCustomerRepo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class CrmOpenseaDAO {
    private final CrmOpenseaRepo repo;
    private final CrmPotentialCustomerRepo potentialCustomerRepo;

    public CrmOpenseaDO save(CrmOpenseaDO ado) {
        return (CrmOpenseaDO)((Object)this.repo.save((Object)ado));
    }

    public List<CrmOpenseaDO> saveAll(List<CrmOpenseaDO> dos) {
        return this.repo.saveAll(dos);
    }

    public Specification<CrmOpenseaDO> getSpec(CrmOpenseaQuery query) {
        Specification & Serializable querySpecifi = (Specification & Serializable)(root, criteriaQuery, cb) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (!StringUtils.isEmpty((CharSequence)query.getOpenseaName())) {
                predicates.add(cb.like(root.get("openseaName").as(String.class), SqlUtil.toSqlLikeString(query.getOpenseaName())));
            }
            Join adminJoin = root.join("openseaAdmins", JoinType.LEFT);
            if (!ObjectUtils.isEmpty((Object)query.getOpenseaAdminId())) {
                predicates.add(cb.equal(adminJoin.get("userId").as(Long.class), (Object)query.getOpenseaAdminId()));
            }
            Join memberJoin = root.join("openseaMembers", JoinType.LEFT);
            if (!ObjectUtils.isEmpty((Object)query.getOpenseaMemberId())) {
                predicates.add(cb.equal(memberJoin.get("userId").as(Long.class), (Object)query.getOpenseaMemberId()));
            }
            criteriaQuery.distinct(true);
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };
        return querySpecifi;
    }

    public List<CrmOpenseaDO> findAll(Specification<CrmOpenseaDO> spec) {
        return this.repo.findAll(spec);
    }

    public Page<CrmOpenseaDO> findAll(Specification<CrmOpenseaDO> spec, Pageable pageable) {
        pageable = PageUtil.defaultSort(pageable);
        return this.repo.findAll(spec, pageable);
    }

    public CrmOpenseaDO queryById(Long id) {
        return this.repo.findById(id).orElse(null);
    }

    public CrmOpenseaDO queryByName(String openseaName) {
        return this.repo.findDistinctByOpenseaName(openseaName).orElse(null);
    }

    public void updateByKeyDynamic(CrmOpenseaPayload payload) {
        CrmOpenseaDO OpenseaDO = this.repo.findById(payload.getId()).orElse(null);
        if (OpenseaDO != null) {
            if (payload.getOpenseaName() != null) {
                OpenseaDO.setOpenseaName(payload.getOpenseaName());
            }
            if (payload.getCustomerNum() != null) {
                OpenseaDO.setCustomerNum(payload.getCustomerNum());
            }
            if (payload.getDeleteFlag() != null) {
                OpenseaDO.setDeleteFlag(payload.getDeleteFlag());
            }
            this.repo.save((Object)OpenseaDO);
        }
    }

    public void deleteSoft(List<Long> keys) {
        for (Long key : keys) {
            CrmOpenseaPayload payload = new CrmOpenseaPayload();
            payload.setId(key);
            payload.setDeleteFlag(Integer.valueOf(1));
            this.updateByKeyDynamic(payload);
        }
    }

    public Integer countPotentialCustomers(Long openseaId) {
        return this.potentialCustomerRepo.countByOpensea_Id(openseaId);
    }

    public CrmOpenseaDAO(CrmOpenseaRepo repo, CrmPotentialCustomerRepo potentialCustomerRepo) {
        this.repo = repo;
        this.potentialCustomerRepo = potentialCustomerRepo;
    }
}

