/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PersonProjectExperienceQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonProjectExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonProjectExperienceVO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.PersonProjectExperienceConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.PersonProjectExperienceDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonProjectExperienceDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PersonProjectExperienceServiceImpl
implements PersonProjectExperienceService {
    private static final Logger log = LoggerFactory.getLogger(PersonProjectExperienceServiceImpl.class);
    private final PersonProjectExperienceDAO personProjectExperienceDAO;

    public void saveAll(List<PersonProjectExperienceVO> projectExperienceVOList, Long personId) {
        if (projectExperienceVOList != null) {
            if (projectExperienceVOList.size() == 0) {
                this.personProjectExperienceDAO.deleteByPersonId(personId);
            } else {
                for (PersonProjectExperienceVO personProjectExperienceVO : projectExperienceVOList) {
                    if (personProjectExperienceVO.getPersonId() != null) continue;
                    personProjectExperienceVO.setPersonId(personId);
                }
                this.personProjectExperienceDAO.saveAll(PersonProjectExperienceConvert.INSTANCE.toDos(projectExperienceVOList));
            }
        }
    }

    public List<PersonProjectExperienceVO> findAllByPersonId(Long personId) {
        List<PersonProjectExperienceDO> personEduExperienceDOList = this.personProjectExperienceDAO.findAllByPersonId(personId);
        return PersonProjectExperienceConvert.INSTANCE.toVos(personEduExperienceDOList);
    }

    public void deleteAllByPersonId(Long personId) {
        this.personProjectExperienceDAO.deleteByPersonId(personId);
    }

    public PagingVO<PersonProjectExperienceVO> queryPaging(PersonProjectExperienceQuery query) {
        return this.personProjectExperienceDAO.queryPaging(query);
    }

    public PersonProjectExperienceServiceImpl(PersonProjectExperienceDAO personProjectExperienceDAO) {
        this.personProjectExperienceDAO = personProjectExperienceDAO;
    }
}

