/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.callback;

import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.server.prd.my.convert.UserVacationApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.UserVacationApplyDetailConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDetailDO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/RES_VACATION/callBack"})
@Transactional
public class UserVacationApplyWorkFlowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(UserVacationApplyWorkFlowCallBackController.class);
    private final UserVacationApplyDAO userVacationApplyDAO;
    private final UserVacationApplyDetailDAO userVacationApplyDetailDAO;
    private final PmsTimesheetService timesheetService;
    private final UserVacationDAO userVacationDAO;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        Long applyId = Long.valueOf(businessKey);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        UserVacationApplyPayload userVacationApplyPayload = new UserVacationApplyPayload();
        userVacationApplyPayload.setId(applyId);
        Integer opertType = 0;
        UserVacationApplyDO applyDO = null;
        switch (procInstStatus) {
            case NOTSUBMIT: {
                userVacationApplyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                break;
            }
            case INTERRUPT: {
                userVacationApplyPayload.setProcInstStatus(ProcInstStatus.INTERRUPT);
                break;
            }
            case INVALID: {
                userVacationApplyPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                userVacationApplyPayload.setDeleteFlag(Integer.valueOf(1));
                break;
            }
            case REJECTED: {
                userVacationApplyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                break;
            }
            case APPROVED: {
                applyDO = this.userVacationApplyDAO.findById(applyId);
                if (!ObjectUtils.isEmpty((Object)applyDO.getVacationId()) && !ObjectUtils.isEmpty((Object)applyDO.getVacationDays())) {
                    this.userVacationDAO.updateUsedDays(applyDO.getVacationId(), applyDO.getVacationDays());
                }
                userVacationApplyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                userVacationApplyPayload.setApprovedTime(LocalDateTime.now());
                opertType = 1;
                break;
            }
            case APPROVING: {
                userVacationApplyPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                opertType = -1;
            }
        }
        if (opertType >= 0) {
            List<UserVacationApplyDetailDO> vacationApplyDetailDOS = this.userVacationApplyDetailDAO.findByApplyId(applyId);
            List<UserVacationApplyDetailPayload> detailPayloads = UserVacationApplyDetailConvert.INSTANCE.dosToPayloads(vacationApplyDetailDOS);
            if (applyDO == null) {
                applyDO = this.userVacationApplyDAO.findById(applyId);
            }
            UserVacationApplyPayload applyPayload = UserVacationApplyConvert.INSTANCE.doToPayload(applyDO);
            applyPayload.setApplyDetailPayloadList(detailPayloads);
            this.timesheetService.updateVacationPrivateTimesheet(applyPayload, opertType);
        }
        this.userVacationApplyDAO.updateProcData(userVacationApplyPayload);
        return WorkflowResult.success(null);
    }

    public UserVacationApplyWorkFlowCallBackController(UserVacationApplyDAO userVacationApplyDAO, UserVacationApplyDetailDAO userVacationApplyDetailDAO, PmsTimesheetService timesheetService, UserVacationDAO userVacationDAO) {
        this.userVacationApplyDAO = userVacationApplyDAO;
        this.userVacationApplyDetailDAO = userVacationApplyDetailDAO;
        this.timesheetService = timesheetService;
        this.userVacationDAO = userVacationDAO;
    }
}

