/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ProjShQuery;
import com.elitesland.tw.tw5.api.prd.my.query.ProjectQuery;
import com.elitesland.tw.tw5.api.prd.my.query.ResActivityQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TaskQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetBiweeklyQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetPlanQuery;
import com.elitesland.tw.tw5.api.prd.my.service.ProjShService;
import com.elitesland.tw.tw5.api.prd.my.service.ProjectService;
import com.elitesland.tw.tw5.api.prd.my.service.ResActivityService;
import com.elitesland.tw.tw5.api.prd.my.service.TaskService;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetPlanService;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectAndTaskVO;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectVO;
import com.elitesland.tw.tw5.api.prd.my.vo.ResActivityVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetPlanVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.repo.TransferUtilRepo;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.constant.ProjectEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetPlanConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetPlanDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetPlanDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyReadFlagRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetPlanRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TimesheetPlanServiceImpl
implements TimesheetPlanService {
    private static final Logger log = LoggerFactory.getLogger(TimesheetPlanServiceImpl.class);
    private final TimesheetPlanRepo timesheetPlanRepo;
    private final ProjectService projectService;
    private final TaskService taskService;
    private final ResActivityService resActivityService;
    private final JPAQueryFactory jpaQueryFactory;
    private final CacheUtil cacheUtil;
    private final TimesheetBiweeklyRepo timesheetBiweeklyRepo;
    private final ProjShService projShService;
    private final TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo;
    private final HttpUtil httpUtil;
    private final PrdOrgSyncLogDAO daoLog;
    private final TransferUtilRepo transferUtilRepo;

    public PagingVO<TimesheetPlanVO> paging(TimesheetPlanQuery query) {
        Page page = this.timesheetPlanRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetPlanConvert.INSTANCE::toVo));
    }

    public List<TimesheetPlanVO> queryList(TimesheetPlanQuery query) {
        return TimesheetPlanConvert.INSTANCE.toVoList(this.timesheetPlanRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    private List<TimesheetPlanDO> queryDoList(TimesheetPlanQuery query) {
        return this.timesheetPlanRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    public TimesheetPlanVO queryByKey(Long key) {
        TimesheetPlanDO entity = this.timesheetPlanRepo.findById(key).orElseGet(TimesheetPlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TimesheetPlanVO vo = TimesheetPlanConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetPlanVO insert(TimesheetPlanPayload payload) {
        payload.setTsUserId(GlobalUtil.getLoginUserId());
        this.check(payload);
        this.dataProcess(payload);
        LocalDate workDate = payload.getWorkDate();
        int yearWeek = Integer.parseInt(DateUtil.getYearWeek(workDate));
        int lastYearWeek = Integer.parseInt(DateUtil.getYearWeek(workDate.minusWeeks(1L)));
        this.biweeklyReadFlagRepo.updateReadFlag(payload.getTsUserId(), 0);
        TimesheetPlanDO entityDo = TimesheetPlanConvert.INSTANCE.toDo(payload);
        return TimesheetPlanConvert.INSTANCE.toVo((TimesheetPlanDO)((Object)this.timesheetPlanRepo.save((Object)entityDo)));
    }

    private void check(TimesheetPlanPayload payload) {
        LocalDate workDate = payload.getWorkDate();
        if (!(!workDate.isBefore(LocalDate.now()) || workDate.isEqual(LocalDate.now()) || payload.getExt5() != null && payload.getExt5().equals("EMPTY"))) {
            throw TwException.error("", "\u53ea\u5141\u8bb8\u63d0\u4ea4\u4eca\u5929\u53ca\u4ee5\u540e\u7684\u8ba1\u5212\uff01");
        }
        if (null == payload.getProjId()) {
            throw TwException.error("", "\u53c2\u6570\u5f02\u5e38\uff1aprojId");
        }
        if (null == payload.getTaskId()) {
            throw TwException.error("", "\u53c2\u6570\u5f02\u5e38\uff1ataskId");
        }
    }

    private void dataProcess(TimesheetPlanPayload payload) {
        if (payload.getWorkDate() != null) {
            payload.setYearWeek(Integer.valueOf(Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate()))));
            payload.setWeekStartDate(DateUtil.getStartWeekDay(payload.getWorkDate()));
        }
        if (null != payload.getProjId()) {
            ProjectVO projectVO = this.projectService.queryByProjIdV4(payload.getProjId());
            if (!StringUtils.hasText((String)payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        if (null != payload.getTaskId()) {
            TaskVO taskVO = this.taskService.queryByTaskIdV4(payload.getTaskId());
            if (!StringUtils.hasText((String)payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqva()) {
                payload.setEqva(null != taskVO ? taskVO.getEqvaQty() : BigDecimal.ZERO);
            }
        }
        if (null != payload.getActId()) {
            ResActivityVO resActivityVO = this.resActivityService.queryByActivityIdV4(payload.getActId());
            if (!StringUtils.hasText((String)payload.getActNo())) {
                payload.setActNo(null != resActivityVO ? resActivityVO.getActNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getActName())) {
                payload.setActName(null != resActivityVO ? resActivityVO.getActName() : "");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetPlanVO update(TimesheetPlanPayload payload) {
        TimesheetPlanDO entity = this.timesheetPlanRepo.findById(payload.getId()).orElseGet(TimesheetPlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        this.dataProcess(payload);
        TimesheetPlanDO entityDo = TimesheetPlanConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetPlanConvert.INSTANCE.toVo((TimesheetPlanDO)((Object)this.timesheetPlanRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetPlanRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetPlanDO entity = (TimesheetPlanDO)((Object)((Object)optional.get()));
                    String taskApplyStatus = entity.getTaskApplyStatus();
                    if (StringUtils.hasText((String)taskApplyStatus) && taskApplyStatus.equals(TaskStatusEnum.DISPATCH.getCode())) {
                        throw TwException.error("", "\u5ba1\u6279\u4e2d\u4e0d\u53ef\u4ee5\u5220\u9664\u6570\u636e\uff0c\u5fc5\u987b\u8981\u57284.0\u4e2d\u3010\u6211\u63d0\u4ea4\u7684\u6d41\u7a0b\u4e2d\u3011\u8fdb\u884c\u64a4\u56de\uff0c\u5220\u9664\u4ee5\u540e\u624d\u53ef\u4ee5\u57285.0\u4e2d\u5220\u9664");
                    }
                    TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
                    timesheetBiweeklyQuery.setYearWeek(entity.getYearWeek());
                    timesheetBiweeklyQuery.setTsUserId(entity.getTsUserId());
                    Long count = this.timesheetBiweeklyRepo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, timesheetBiweeklyQuery, criteriaBuilder));
                    if (count > 0L) {
                        throw TwException.error("", "\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u4e0d\u53ef\u4ee5\u5220\u9664");
                    }
                }
            });
            this.timesheetPlanRepo.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByYearWeek(Integer yeerWeek, Long loginUserId) {
        if (null != yeerWeek) {
            LocalDateTime now = LocalDateTime.now();
            QTimesheetPlanDO qTimesheetPlanDO = QTimesheetPlanDO.timesheetPlanDO;
            JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)qTimesheetPlanDO).set(qTimesheetPlanDO.deleteFlag, (Object)1).set((Path)qTimesheetPlanDO.updater, (Object)GlobalUtil.getLoginUserName()).set(qTimesheetPlanDO.modifyTime, (Object)now).where(new Predicate[]{qTimesheetPlanDO.yearWeek.eq((Object)yeerWeek)}).where(new Predicate[]{qTimesheetPlanDO.tsUserId.eq((Object)loginUserId)});
            update.execute();
        }
    }

    public List<ProjectAndTaskVO> listProjAndTask(String keyword, String type, boolean test) {
        List projectList;
        ArrayList<ProjectAndTaskVO> list = new ArrayList<ProjectAndTaskVO>();
        ProjectQuery projectQuery = new ProjectQuery();
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setEffectiveEqva(new BigDecimal("0.05"));
        ProjectQuery projectOperQuery = new ProjectQuery();
        if (StringUtils.hasText((String)keyword)) {
            projectQuery.setKeyword(keyword);
            taskQuery.setKeyword(keyword);
            projectOperQuery.setKeyword(keyword);
        }
        ArrayList<String> taskStatusList = new ArrayList<String>();
        taskStatusList.add(TaskStatusEnum.ACTIVE.getCode());
        taskStatusList.add(TaskStatusEnum.DISPATCH.getCode());
        taskQuery.setTaskStatusList(taskStatusList);
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (!test) {
            taskQuery.setReceiverUserId(loginUserId);
        }
        if (!StringUtils.hasText((String)type) || StringUtils.hasText((String)type) && type.equals("TASK")) {
            List taskList = this.taskService.queryListForSelect(taskQuery);
            if (!CollectionUtils.isEmpty((Collection)taskList)) {
                ResActivityQuery resActivityQuery = new ResActivityQuery();
                List activityVOList = this.resActivityService.queryList(resActivityQuery);
                taskList.forEach(projectAndTaskVO -> {
                    List resActivityVOList = activityVOList.stream().filter(resActivityVO -> resActivityVO.getTaskId().equals(projectAndTaskVO.getTaskIdV4())).collect(Collectors.toList());
                    projectAndTaskVO.setActivityList(resActivityVOList);
                });
            }
            list.addAll(taskList);
        }
        Long defaultOrgIdByUserId = this.cacheUtil.getDefaultOrgIdByUserId(loginUserId);
        projectOperQuery.setExt2("" + defaultOrgIdByUserId);
        projectOperQuery.setExt1(ProjectEnum.OPER.getCode());
        List projectOperList = this.projectService.queryListForSelect(projectOperQuery);
        list.addAll(projectOperList);
        projectQuery.setProjStatus("ACTIVE");
        projectQuery.setProjIdV4NotEqual(Long.valueOf(0L));
        if ((!StringUtils.hasText((String)type) || StringUtils.hasText((String)type) && type.equals("PROJ")) && !CollectionUtils.isEmpty((Collection)(projectList = this.projectService.queryListForSelect(projectQuery)))) {
            ProjShQuery projShQuery = new ProjShQuery();
            projShQuery.setUserId(loginUserId);
            List projShVOS = this.projShService.queryList(projShQuery);
            if (!CollectionUtils.isEmpty((Collection)projShVOS)) {
                Set projIdList = projShVOS.stream().map(projShVO -> projShVO.getProjId()).collect(Collectors.toSet());
                List projectNoOperList = projectList.stream().filter(projectAndTaskVO -> {
                    boolean flag;
                    boolean bl = flag = !StringUtils.hasText((String)projectAndTaskVO.getExt1()) || !projectAndTaskVO.getExt1().equals("OPER");
                    if (flag && projIdList.contains(projectAndTaskVO.getProjIdV4())) {
                        projectAndTaskVO.setMyProject(Boolean.valueOf(true));
                    }
                    return flag;
                }).collect(Collectors.toList());
                list.addAll(projectNoOperList);
            } else {
                List projectNoOperList = projectList.stream().filter(projectAndTaskVO -> !StringUtils.hasText((String)projectAndTaskVO.getExt1()) || !projectAndTaskVO.getExt1().equals("OPER")).collect(Collectors.toList());
                list.addAll(projectNoOperList);
            }
        }
        return list;
    }

    public List<TimesheetPlanVO> batchInsert(TimesheetPlanListPayload payload) {
        ArrayList<TimesheetPlanVO> list = new ArrayList<TimesheetPlanVO>();
        List timesheetPlanList = payload.getTimesheetPlanList();
        if (!CollectionUtils.isEmpty((Collection)timesheetPlanList)) {
            timesheetPlanList.forEach(timesheetPlanPayload -> list.add(this.insert((TimesheetPlanPayload)timesheetPlanPayload)));
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<TimesheetPlanVO> copyLastWeek(String date) {
        LocalDate localDate = LocalDate.now();
        if (StringUtils.hasText((String)date)) {
            localDate = LocalDate.parse(date);
        }
        LocalDate lastWeekDate = localDate.plusDays(-7L);
        int yearWeek = Integer.parseInt(DateUtil.getYearWeek(localDate));
        String lastYearWeek = DateUtil.getYearWeek(lastWeekDate);
        TimesheetPlanQuery timesheetPlanQuery = new TimesheetPlanQuery();
        timesheetPlanQuery.setYearWeek(Integer.valueOf(Integer.parseInt(lastYearWeek)));
        Long loginUserId = GlobalUtil.getLoginUserId();
        timesheetPlanQuery.setTsUserId(loginUserId);
        List<TimesheetPlanDO> timesheetPlanDOS = this.queryDoList(timesheetPlanQuery);
        TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
        timesheetBiweeklyQuery.setYearWeek(Integer.valueOf(yearWeek));
        timesheetBiweeklyQuery.setTsUserId(loginUserId);
        Long count = this.timesheetBiweeklyRepo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, timesheetBiweeklyQuery, criteriaBuilder));
        if (count > 0L) {
            throw TwException.error("", "\u5de5\u4f5c\u8ba1\u5212\u63d0\u4ea4\u540e\u4e0d\u53ef\u4fee\u6539");
        }
        this.deleteSoftByYearWeek(yearWeek, loginUserId);
        ArrayList<TimesheetPlanVO> result = new ArrayList<TimesheetPlanVO>();
        if (!CollectionUtils.isEmpty(timesheetPlanDOS)) {
            timesheetPlanDOS.forEach(timesheetPlanDO -> {
                TimesheetPlanDO entity = new TimesheetPlanDO();
                cn.hutool.core.bean.BeanUtil.copyProperties((Object)timesheetPlanDO, (Object)((Object)entity), (String[])new String[0]);
                entity.setId(null);
                entity.setCreateTime(LocalDateTime.now());
                entity.setCreator(GlobalUtil.getLoginUserName());
                entity.setCreateUserId(loginUserId);
                entity.setModifyTime(LocalDateTime.now());
                entity.setModifyUserId(loginUserId);
                entity.setUpdater(GlobalUtil.getLoginUserName());
                LocalDate workDate = timesheetPlanDO.getWorkDate();
                if (null != workDate) {
                    LocalDate nextWeekWorkDate = workDate.plusDays(7L);
                    entity.setWorkDate(nextWeekWorkDate);
                    entity.setYearWeek(Integer.parseInt(DateUtil.getYearWeek(nextWeekWorkDate)));
                    entity.setWeekStartDate(DateUtil.getStartWeekDay(nextWeekWorkDate));
                    entity.setExt1("\u590d\u5236\u4e0a\u5468");
                }
                TimesheetPlanDO save = (TimesheetPlanDO)((Object)((Object)this.timesheetPlanRepo.save((Object)entity)));
                result.add(TimesheetPlanConvert.INSTANCE.toVo(save));
            });
        }
        return result;
    }

    public void syncWorkPlanTo4(String param) {
        LocalDateTime syncTime = LocalDateTime.now();
        XxlJobLogger.log((String)"\u5de5\u4f5c\u8ba1\u5212\u540c\u6b65\u52304.0\u5f00\u59cb...", (Object[])new Object[0]);
        XxlJobLogger.log((String)("syncWorkPlanTo4 localDateTime\uff1a" + syncTime), (Object[])new Object[0]);
        LocalDate today = LocalDate.now();
        List<TimesheetPlanDO> timesheetPlanDOS = this.timesheetPlanRepo.queryWorkPlanList(today);
        LocalDateTime syncNow = LocalDateTime.now();
        ArrayList<TimesheetPlanDO> workPlanList = new ArrayList<TimesheetPlanDO>();
        for (TimesheetPlanDO timesheetPlanDO : timesheetPlanDOS) {
            TimesheetPlanDO workPlanDo = new TimesheetPlanDO();
            workPlanDo.setId(timesheetPlanDO.getId());
            workPlanDo.setProjId(timesheetPlanDO.getProjId());
            workPlanDo.setTaskId(timesheetPlanDO.getTaskId());
            workPlanDo.setWorkDesc(timesheetPlanDO.getWorkDesc());
            workPlanDo.setWorkDate(timesheetPlanDO.getWorkDate());
            workPlanDo.setActId(timesheetPlanDO.getActId());
            workPlanDo.setLabel(timesheetPlanDO.getLabel());
            List<Long> longs = this.transferUtilRepo.queryEmployeeTw4Ids(Arrays.asList(timesheetPlanDO.getTsUserId()));
            if (!CollectionUtils.isEmpty(longs)) {
                workPlanDo.setTsUserId(longs.get(0));
            }
            workPlanList.add(workPlanDo);
        }
        String syncData = "";
        syncData = !CollectionUtils.isEmpty(workPlanList) ? this.pushWorkPlanTo4(workPlanList) : "\u5de5\u4f5c\u8ba1\u5212\u6570\u636e\u672a\u53d8\u5316!";
        String syncType = "work_plan_to4";
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, syncData, syncNow);
        XxlJobLogger.log((String)("\u540c\u6b65\u5de5\u4f5c\u8ba1\u5212\u7ed3\u675f..." + logDO), (Object[])new Object[0]);
    }

    private String pushWorkPlanTo4(List<TimesheetPlanDO> workPlanList) {
        int failCount = 0;
        for (TimesheetPlanDO workPlanDo : workPlanList) {
            String syncData;
            LocalDateTime syncStartTime = LocalDateTime.now();
            try {
                Map<String, Object> map = BeanUtil.beanToMap((Object)workPlanDo);
                HashMap data = new HashMap();
                if (("" + data.get("ok")).equals("true")) continue;
                LocalDateTime syncEndTime = LocalDateTime.now();
                syncData = "\u5de5\u4f5c\u8ba1\u5212id=" + workPlanDo.getId() + "\u540c\u6b65\u5931\u8d25\uff0c" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "\u54cd\u5e94\u7ed3\u679c\uff1a" + data;
                String syncType = "work_plan_to4";
                XxlJobLogger.log((String)syncData, (Object[])new Object[0]);
                this.saveSyncLog(syncType + "_exception", syncData, null);
                ++failCount;
            }
            catch (Exception e) {
                XxlJobLogger.log((String)("\u5de5\u4f5c\u8ba1\u5212\u540c\u6b65id\u4e3a" + workPlanDo.getId() + ", \u5de5\u4f5c\u8ba1\u5212\u540c\u6b65\u5f02\u5e38......" + e), (Object[])new Object[0]);
                LocalDateTime syncEndTime = LocalDateTime.now();
                String syncType = "work_plan_to4";
                syncData = "\u5de5\u4f5c\u8ba1\u5212id=" + workPlanDo.getId() + "\u540c\u6b65\u5f02\u5e38\uff0c" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "\u8be6\u60c5\uff1a" + e;
                this.saveSyncLog(syncType + "_exception", syncData, null);
                ++failCount;
            }
        }
        String syncDatalog = "\u66f4\u65b0\u4e86" + (workPlanList.size() - failCount) + "\u6570\u636e,\u6709" + failCount + "\u6761\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01";
        return syncDatalog;
    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        this.daoLog.save(logDO);
        return logDO;
    }

    public TimesheetPlanServiceImpl(TimesheetPlanRepo timesheetPlanRepo, ProjectService projectService, TaskService taskService, ResActivityService resActivityService, JPAQueryFactory jpaQueryFactory, CacheUtil cacheUtil, TimesheetBiweeklyRepo timesheetBiweeklyRepo, ProjShService projShService, TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo, HttpUtil httpUtil, PrdOrgSyncLogDAO daoLog, TransferUtilRepo transferUtilRepo) {
        this.timesheetPlanRepo = timesheetPlanRepo;
        this.projectService = projectService;
        this.taskService = taskService;
        this.resActivityService = resActivityService;
        this.jpaQueryFactory = jpaQueryFactory;
        this.cacheUtil = cacheUtil;
        this.timesheetBiweeklyRepo = timesheetBiweeklyRepo;
        this.projShService = projShService;
        this.biweeklyReadFlagRepo = biweeklyReadFlagRepo;
        this.httpUtil = httpUtil;
        this.daoLog = daoLog;
        this.transferUtilRepo = transferUtilRepo;
    }
}

