/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationPayload;
import com.elitesland.tw.tw5.api.prd.my.query.UserVacationQuery;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.UserVacationConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationDO;
import com.elitesland.tw.tw5.server.prd.my.repo.UserVacationRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UserVacationServiceImpl
implements UserVacationService {
    private static final Logger log = LoggerFactory.getLogger(UserVacationServiceImpl.class);
    private final UserVacationDAO userVacationDAO;
    private final UserVacationRepo repo;
    private final PrdOrgEmployeeService employeeService;
    private final CacheUtil cacheUtil;
    private final UdcUtil udcUtil;
    private final ExcelUtil excelUtil;

    public void save(UserVacationPayload payload) {
        PrdOrgEmployeeVO employeeVO;
        if (payload.getTotalDays().compareTo(payload.getUsedDays()) < 0) {
            throw TwException.error("", "\u53ef\u7528\u5929\u6570\u4e0d\u80fd\u5927\u4e8e\u603b\u5929\u6570");
        }
        if (payload.getUserId() != null && Objects.equals((employeeVO = this.cacheUtil.getEmployee(payload.getUserId())).getExtString6(), "EXTERNAL_RES")) {
            throw TwException.error("", "\u5916\u90e8\u8d44\u6e90\u4e0d\u53ef\u7ef4\u62a4\u5047\u671f");
        }
        this.userVacationDAO.save(UserVacationConvert.INSTANCE.payloadToDo(payload));
    }

    public PagingVO<UserVacationVO> page(UserVacationQuery query) {
        PagingVO<UserVacationVO> pagingVO = this.userVacationDAO.queryPaging(query);
        if (pagingVO.getTotal() > 0L) {
            List userVacationList = pagingVO.getRecords();
            this.calculateAvailableDay(userVacationList);
            pagingVO.setRecords(userVacationList);
        }
        return pagingVO;
    }

    public List<UserVacationVO> list(UserVacationQuery query) {
        List<UserVacationVO> userVacationList = this.userVacationDAO.list(query);
        if (!CollectionUtils.isEmpty(userVacationList)) {
            this.calculateAvailableDay(userVacationList);
        }
        return userVacationList;
    }

    public void calculateAvailableDay(List<UserVacationVO> userVacationList) {
        userVacationList.forEach(userVacationVO -> {
            if ("ANNUAL".equals(userVacationVO.getVacationType()) || "ANNUAL_W".equals(userVacationVO.getVacationType())) {
                BigDecimal totalDays = userVacationVO.getTotalDays();
                BigDecimal usedDays = userVacationVO.getUsedDays();
                LocalDate startDate = userVacationVO.getStartDate();
                LocalDate endDate = userVacationVO.getEndDate();
                BigDecimal workDays = new BigDecimal(0);
                LocalDate today = LocalDate.now();
                workDays = new BigDecimal(today.toEpochDay() - startDate.toEpochDay() + 1L);
                if (today.isAfter(userVacationVO.getEndDate())) {
                    workDays = new BigDecimal(userVacationVO.getEndDate().toEpochDay() - startDate.toEpochDay() + 1L);
                }
                BigDecimal actDays = new BigDecimal(endDate.toEpochDay() - startDate.toEpochDay() + 1L);
                BigDecimal actYearDays = actDays.multiply(totalDays).divide(new BigDecimal(365), 0, RoundingMode.DOWN);
                BigDecimal availableDays = workDays.multiply(totalDays).divide(new BigDecimal(365), 0, RoundingMode.DOWN).subtract(usedDays);
                userVacationVO.setActYearDays(actYearDays);
                userVacationVO.setAvailableDays(availableDays);
                userVacationVO.setFrozenDay(actYearDays.subtract(availableDays).subtract(usedDays));
            } else {
                BigDecimal totalDays = userVacationVO.getTotalDays();
                BigDecimal usedDays = userVacationVO.getUsedDays();
                BigDecimal availableDays = totalDays.subtract(usedDays);
                userVacationVO.setAvailableDays(availableDays);
            }
        });
    }

    public UserVacationVO queryById(Long id) {
        UserVacationDO userVacationDO = this.userVacationDAO.queryById(id);
        return UserVacationConvert.INSTANCE.doToVo(userVacationDO);
    }

    @Transactional
    public void delete(Long[] ids) {
        this.userVacationDAO.deleteByIds(Arrays.asList(ids));
    }

    @Transactional
    public void updateExpirationBatch(List<UserVacationPayload> payloadList) {
        for (UserVacationPayload payload : payloadList) {
            this.userVacationDAO.updateExpirationDate(payload);
        }
    }

    public List<UserVacationVO> getAvailableVacation(Long userId, Long vacationId) {
        List availableVacationVOList = this.userVacationDAO.getAvailableVacation(userId);
        this.calculateAvailableDay(availableVacationVOList);
        availableVacationVOList = this.udcUtil.translateList(availableVacationVOList);
        if (vacationId != null) {
            availableVacationVOList.removeIf(userVacationVO -> (userVacationVO.getAvailableDays().compareTo(new BigDecimal(0)) < 1 || userVacationVO.getExpirationDate().isBefore(LocalDate.now())) && !Objects.equals(userVacationVO.getId(), vacationId));
        } else {
            availableVacationVOList.removeIf(userVacationVO -> userVacationVO.getAvailableDays().compareTo(new BigDecimal(0)) < 1 || userVacationVO.getExpirationDate().isBefore(LocalDate.now()));
        }
        return availableVacationVOList;
    }

    @Transactional
    public void deleteAllByUserId(Long userId) {
        this.userVacationDAO.deleteAllByUserId(userId);
    }

    public void tmpDownload(HttpServletResponse response) {
        Workbook workbook = this.getVol();
        String fileName = "\u5047\u671f\u5bfc\u5165\u6a21\u677f-" + LocalDate.now();
        ExcelUtil.writeResponse(response, fileName, workbook);
    }

    @Transactional
    public String importBatch(MultipartFile file, Boolean force) {
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet("\u5047\u671f\u7ba1\u7406");
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        int dataStartRow = 1;
        ArrayList<UserVacationPayload> payloadList = new ArrayList<UserVacationPayload>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); ++i) {
            String usedDays;
            String totalDays;
            String expirationDate;
            String endDate;
            String startDate;
            PrdSystemSelectionVO prdSystemSelectionVisitGradeVO;
            Row row = sheet.getRow(i);
            UserVacationPayload userVacationPayload = new UserVacationPayload();
            String userName = ExcelUtil.getCellFormatValue(row.getCell(1));
            Long userId = this.cacheUtil.getUserIdByName(userName);
            if (userId == null) {
                throw TwException.error("", "\u7b2c" + (i + 1) + "\u884c\u5458\u5de5\u672a\u67e5\u8be2\u5230\uff0c\u8bf7\u786e\u8ba4");
            }
            userVacationPayload.setUserId(userId);
            userVacationPayload.setVacationYear(Long.valueOf(ExcelUtil.getCellFormatValue(row.getCell(2))));
            String vacationType = ExcelUtil.getCellFormatValue(row.getCell(3));
            if (StringUtils.hasText((String)vacationType) && (prdSystemSelectionVisitGradeVO = this.cacheUtil.transferSystemObjByName("org:vacation_type", vacationType)) != null) {
                userVacationPayload.setVacationType(prdSystemSelectionVisitGradeVO.getSelectionValue());
            }
            if (StringUtils.hasText((String)(startDate = ExcelUtil.getCellFormatValue(row.getCell(4))))) {
                userVacationPayload.setStartDate(LocalDate.parse(startDate));
            }
            if (StringUtils.hasText((String)(endDate = ExcelUtil.getCellFormatValue(row.getCell(5))))) {
                userVacationPayload.setEndDate(LocalDate.parse(endDate));
            }
            if (StringUtils.hasText((String)(expirationDate = ExcelUtil.getCellFormatValue(row.getCell(6))))) {
                userVacationPayload.setExpirationDate(LocalDate.parse(expirationDate));
            }
            if (StringUtils.hasText((String)(totalDays = ExcelUtil.getCellFormatValue(row.getCell(7))))) {
                userVacationPayload.setTotalDays(new BigDecimal(totalDays));
            }
            if (StringUtils.hasText((String)(usedDays = ExcelUtil.getCellFormatValue(row.getCell(8))))) {
                userVacationPayload.setUsedDays(new BigDecimal(usedDays));
            }
            userVacationPayload.setRemark(ExcelUtil.getCellFormatValue(row.getCell(9)));
            payloadList.add(userVacationPayload);
        }
        if (!CollectionUtils.isEmpty(payloadList)) {
            List<UserVacationDO> userVacationDOS = UserVacationConvert.INSTANCE.payloadListToDoList(payloadList);
            this.repo.saveAll(userVacationDOS);
        }
        return "";
    }

    public Workbook getVol() {
        ClassPathResource classPathResource = new ClassPathResource("template/userVacationBatch.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            return workbook;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveRewardLeave(UserVacationPayload payload) {
        UserVacationDO vacationDO = this.repo.findByReasonIdAndReasonTypeAndUserId(payload.getReasonId(), payload.getReasonType(), payload.getUserId());
        if (!ObjectUtils.isEmpty((Object)((Object)vacationDO))) {
            BigDecimal totalDays = payload.getTotalDays().add(vacationDO.getTotalDays());
            vacationDO.setTotalDays(totalDays);
            this.userVacationDAO.save(vacationDO);
        } else {
            this.userVacationDAO.save(UserVacationConvert.INSTANCE.payloadToDo(payload));
        }
    }

    public UserVacationServiceImpl(UserVacationDAO userVacationDAO, UserVacationRepo repo, PrdOrgEmployeeService employeeService, CacheUtil cacheUtil, UdcUtil udcUtil, ExcelUtil excelUtil) {
        this.userVacationDAO = userVacationDAO;
        this.repo = repo;
        this.employeeService = employeeService;
        this.cacheUtil = cacheUtil;
        this.udcUtil = udcUtil;
        this.excelUtil = excelUtil;
    }
}

