/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsMaConfigPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsMaConfigQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsMaConfigVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsMaConfigDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsMaConfigDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsMaConfigRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsMaConfigDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsMaConfigRepo repo;
    private final QPmsMaConfigDO qdo = QPmsMaConfigDO.pmsMaConfigDO;

    private JPAQuery<PmsMaConfigVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsMaConfigVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.sortIndex, this.qdo.projectStage, this.qdo.keyTask})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsMaConfigVO> getJpaQueryWhere(PmsMaConfigQuery query) {
        JPAQuery<PmsMaConfigVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        ArrayList<OrderItem> orderse = new ArrayList<OrderItem>();
        orderse.add(OrderItem.asc((String)"sortIndex"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, orderse));
        return jpaQuery;
    }

    public long count(PmsMaConfigQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PmsMaConfigQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSortIndex())) {
            list.add(this.qdo.sortIndex.eq((Object)query.getSortIndex()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectStage())) {
            list.add(this.qdo.projectStage.like(SqlUtil.toSqlLikeString(query.getProjectStage())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getKeyTask())) {
            list.add(this.qdo.keyTask.like(SqlUtil.toSqlLikeString(query.getKeyTask())));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsMaConfigVO queryByKey(Long id) {
        JPAQuery<PmsMaConfigVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsMaConfigVO)jpaQuery.fetchFirst();
    }

    public List<PmsMaConfigVO> queryListDynamic(PmsMaConfigQuery query) {
        JPAQuery<PmsMaConfigVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsMaConfigVO> queryPaging(PmsMaConfigQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsMaConfigVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsMaConfigDO save(PmsMaConfigDO ado) {
        return (PmsMaConfigDO)this.repo.save(ado);
    }

    public List<PmsMaConfigDO> saveAll(List<PmsMaConfigDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsMaConfigPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getSortIndex() != null) {
            update.set(this.qdo.sortIndex, (Object)payload.getSortIndex());
        }
        if (payload.getProjectStage() != null) {
            update.set((Path)this.qdo.projectStage, (Object)payload.getProjectStage());
        }
        if (payload.getKeyTask() != null) {
            update.set((Path)this.qdo.keyTask, (Object)payload.getKeyTask());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("sortIndex")) {
                update.setNull(this.qdo.sortIndex);
            }
            if (nullFields.contains("projectStage")) {
                update.setNull((Path)this.qdo.projectStage);
            }
            if (nullFields.contains("keyTask")) {
                update.setNull((Path)this.qdo.keyTask);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PmsMaConfigDAO(JPAQueryFactory jpaQueryFactory, PmsMaConfigRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

