/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectTemplateActPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectTemplateActQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectTemplateActService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectTemplateActVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectTemplateActConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectTemplateActDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectTemplateActDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectTemplateActRepo;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsProjectTemplateActServiceImpl
extends BaseServiceImpl
implements PmsProjectTemplateActService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectTemplateActServiceImpl.class);
    private final PmsProjectTemplateActRepo pmsProjectTemplateActRepo;
    private final PmsProjectTemplateActDAO pmsProjectTemplateActDAO;

    @Transactional(rollbackFor={Exception.class})
    public List<PmsProjectTemplateActVO> batchSave(List<PmsProjectTemplateActPayload> actList) {
        ArrayList<PmsProjectTemplateActDO> entityList = new ArrayList<PmsProjectTemplateActDO>();
        HashMap<Integer, Boolean> seenSort = new HashMap<Integer, Boolean>();
        for (PmsProjectTemplateActPayload payload : actList) {
            if (ObjectUtils.isEmpty((Object)payload.getActCode()) || ObjectUtils.isEmpty((Object)payload.getActName())) {
                throw TwException.error("", "\u6d3b\u52a8\u7f16\u53f7\u548c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a !");
            }
            Integer sortNo = payload.getSortNo();
            if (ObjectUtils.isEmpty((Object)sortNo)) {
                throw TwException.error("", "\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a !");
            }
            if (seenSort.containsKey(sortNo)) {
                throw TwException.error("", "\u5e8f\u53f7\u4e0d\u5141\u8bb8\u91cd\u590d !");
            }
            seenSort.put(sortNo, true);
            if (1 == sortNo && 1 != payload.getActStageFlag()) {
                throw TwException.error("", "\u9879\u76ee\u7684\u7b2c\u4e00\u4e2a\u6d3b\u52a8 \u5fc5\u987b\u662f\u9636\u6bb5 !");
            }
            if (!ObjectUtils.isEmpty((Object)payload.getPlannedDays())) {
                payload.setPlannedDays(payload.getPlannedDays().setScale(0));
            }
            if (!ObjectUtils.isEmpty((Object)payload.getPlanningEquivalent())) {
                payload.setPlanningEquivalent(payload.getPlanningEquivalent().setScale(2, RoundingMode.HALF_UP));
            }
            PmsProjectTemplateActDO entityDo = PmsProjectTemplateActConvert.INSTANCE.toDo(payload);
            entityList.add(entityDo);
        }
        PmsProjectTemplateActQuery pmsProjectTemplateActQuery = new PmsProjectTemplateActQuery();
        pmsProjectTemplateActQuery.setTemplateId(actList.get(0).getTemplateId());
        List<PmsProjectTemplateActVO> fromDbList = this.pmsProjectTemplateActDAO.queryListDynamic(pmsProjectTemplateActQuery);
        if (!ObjectUtils.isEmpty(fromDbList)) {
            List updateList = actList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getId())).map(v -> v.getId()).collect(Collectors.toList());
            List<Long> delList = fromDbList.stream().filter(item -> !updateList.contains(item.getId())).map(v -> v.getId()).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(delList)) {
                this.pmsProjectTemplateActDAO.deleteSoft(delList);
            }
        }
        return PmsProjectTemplateActConvert.INSTANCE.toVoList(this.pmsProjectTemplateActRepo.saveAll(entityList));
    }

    public List<PmsProjectTemplateActVO> queryByTemplateId(Long templateId) {
        return this.pmsProjectTemplateActDAO.queryByTemplateId(templateId);
    }

    public PagingVO<PmsProjectTemplateActVO> queryPaging(PmsProjectTemplateActQuery query) {
        return this.pmsProjectTemplateActDAO.queryPaging(query);
    }

    public List<PmsProjectTemplateActVO> queryListDynamic(PmsProjectTemplateActQuery query) {
        return this.pmsProjectTemplateActDAO.queryListDynamic(query);
    }

    public PmsProjectTemplateActVO queryByKey(Long key) {
        PmsProjectTemplateActDO entity = this.pmsProjectTemplateActRepo.findById(key).orElseGet(PmsProjectTemplateActDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectTemplateActVO vo = PmsProjectTemplateActConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectTemplateActVO insert(PmsProjectTemplateActPayload payload) {
        PmsProjectTemplateActDO entityDo = PmsProjectTemplateActConvert.INSTANCE.toDo(payload);
        return PmsProjectTemplateActConvert.INSTANCE.toVo((PmsProjectTemplateActDO)this.pmsProjectTemplateActRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectTemplateActVO update(PmsProjectTemplateActPayload payload) {
        PmsProjectTemplateActDO entity = this.pmsProjectTemplateActRepo.findById(payload.getId()).orElseGet(PmsProjectTemplateActDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectTemplateActDO entityDo = PmsProjectTemplateActConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsProjectTemplateActConvert.INSTANCE.toVo((PmsProjectTemplateActDO)this.pmsProjectTemplateActRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsProjectTemplateActPayload payload) {
        PmsProjectTemplateActDO entity = this.pmsProjectTemplateActRepo.findById(payload.getId()).orElseGet(PmsProjectTemplateActDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.pmsProjectTemplateActDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsProjectTemplateActDAO.deleteSoft(keys);
        }
    }

    public PmsProjectTemplateActServiceImpl(PmsProjectTemplateActRepo pmsProjectTemplateActRepo, PmsProjectTemplateActDAO pmsProjectTemplateActDAO) {
        this.pmsProjectTemplateActRepo = pmsProjectTemplateActRepo;
        this.pmsProjectTemplateActDAO = pmsProjectTemplateActDAO;
    }
}

