/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.service;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessSupplierInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.api.prd.product.service.PrdProductService;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseContractDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseContractManagerPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchasePaymentPlanPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseContractDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseContractManagerQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractDetailsService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractManagerService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentPlanService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractDetailsVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractDocumentView;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentDefaultVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentPlanVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.TPurchaseContractOverVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdProductClassEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowRoleCodeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.partner.constants.AccountUsageEnum;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseContractDetailsConvert;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseContractManagerConvert;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchasePaymentPlanConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseContractDetailsDAO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseContractManagerDAO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchasePaymentPlanDAO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.TPurchaseContractOverDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseContractManagerDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseContractEnum;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseContractStatusEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseContractManagerRepo;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConEpibolyCostConDDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConPurchaseDemandDDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PurchaseContractManagerServiceImpl
extends BaseServiceImpl
implements PurchaseContractManagerService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseContractManagerServiceImpl.class);
    private final PurchaseContractManagerRepo purchaseContractManagerRepo;
    private final PurchaseContractManagerDAO purchaseContractManagerDAO;
    private final CacheUtil cacheUtil;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final FileUtil fileUtil;
    private final PurchasePaymentPlanDAO purchasePaymentPlanDAO;
    private final PurchaseContractDetailsDAO purchaseContractDetailsDAO;
    @Autowired
    private PurchaseContractDetailsService purchaseContractDetailsService;
    @Autowired
    private PurchasePaymentPlanService purchasePaymentPlanService;
    private final SaleConContractDAO saleConContractDAO;
    @Autowired
    private SaleConContractService saleConContractService;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final PrdOrgOrganizationDAO daoOrg;
    private final PrdProductService productService;
    private final ConEpibolyCostConDDAO costConDDAO;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final UdcUtil udcUtil;
    private final TPurchaseContractOverDAO purchaseContractOverDAO;
    private final ConEpibolyCostConDDAO conEpibolyCostConDDAO;
    private final ConPurchaseDemandDDAO conPurchaseDemandDDAO;
    @Value(value="${tw5.workflow.orgId}")
    private Long workflow_orgId;
    private final BookAccountService bookAccountService;
    private final BusinessPartnerService businessPartnerService;
    private final PrdSystemRoleService systemRoleService;
    private final BusinessSupplierInfoService businessSupplierInfoService;
    @Autowired
    private PurchasePaymentService purchasePaymentService;
    private BeanSearcher beanSearcher;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.BUSINESS_OPPORTUNITY);
    }

    public PagingVO<PurchaseContractManagerVO> queryPaging(PurchaseContractManagerQuery query) {
        PagingVO<PurchaseContractManagerVO> pagingVO = this.purchaseContractManagerDAO.queryPaging(query);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return pagingVO;
        }
        this.transSysSelectionAndName(pagingVO.getRecords());
        return pagingVO;
    }

    public PagingVO<PurchaseContractManagerVO> queryPermissionPaging(PurchaseContractManagerQuery query) {
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = this.beanSearcher.searchCount(PurchaseContractManagerVO.class, mapBuilder.build());
        if (totalNum.equals(0)) {
            return null;
        }
        List PurchaseContractManagerVOS = this.beanSearcher.searchList(PurchaseContractManagerVO.class, mapBuilder.build());
        this.transSysSelectionAndName(PurchaseContractManagerVOS);
        return PagingVO.builder().records(PurchaseContractManagerVOS).total(((Long)totalNum).longValue()).build();
    }

    private MapBuilder pageWhereBuilder(PurchaseContractManagerQuery query) {
        String likeStr;
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty((Object)query.getPurchaseContractNo())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getPurchaseContractNo, new Object[]{query.getPurchaseContractNo()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getId, new Object[]{query.getId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)query.getIds())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getId, (Collection)query.getIds())).op((FieldOp)FieldOps.InList);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPurchaseContractName())) {
            likeStr = "%" + query.getPurchaseContractName() + "%";
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getPurchaseContractName, new FieldFns.FieldFn[]{PurchaseContractManagerVO::getPurchaseContractNo})).sql("$1 like ? or $2 like ?", new Object[]{likeStr, likeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getPurchaseContractNameEq())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getPurchaseContractName, new Object[]{query.getPurchaseContractNameEq()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlatType())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getPlatType, new Object[]{query.getPlatType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPurchaseContractType())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getPurchaseContractType, new Object[]{query.getPurchaseContractType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getBusinessType())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getBusinessType, new Object[]{query.getBusinessType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getAcceptanceType())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getAcceptanceType, new Object[]{query.getAcceptanceType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPurchaseCompanyBookId())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getPurchaseCompanyBookId, new Object[]{query.getPurchaseCompanyBookId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSupplierBookId())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getSupplierBookId, new Object[]{query.getSupplierBookId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPurchaseBuId())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getPurchaseBuId, new Object[]{query.getPurchaseBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPurchaseInchargeResId())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getPurchaseInchargeResId, new Object[]{query.getPurchaseInchargeResId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSignDateStart())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getSignDate, new Object[]{query.getSignDateStart()})).op((FieldOp)FieldOps.GreaterEqual);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSignDateEnd())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getSignDate, new Object[]{query.getSignDateEnd()})).op((FieldOp)FieldOps.LessEqual);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSignDateStart()) && !ObjectUtils.isEmpty((Object)query.getSignDateEnd())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getSignDate, new FieldFns.FieldFn[0])).sql("$1 >= ? and $1 <= ?", new Object[]{query.getSignDateStart(), query.getSignDateEnd()});
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplicationDateStart())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getApplicationDate, new Object[]{query.getApplicationDateStart()})).op((FieldOp)FieldOps.GreaterEqual);
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplicationDateEnd())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getApplicationDate, new Object[]{query.getApplicationDateEnd()})).op((FieldOp)FieldOps.LessEqual);
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplicationDateStart()) && !ObjectUtils.isEmpty((Object)query.getApplicationDateEnd())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getApplicationDate, new FieldFns.FieldFn[0])).sql("$1 >= ? and $1 <= ?", new Object[]{query.getApplicationDateStart().toString(), query.getApplicationDateEnd().toString()});
        }
        if (!ObjectUtils.isEmpty((Object)query.getCurrCode())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getCurrCode, new Object[]{query.getCurrCode()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getAmt())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getAmt, new Object[]{query.getAmt()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaxRate())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getTaxRate, new Object[]{query.getTaxRate()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaxAmt())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getTaxAmt, new Object[]{query.getTaxAmt()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getContractStatus())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getContractStatus, new Object[]{query.getContractStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprStatus())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getApprStatus, new Object[]{query.getApprStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelatedSalesContract())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getRelatedSalesContract, new Object[]{query.getRelatedSalesContract()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelatedAgreement())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getRelatedAgreement, new Object[]{query.getRelatedAgreement()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getDemandNo())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getDemandNo, new Object[]{query.getDemandNo()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPricecompereFileCodes())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getPricecompereFileCodes, new Object[]{query.getPricecompereFileCodes()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getContractFileCodes())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getContractFileCodes, new Object[]{query.getContractFileCodes()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getStampFileCodes())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getStampFileCodes, new Object[]{query.getStampFileCodes()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelatedProjectId())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getRelatedProjectId, new Object[]{query.getRelatedProjectId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelatedProjectName())) {
            likeStr = "%" + query.getRelatedProjectName() + "%";
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getRelatedProjectName, new FieldFns.FieldFn[]{PurchaseContractManagerVO::getRelatedProjectNo})).sql("$1 like ? or $2 like ?", new Object[]{likeStr, likeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelatedTask())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getRelatedTask, new Object[]{query.getRelatedTask()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getInvoice())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getInvoice, new Object[]{query.getInvoice()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayMethod())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getPayMethod, new Object[]{query.getPayMethod()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getContractSource())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getContractSource, new Object[]{query.getContractSource()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getContractSourceNo())) {
            likeStr = "%" + query.getContractSourceNo() + "%";
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getContractSourceNo, new FieldFns.FieldFn[0])).sql("$1 like ? ", new Object[]{likeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getActivateDate())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getActivateDate, new Object[]{query.getActivateDate()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getOverWhy())) {
            likeStr = "%" + query.getOverWhy() + "%";
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getOverWhy, new FieldFns.FieldFn[0])).sql("$1 like ? ", new Object[]{likeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getOverDate())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getOverDate, new Object[]{query.getOverDate()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getFilingFlag())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getFilingFlag, new Object[]{query.getFilingFlag()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getClassId())) {
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getClassId, new Object[]{query.getClassId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getContractNmNo())) {
            likeStr = "%" + query.getContractNmNo() + "%";
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getRelatedSalesContractName, new FieldFns.FieldFn[]{PurchaseContractManagerVO::getRelatedSalesContractCode})).sql("$1 like ? or $2 like ?", new Object[]{likeStr, likeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getPurContractNmNo())) {
            likeStr = "%" + query.getPurContractNmNo() + "%";
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getPurchaseContractNo, new FieldFns.FieldFn[]{PurchaseContractManagerVO::getPurchaseContractName})).sql("$1 like ? or $2 like ?", new Object[]{likeStr, likeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjNmNo())) {
            likeStr = "%" + query.getProjNmNo() + "%";
            ((MapBuilder)builder.field(PurchaseContractManagerVO::getRelatedProjectName, new FieldFns.FieldFn[]{PurchaseContractManagerVO::getRelatedProjectNo})).sql("$1 like ? or $2 like ?", new Object[]{likeStr, likeStr});
        }
        SqlUtil.handleBS(builder, (TwQueryParam)query);
        return builder;
    }

    public List<PurchaseContractManagerVO> queryListDynamic(PurchaseContractManagerQuery query) {
        List<PurchaseContractManagerVO> managerVOS = this.purchaseContractManagerDAO.queryListDynamic(query);
        if (CollectionUtils.isEmpty(managerVOS)) {
            return managerVOS;
        }
        this.transSysSelectionAndName(managerVOS);
        return managerVOS;
    }

    public PurchaseContractManagerVO queryByKey(Long key) {
        BusinessSupplierInfoVO businessSupplierInfoVO;
        TPurchaseContractOverVO purchaseContractOverVO;
        PurchaseContractManagerDO entity = this.purchaseContractManagerRepo.findById(key).orElseGet(PurchaseContractManagerDO::new);
        if (entity == null || entity.getId() == null) {
            return null;
        }
        PurchaseContractManagerVO vo = PurchaseContractManagerConvert.INSTANCE.toVo(entity);
        vo.setContractFile(this.fileUtil.getFileDatas(vo.getContractFileCodes()));
        vo.setStampFile(this.fileUtil.getFileDatas(vo.getStampFileCodes()));
        vo.setPricecompereFile(this.fileUtil.getFileDatas(vo.getPricecompereFileCodes()));
        PurchaseContractDetailsQuery detail = new PurchaseContractDetailsQuery();
        detail.setPurchaseContractId(key);
        List purchaseContractDetailsVOS = this.purchaseContractDetailsService.queryListDynamic(detail);
        vo.setPurchaseDetailViews(purchaseContractDetailsVOS);
        List purchasePaymentPlanVOS = this.purchasePaymentPlanService.queryListByConId(key, Boolean.valueOf(true));
        vo.setPaymentPlanViews(purchasePaymentPlanVOS);
        if (vo.getRelatedSalesContract() != null) {
            SaleConContractVO saleConContractVO = this.saleConContractDAO.queryByKey(vo.getRelatedSalesContract());
            vo.setSaleContractView(saleConContractVO);
            if (saleConContractVO != null) {
                vo.setRelatedSalesContractName(saleConContractVO.getName());
                vo.setRelatedSalesContractCode(saleConContractVO.getCode());
            }
        }
        if (!ObjectUtils.isEmpty((Object)(purchaseContractOverVO = this.purchaseContractOverDAO.queryByConId(key)))) {
            vo.setOverVO(purchaseContractOverVO);
        }
        if (vo.getCreateUserId() != null) {
            PrdOrgEmployeeVO employee;
            Long defaultOrgIdByUserId = this.cacheUtil.getDefaultOrgIdByUserId(vo.getCreateUserId());
            if (defaultOrgIdByUserId != null) {
                String orgName = this.cacheUtil.getOrgName(defaultOrgIdByUserId);
                vo.setBuName(orgName);
            }
            if ((employee = this.cacheUtil.getEmployee(vo.getCreateUserId())) != null) {
                vo.setGrade(employee.getExtString1());
            }
        }
        this.transSysSelectionAndName(vo);
        if (vo.getSupplierBookId() != null && (businessSupplierInfoVO = this.businessSupplierInfoService.quertByBookId(vo.getSupplierBookId())) != null) {
            vo.setSupplierStatus(businessSupplierInfoVO.getSupplierStatus());
            vo.setSupplierParentId(businessSupplierInfoVO.getPartnerId());
        }
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PurchaseContractManagerVO insert(PurchaseContractManagerPayload payload) {
        BigDecimal totalAmount2;
        String name = payload.getPurchaseContractName();
        if (StringUtils.hasText((String)name)) {
            List collect;
            PurchaseContractManagerQuery query = new PurchaseContractManagerQuery();
            query.setPurchaseContractNameEq(name);
            PagingVO<PurchaseContractManagerVO> queryPaging = this.purchaseContractManagerDAO.queryPaging(query);
            List records = queryPaging.getRecords();
            if (!CollectionUtils.isEmpty((Collection)records) && !CollectionUtils.isEmpty(collect = records.stream().filter(e -> !e.getId().equals(payload.getId())).collect(Collectors.toList()))) {
                throw TwException.warn("", "\u5408\u540c\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff01");
            }
        }
        if (ObjectUtils.isEmpty((Object)payload.getPurchaseDetailViews())) {
            throw TwException.error("", "\u91c7\u8d2d\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getPaymentPlanViews())) {
            throw TwException.error("", "\u4ed8\u6b3e\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        BigDecimal totalAmount1 = payload.getPurchaseDetailViews().stream().map(view -> view.getTaxAmt()).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (totalAmount1.compareTo(totalAmount2 = payload.getPaymentPlanViews().stream().map(view -> view.getPaymentAmt()).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
            throw TwException.error("", "\u91c7\u8d2d\u660e\u7ec6\u542b\u7a0e\u603b\u989d\u7684\u603b\u91d1\u989d\u4e0e\u4ed8\u6b3e\u91d1\u989d\u7684\u603b\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        payload.setPurchaseContractNo(this.generateSeqNum("PURCHASE_CONTRACT_NO", new String[0]));
        PurchaseContractManagerDO entityDo = PurchaseContractManagerConvert.INSTANCE.toDo(payload);
        entityDo.setContractStatus(PurchaseContractStatusEnum.CREATE.getCode());
        entityDo.setApprStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
        this.countTax(payload.getPurchaseDetailViews(), entityDo);
        PurchaseContractManagerDO save = (PurchaseContractManagerDO)this.purchaseContractManagerRepo.save(entityDo);
        if (!CollectionUtils.isEmpty((Collection)payload.getPurchaseDetailViews())) {
            payload.getPurchaseDetailViews().stream().forEach(item -> {
                item.setPurchaseContractId(save.getId());
                item.setPurchaseContractNo(save.getPurchaseContractNo());
                PurchaseContractDetailsPayload detailsPayload = PurchaseContractDetailsConvert.INSTANCE.toPayload((PurchaseContractDetailsVO)item);
                this.purchaseContractDetailsService.insert(detailsPayload);
                if (item.getConEpibolyCostConDId() != null) {
                    this.conEpibolyCostConDDAO.updateChannelCostConIdNumber(item.getConEpibolyCostConDId(), save.getPurchaseContractNo());
                }
                if (item.getPurchaseDemandId() != null) {
                    this.conPurchaseDemandDDAO.updatePurContractId(item.getPurchaseDemandId(), save.getId());
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)payload.getPaymentPlanViews())) {
            payload.getPaymentPlanViews().stream().forEach(item -> {
                item.setContractId(save.getId());
                item.setContractNo(save.getPurchaseContractNo());
                PurchasePaymentPlanPayload detailsPayload = PurchasePaymentPlanConvert.INSTANCE.toPayload((PurchasePaymentPlanVO)item);
                this.purchasePaymentPlanService.insert(detailsPayload);
            });
        }
        if (payload.getSubmit().booleanValue()) {
            this.startProcInst(save);
        }
        this.logService.saveNewLog(save.getId(), PrdSystemObjectEnum.PROCUREMENT_CONTRACT.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.PROCUREMENT_CONTRACT.getDesc());
        return PurchaseContractManagerConvert.INSTANCE.toVo(save);
    }

    void countTax(List<PurchaseContractDetailsVO> views, PurchaseContractManagerDO entityDo) {
        if (CollectionUtils.isEmpty(views)) {
            return;
        }
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal taxTotal = BigDecimal.ZERO;
        for (PurchaseContractDetailsVO temp2 : views) {
            BigDecimal taxAmt = temp2.getTaxAmt() == null ? BigDecimal.ZERO : temp2.getTaxAmt();
            BigDecimal taxNotAmt = temp2.getTaxNotAmt() == null ? BigDecimal.ZERO : temp2.getTaxNotAmt();
            total = total.add(taxAmt);
            taxTotal = taxTotal.add(taxNotAmt);
        }
        entityDo.setAmt(total);
        entityDo.setTaxAmt(total.subtract(taxTotal));
        if (total.equals(BigDecimal.ZERO)) {
            entityDo.setTaxRate("0%");
            return;
        }
        String max = views.stream().map(PurchaseContractDetailsVO::getTaxRate).max(Comparator.comparingDouble(Double::parseDouble)).orElse("0");
        String min = views.stream().map(PurchaseContractDetailsVO::getTaxRate).min(Comparator.comparingDouble(Double::parseDouble)).orElse("0");
        entityDo.setTaxRate(min + "%~" + max + "%");
    }

    @Transactional(rollbackFor={Exception.class})
    public PurchaseContractManagerVO update(PurchaseContractManagerPayload payload) {
        Field[] fields;
        String name = payload.getPurchaseContractName();
        if (StringUtils.hasText((String)name)) {
            List list;
            PurchaseContractManagerQuery query = new PurchaseContractManagerQuery();
            query.setPurchaseContractNameEq(name);
            PagingVO<PurchaseContractManagerVO> queryPaging = this.purchaseContractManagerDAO.queryPaging(query);
            List records = queryPaging.getRecords();
            if (!CollectionUtils.isEmpty((Collection)records) && !CollectionUtils.isEmpty(list = records.stream().filter(e -> !e.getId().equals(payload.getId())).collect(Collectors.toList()))) {
                throw TwException.warn("", "\u5408\u540c\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff01");
            }
        }
        PurchaseContractManagerDO entity = this.purchaseContractManagerRepo.findById(payload.getId()).orElseGet(PurchaseContractManagerDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        Class<?> clazz = payload.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!"java.math.BigDecimal".equals(field.getType().getName())) continue;
            String fieldName = field.getName();
            String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                Method getMethod = clazz.getMethod(getMethodName, new Class[0]);
                BigDecimal value = (BigDecimal)getMethod.invoke((Object)payload, new Object[0]);
                if (value == null) continue;
                String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Method setMethod = clazz.getDeclaredMethod(setMethodName, field.getType());
                setMethod.invoke((Object)payload, value.setScale(2));
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        PurchaseContractManagerDO purchaseContractManagerDO = new PurchaseContractManagerDO();
        BeanUtils.copyProperties((Object)entity, (Object)purchaseContractManagerDO);
        PurchaseContractManagerDO entityDo = PurchaseContractManagerConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        this.countTax(payload.getPurchaseDetailViews(), entity);
        StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, purchaseContractManagerDO, entity);
        PurchaseContractManagerDO save = (PurchaseContractManagerDO)this.purchaseContractManagerRepo.save(entity);
        fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, purchaseContractManagerDO));
        if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
            this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.PROCUREMENT_CONTRACT.getCode(), fieldsUpdateLog.toString());
        }
        if (payload.getSubmit().booleanValue()) {
            if (StringUtils.hasText((String)payload.getProcInstId())) {
                this.dealVariablesByUpdate(save);
            } else {
                this.startProcInst(save);
            }
        }
        return PurchaseContractManagerConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PurchaseContractManagerPayload payload) {
        PurchaseContractManagerDO entity = this.purchaseContractManagerRepo.findById(payload.getId()).orElseGet(PurchaseContractManagerDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.purchaseContractManagerDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        List<PurchaseContractManagerVO> purchaseContractViewList = this.purchaseContractManagerDAO.queryByKeys(keys);
        String create = PurchaseContractStatusEnum.CREATE.getCode();
        boolean allCreate = purchaseContractViewList.stream().allMatch(view -> create.equals(view.getContractStatus()));
        if (!allCreate) {
            throw TwException.error("", "\u91c7\u8d2d\u5408\u540c\u72b6\u6001\u7b49\u4e8e\u65b0\u5efa\u72b6\u6001\u624d\u5141\u8bb8\u5220\u9664");
        }
        List<String> purContractNoList = purchaseContractViewList.stream().map(PurchaseContractManagerVO::getPurchaseContractNo).collect(Collectors.toList());
        List<Long> purContractIdList = purchaseContractViewList.stream().map(PurchaseContractManagerVO::getId).collect(Collectors.toList());
        long delTotal = this.purchaseContractManagerDAO.deleteSoft(keys);
        this.purchaseContractDetailsDAO.logicalDeleteByContractIds(keys);
        this.purchasePaymentPlanDAO.logicalDeleteByContractIds(keys);
        this.costConDDAO.cancelPurContract(purContractNoList);
        this.conPurchaseDemandDDAO.cancelPurContract(purContractIdList);
    }

    public List<PrdSystemLogVO> queryLogList(Long key) {
        return this.logService.queryLogList(key, PrdSystemObjectEnum.PROCUREMENT_CONTRACT.getCode());
    }

    @Transactional
    public Long active(List<Long> keys) {
        List repoAllById = this.purchaseContractManagerRepo.findAllById(keys);
        if (CollectionUtils.isEmpty((Collection)repoAllById)) {
            return 0L;
        }
        List filterList = repoAllById.stream().filter(e -> !PurchaseContractStatusEnum.NOT_ACTIVE.getCode().equals(e.getContractStatus()) && !PurchaseContractStatusEnum.PENDING.getCode().equals(e.getContractStatus())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(filterList)) {
            throw TwException.error("", "\u91c7\u8d2d\u5408\u540c\u72b6\u6001\u4e3a\u672a\u6fc0\u6d3b\u6216\u6682\u6302\u65f6\u624d\u5141\u8bb8\u6fc0\u6d3b");
        }
        this.purchaseContractManagerDAO.active(keys, PurchaseContractStatusEnum.ACTIVE.getCode(), LocalDateTime.now());
        return 1L;
    }

    @Transactional
    public void contractFilingByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.purchaseContractManagerDAO.updateFilingFlag(ids, 1);
    }

    @Transactional
    public void closeContract(List<Long> ids, String closeReason) {
        this.purchaseContractManagerDAO.closeContract(ids, closeReason);
    }

    @Transactional
    public Integer purchaseContractCloseBatch() {
        return this.purchaseContractManagerRepo.purchaseContractCloseBatch();
    }

    public void downloadPurCon(HttpServletResponse response, PurchaseContractManagerQuery query) {
        try {
            log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
            PagingVO<PurchaseContractManagerVO> paging = this.queryPaging(query);
            log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
            List records = paging.getRecords();
            this.download(this.udcUtil.translateList(records), response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void permissionDownloadPurCon(HttpServletResponse response, PurchaseContractManagerQuery query) {
        try {
            log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
            PagingVO<PurchaseContractManagerVO> paging = this.queryPermissionPaging(query);
            log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
            List records = paging.getRecords();
            this.download(this.udcUtil.translateList(records), response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void download(List<PurchaseContractManagerVO> records, HttpServletResponse response) throws IOException {
        String sheetName = "\u91c7\u8d2d\u5408\u540c\u6570\u636e";
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), PurchaseContractManagerVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, PurchaseContractManagerVO.class, null);
        sheet.doWrite(records);
    }

    private void startProcInst(PurchaseContractManagerDO conContract) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            processInfo = this.getProcInst(processInfo, conContract);
        }
        PurchaseContractManagerPayload payload = new PurchaseContractManagerPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(conContract.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setApprStatus(status);
        if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            payload.setContractStatus(PurchaseContractStatusEnum.APPROVING.getCode());
        } else if (ProcInstStatus.APPROVED.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            payload.setProcInstStatus(ProcInstStatus.APPROVED);
            payload.setApprovedTime(LocalDateTime.now());
            payload.setContractStatus(PurchaseContractStatusEnum.NOT_ACTIVE.getCode());
        }
        this.transactionUtilService.executeWithRunnable(() -> this.purchaseContractManagerDAO.updateByKeyDynamic(payload));
    }

    private Map<String, List<Long>> getRoleCodeMap() {
        ArrayList<String> roleCodes = new ArrayList<String>();
        roleCodes.add(RoleEnum.PLAT_BUSINESS_PIC.getCode());
        roleCodes.add(RoleEnum.OPERATION_PRESIDENT.getCode());
        roleCodes.add(RoleEnum.PLAT_CFO.getCode());
        roleCodes.add(RoleEnum.PLAT_OFFI_AM.getCode());
        return this.systemRoleService.queryUserIdMapByRoleCodes(roleCodes);
    }

    private ProcessInfo getProcInst(ProcessInfo processInfo, PurchaseContractManagerDO temp2) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Map<String, List<Long>> roleCodeMap = this.getRoleCodeMap();
        this.dealVariables(temp2, variables, roleCodeMap);
        String desc = PurchaseContractEnum.PurchaseConType.valueOf(temp2.getPurchaseContractType()).getDesc();
        String name = temp2.getPurchaseContractName() + temp2.getAmt() + "-" + desc;
        processInfo = this.runProcessInfo(temp2, ProcDefKey.PURCAHSE_CONTRACT.getName(), name, variables);
        return processInfo;
    }

    private ProcessInfo runProcessInfo(PurchaseContractManagerDO temp2, String code, String name, HashMap<String, Object> variables) {
        return this.workflowUtil.startProcess(StartProcessPayload.of((String)code, (String)name, (String)("" + temp2.getId()), variables), new Long[0]);
    }

    private void transSysSelectionAndName(PurchaseContractManagerVO purchaseContractManagerVO) {
        ArrayList<Long> bookIdList = new ArrayList<Long>(3);
        bookIdList.add(purchaseContractManagerVO.getSupplierBookId());
        bookIdList.add(purchaseContractManagerVO.getPurchaseCompanyBookId());
        bookIdList.add(purchaseContractManagerVO.getInvoice());
        Map nameByBookIds = this.businessPartnerService.findNameByBookIds(bookIdList);
        if (purchaseContractManagerVO.getPurchaseInchargeResId() != null) {
            purchaseContractManagerVO.setPurchaseInchargeResName(this.cacheUtil.getUserName(purchaseContractManagerVO.getPurchaseInchargeResId()));
        }
        if (purchaseContractManagerVO.getPurchaseBuId() != null) {
            purchaseContractManagerVO.setPurchaseBuName(this.cacheUtil.getOrgName(purchaseContractManagerVO.getPurchaseBuId()));
        }
        if (!CollectionUtils.isEmpty((Collection)purchaseContractManagerVO.getPurchaseDetailViews())) {
            purchaseContractManagerVO.getPurchaseDetailViews().forEach(purchaseContractDetailsVO -> {
                if (purchaseContractDetailsVO.getTaxRate() != null) {
                    purchaseContractDetailsVO.setTaxRateDesc(purchaseContractDetailsVO.getTaxRate() + "%");
                }
            });
        }
        purchaseContractManagerVO.setInvoiceName((String)nameByBookIds.get(purchaseContractManagerVO.getInvoice()));
        purchaseContractManagerVO.setSupplierName((String)nameByBookIds.get(purchaseContractManagerVO.getSupplierBookId()));
        purchaseContractManagerVO.setPurchaseCompanyName((String)nameByBookIds.get(purchaseContractManagerVO.getPurchaseCompanyBookId()));
    }

    private void transSysSelectionAndName(List<PurchaseContractManagerVO> result) {
        ArrayList bookIdList = new ArrayList();
        result.forEach(purchaseContractManagerVO -> {
            bookIdList.add(purchaseContractManagerVO.getSupplierBookId());
            bookIdList.add(purchaseContractManagerVO.getPurchaseCompanyBookId());
            bookIdList.add(purchaseContractManagerVO.getInvoice());
        });
        Map nameByBookIds = this.businessPartnerService.findNameByBookIds(bookIdList);
        result.forEach(purchaseContractManagerVO -> {
            purchaseContractManagerVO.setInvoiceName((String)nameByBookIds.get(purchaseContractManagerVO.getInvoice()));
            purchaseContractManagerVO.setSupplierName((String)nameByBookIds.get(purchaseContractManagerVO.getSupplierBookId()));
            purchaseContractManagerVO.setPurchaseCompanyName((String)nameByBookIds.get(purchaseContractManagerVO.getPurchaseCompanyBookId()));
            if (purchaseContractManagerVO.getPurchaseInchargeResId() != null) {
                purchaseContractManagerVO.setPurchaseInchargeResName(this.cacheUtil.getUserName(purchaseContractManagerVO.getPurchaseInchargeResId()));
            }
            if (purchaseContractManagerVO.getPurchaseBuId() != null) {
                purchaseContractManagerVO.setPurchaseBuName(this.cacheUtil.getOrgName(purchaseContractManagerVO.getPurchaseBuId()));
            }
        });
    }

    private void dealVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        Boolean agentAndOutFlag = false;
        Boolean projectFlag = false;
        Boolean operationFlag = false;
        Boolean amtFlag = false;
        if (PurchaseContractEnum.PurchaseConType.PURCHASING_AGENT.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.OUTSOURCING.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())) {
            agentAndOutFlag = true;
        }
        if (PurchaseContractEnum.PurchaseConType.PROJECT_COST.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.PROJECT_RENT.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())) {
            projectFlag = true;
        }
        if (PurchaseContractEnum.PurchaseConType.OPERATION_SUPPORT.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())) {
            operationFlag = true;
        }
        if (purchaseContractManagerDO.getAmt() != null && purchaseContractManagerDO.getAmt().compareTo(new BigDecimal(5000)) >= 0) {
            amtFlag = true;
        }
        variables.put("agentAndOutFlag", agentAndOutFlag);
        variables.put("projectFlag", projectFlag);
        variables.put("operationFlag", operationFlag);
        variables.put("amtFlag", amtFlag);
    }

    public void dealTradeServicesVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        Long relatedSalesContract = purchaseContractManagerDO.getRelatedSalesContract();
        SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(relatedSalesContract, new Boolean[0]);
        variables.put("Activity_04cvqth", saleConContractVO.getDeliUserId());
        Long deliBuManageUserId = null;
        if (saleConContractVO.getDeliBuId() != null) {
            deliBuManageUserId = this.daoOrg.queryManageIdById(saleConContractVO.getDeliBuId());
        }
        variables.put("Activity_0o666fi", deliBuManageUserId);
        variables.put("Activity_0lfzwqu", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
        variables.put("Activity_1jf9y70", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
        variables.put("Activity_1g3xhid", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
        PrdOrgRoleVO serviceTradePrint = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.SERVICE_TRADE_PRINT.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradePrint)) {
            throw TwException.error("", "\u6253\u5370\u5408\u540c\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradePrint = serviceTradePrint.getRoleEmployees().split(",");
        variables.put("Activity_0jba9gf", Arrays.asList(splitByServiceTradePrint));
        PrdOrgRoleVO serviceTradeCollect = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_COLLECT.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradeCollect)) {
            throw TwException.error("", "\u5408\u540c\u5f52\u6863\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_0r7aerq", Arrays.asList(splitByServiceTradeCollect));
    }

    public void dealTradeProductVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        long count;
        List purConOrAgreementDetailsSimpleVOS;
        Long relatedSalesContract = purchaseContractManagerDO.getRelatedSalesContract();
        SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(relatedSalesContract, new Boolean[0]);
        boolean pdmFlag = false;
        if (PrdProductClassEnum.software_MA_core.getCode().equals(saleConContractVO.getProductClass()) && !CollectionUtils.isEmpty((Collection)(purConOrAgreementDetailsSimpleVOS = this.purchaseContractDetailsService.queryByPurConId(purchaseContractManagerDO.getId()))) && (count = purConOrAgreementDetailsSimpleVOS.stream().filter(p -> StringUtils.hasText((String)p.getTagDesc()) && "SAP".equalsIgnoreCase(p.getTagDesc().trim())).count()) > 0L) {
            pdmFlag = true;
        }
        variables.put("pdmFlag", pdmFlag);
        PurchaseContractDetailsQuery purchaseContractDetailsQuery = new PurchaseContractDetailsQuery();
        purchaseContractDetailsQuery.setPurchaseContractId(purchaseContractManagerDO.getId());
        List purchaseContractDetailsVOS = this.purchaseContractDetailsService.queryListDynamic(purchaseContractDetailsQuery);
        if (CollectionUtils.isEmpty((Collection)purchaseContractDetailsVOS)) {
            throw TwException.error("", "\u91c7\u8d2d\u5408\u540c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List collect = purchaseContractDetailsVOS.stream().map(PurchaseContractDetailsVO::getRelatedProductId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            throw TwException.error("", "\u91c7\u8d2d\u5408\u540c\u660e\u7ec6\u672a\u5173\u8054\u4ea7\u54c1\u4fe1\u606f");
        }
        List prdProductVOS = this.productService.queryByKeys(collect);
        List picResIdList = prdProductVOS.stream().map(p -> String.valueOf(p.getPicResId())).collect(Collectors.toList());
        variables.put("Activity_0n3h3dk", picResIdList);
        variables.put("Activity_0sleykw", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
        variables.put("Activity_1xqb3nv", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
        variables.put("Activity_0u5edwt", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
        PrdOrgRoleVO serviceTradePrint = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_PRINT.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradePrint)) {
            throw TwException.error("", "\u6253\u5370\u5408\u540c\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradePrint = serviceTradePrint.getRoleEmployees().split(",");
        variables.put("Activity_0ttqjm3", Arrays.asList(splitByServiceTradePrint));
        PrdOrgRoleVO serviceTradeCollect = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_COLLECT.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradeCollect)) {
            throw TwException.error("", "\u5408\u540c\u5f52\u6863\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_1snhapc", Arrays.asList(splitByServiceTradeCollect));
    }

    public void dealOutSourcingVariables(HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        variables.put("Activity_0hpznx2", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
        variables.put("Activity_15bff5q", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
        PrdOrgRoleVO serviceTradeCollect = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_COLLECT.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradeCollect)) {
            throw TwException.error("", "\u5408\u540c\u5f52\u6863\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_1evabwk", Arrays.asList(splitByServiceTradeCollect));
    }

    public void dealMisPurchaseVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        variables.put("Activity_1iz3khk", roleCodeMap.get(RoleEnum.PLAT_OFFI_AM.getCode()));
        Long relatedSalesContract = purchaseContractManagerDO.getRelatedSalesContract();
        if (relatedSalesContract == null) {
            throw TwException.error("", "\u5173\u8054\u9500\u552e\u5408\u540c\u4e0d\u5b58\u5728");
        }
        SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(relatedSalesContract, new Boolean[0]);
        variables.put("Activity_0f7mny5", saleConContractVO.getDeliUserId());
        Long deliBuId = saleConContractVO.getDeliBuId();
        Long deliBuManageUserId = this.daoOrg.queryManageIdById(deliBuId);
        variables.put("Activity_012gygz", CollUtil.newArrayList((Object[])new Long[]{deliBuManageUserId}));
        PrdOrgRoleVO serviceTradeCollect = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PUR_CONTRACT_FILING.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradeCollect)) {
            throw TwException.error("", "\u5408\u540c\u5f52\u6863\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_0crr9zy", Arrays.asList(splitByServiceTradeCollect));
    }

    public void dealHouseRentalVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        variables.put("Activity_1un3ad2", roleCodeMap.get(RoleEnum.PLAT_OFFI_AM.getCode()));
        PrdOrgRoleVO platFinCashier = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PLAT_FIN_CASHIER.getCode());
        if (ObjectUtils.isEmpty((Object)platFinCashier)) {
            throw TwException.error("", "\u5e73\u53f0\u8d22\u52a1\u51fa\u7eb3\u4e0d\u5b58\u5728");
        }
        String[] splitByPlatFinCashier = platFinCashier.getRoleEmployees().split(",");
        variables.put("Activity_05c5yto", Arrays.asList(splitByPlatFinCashier));
        Long relatedSalesContract = purchaseContractManagerDO.getRelatedSalesContract();
        if (relatedSalesContract == null) {
            throw TwException.error("", "\u5173\u8054\u9500\u552e\u5408\u540c\u4e0d\u5b58\u5728");
        }
        SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(relatedSalesContract, new Boolean[0]);
        variables.put("Activity_1tt2hx8", saleConContractVO.getDeliUserId());
        Long deliBuId = saleConContractVO.getDeliBuId();
        Long deliBuManageUserId = this.daoOrg.queryManageIdById(deliBuId);
        variables.put("Activity_0m5gcrb", CollUtil.newArrayList((Object[])new Long[]{deliBuManageUserId}));
        variables.put("Activity_0mj5c37", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
        PrdOrgRoleVO serviceTradeCollect = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PUR_CONTRACT_FILING.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradeCollect)) {
            throw TwException.error("", "\u5408\u540c\u5f52\u6863\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_0pxm72i", Arrays.asList(splitByServiceTradeCollect));
    }

    public void dealMarketChannelVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        PrdOrgRoleVO marketResponsiblePerson = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.MARKET_RESPONSIBLE_PERSON.getCode());
        if (ObjectUtils.isEmpty((Object)marketResponsiblePerson)) {
            throw TwException.error("", "\u5e02\u573aBU Leader\u4e0d\u5b58\u5728");
        }
        String[] splitByMarketResponsiblePerson = marketResponsiblePerson.getRoleEmployees().split(",");
        variables.put("Activity_0se2msn", Arrays.asList(splitByMarketResponsiblePerson));
        Long purchaseBuId = purchaseContractManagerDO.getPurchaseBuId();
        Long purchaseBuManageUserId = this.daoOrg.queryManageIdById(purchaseBuId);
        variables.put("Activity_0i3qhz1", purchaseBuManageUserId);
        PrdOrgRoleVO generalResponsiblePerson = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.GENERAL_RESPONSIBLE_PERSON.getCode());
        if (ObjectUtils.isEmpty((Object)generalResponsiblePerson)) {
            throw TwException.error("", "\u5e73\u53f0\u603b\u4f53\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByGeneralResponsiblePerson = generalResponsiblePerson.getRoleEmployees().split(",");
        variables.put("Activity_072zu5s", Arrays.asList(splitByGeneralResponsiblePerson));
        variables.put("Activity_1v83wci", purchaseContractManagerDO.getCreateUserId());
        variables.put("Activity_0865ovy", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
        PrdOrgRoleVO serviceTradeCollect = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PUR_CONTRACT_FILING.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradeCollect)) {
            throw TwException.error("", "\u5408\u540c\u5f52\u6863\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_1mqct2e", Arrays.asList(splitByServiceTradeCollect));
    }

    public void dealResearchVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        Long purchaseBuId = purchaseContractManagerDO.getPurchaseBuId();
        Long purchaseBuManageUserId = this.daoOrg.queryManageIdById(purchaseBuId);
        variables.put("Activity_0l10rlg", purchaseBuManageUserId);
        PrdOrgRoleVO generalResponsiblePerson = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.GENERAL_RESPONSIBLE_PERSON.getCode());
        if (ObjectUtils.isEmpty((Object)generalResponsiblePerson)) {
            throw TwException.error("", "\u5e73\u53f0\u603b\u4f53\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByGeneralResponsiblePerson = generalResponsiblePerson.getRoleEmployees().split(",");
        variables.put("Activity_1u4v1xx", Arrays.asList(splitByGeneralResponsiblePerson));
        PrdOrgRoleVO serviceTradePrint = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PUR_CON_RESEARCH_PRINT.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradePrint)) {
            throw TwException.error("", "\u6253\u5370\u5408\u540c\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradePrint = serviceTradePrint.getRoleEmployees().split(",");
        variables.put("Activity_0ksg8tp", Arrays.asList(splitByServiceTradePrint));
        variables.put("Activity_1uuvgk7", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
        PrdOrgRoleVO serviceTradeCollect = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_COLLECT.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradeCollect)) {
            throw TwException.error("", "\u5408\u540c\u5f52\u6863\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_0rcpg7b", Arrays.asList(splitByServiceTradeCollect));
    }

    public void dealCompanyVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        Long purchaseBuId = purchaseContractManagerDO.getPurchaseBuId();
        Long purchaseBuManageUserId = this.daoOrg.queryManageIdById(purchaseBuId);
        variables.put("Activity_1mqqgbp", purchaseBuManageUserId);
        variables.put("Activity_08lp7yx", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
        PrdOrgRoleVO serviceTradePrint = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PUR_CON_COMPANY_MANAGE_PRINT.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradePrint)) {
            throw TwException.error("", "\u6253\u5370\u5408\u540c\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradePrint = serviceTradePrint.getRoleEmployees().split(",");
        variables.put("Activity_1e24gkk", Arrays.asList(splitByServiceTradePrint));
        PrdOrgRoleVO serviceTradeCollect = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_COLLECT.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradeCollect)) {
            throw TwException.error("", "\u5408\u540c\u5f52\u6863\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_1yfni0u", Arrays.asList(splitByServiceTradeCollect));
    }

    public void dealOperateVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        Long purchaseBuId = purchaseContractManagerDO.getPurchaseBuId();
        Long purchaseBuManageUserId = this.daoOrg.queryManageIdById(purchaseBuId);
        variables.put("Activity_1lurjn2", purchaseBuManageUserId);
        variables.put("Activity_0yl5ic6", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
        variables.put("Activity_06n22sk", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
        PrdOrgRoleVO serviceTradePrint = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PUR_CONTRACT_ADM_OPERATE_PRINT.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradePrint)) {
            throw TwException.error("", "\u6253\u5370\u5408\u540c\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradePrint = serviceTradePrint.getRoleEmployees().split(",");
        variables.put("Activity_0nfj5gw", Arrays.asList(splitByServiceTradePrint));
        PrdOrgRoleVO serviceTradeCollect = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_COLLECT.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradeCollect)) {
            throw TwException.error("", "\u5408\u540c\u5f52\u6863\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_1na6ej6", Arrays.asList(splitByServiceTradeCollect));
    }

    public void dealResourcesVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        Long purchaseBuId = purchaseContractManagerDO.getPurchaseBuId();
        Long purchaseBuManageUserId = this.daoOrg.queryManageIdById(purchaseBuId);
        variables.put("Activity_041y443", purchaseBuManageUserId);
        variables.put("Activity_19xrtur", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
        variables.put("Activity_056vn4r", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
        PrdOrgRoleVO generalResponsiblePerson = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.GENERAL_RESPONSIBLE_PERSON.getCode());
        if (ObjectUtils.isEmpty((Object)generalResponsiblePerson)) {
            throw TwException.error("", "\u5e73\u53f0\u603b\u4f53\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByGeneralResponsiblePerson = generalResponsiblePerson.getRoleEmployees().split(",");
        variables.put("Activity_0gn84qd", Arrays.asList(splitByGeneralResponsiblePerson));
        PrdOrgRoleVO serviceTradePrint = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PUR_CONTRACT_ASS_EMPOWER_PRINT.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradePrint)) {
            throw TwException.error("", "\u6253\u5370\u5408\u540c\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradePrint = serviceTradePrint.getRoleEmployees().split(",");
        variables.put("Activity_05axqb6", Arrays.asList(splitByServiceTradePrint));
        PrdOrgRoleVO serviceTradeCollect = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_COLLECT.getCode());
        if (ObjectUtils.isEmpty((Object)serviceTradeCollect)) {
            throw TwException.error("", "\u5408\u540c\u5f52\u6863\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_056aj3v", Arrays.asList(splitByServiceTradeCollect));
    }

    private void dealVariablesByUpdate(PurchaseContractManagerDO temp2) {
        HashMap variables = new HashMap();
        SetVariablesPayload payload = new SetVariablesPayload();
        payload.setProcInstId(temp2.getProcInstId());
        payload.setVariables(variables);
        this.workflowUtil.setVaribales(payload);
    }

    public PurchaseContractManagerVO selectPurchaseContractByOverId(Long overId) {
        TPurchaseContractOverVO overView = this.purchaseContractOverDAO.queryByKey(overId);
        PurchaseContractManagerVO purchaseContractDetailsVO = null;
        if (!Objects.isNull(overView) && !StringUtils.isEmpty((Object)overView.getContractId())) {
            Long key = overView.getContractId();
            purchaseContractDetailsVO = this.queryByKey(key);
            purchaseContractDetailsVO.setOverVO(overView);
        }
        return purchaseContractDetailsVO;
    }

    public PurchasePaymentDefaultVO findPaymentDefaultByDocNo(String docNo) {
        PurchasePaymentDefaultVO purchasePaymentDefaultVO = new PurchasePaymentDefaultVO();
        PurchaseContractDocumentView purchaseView = this.purchaseContractManagerDAO.findByPurchaseContractNo(docNo);
        if (purchaseView != null) {
            BookAccountVO bookAccountVO;
            if (purchaseView.getReceivingUnitBookId() != null && (bookAccountVO = this.bookAccountService.queryDefaultByBookId(purchaseView.getReceivingUnitBookId())) != null && AccountUsageEnum.RECEIVE.getCode().equals(bookAccountVO.getAccountUsage())) {
                purchasePaymentDefaultVO.setReceivingId(String.valueOf(bookAccountVO.getId()));
                purchasePaymentDefaultVO.setReceivingBank(bookAccountVO.getDepositBank());
            }
            BigDecimal totalPlanAmt = this.purchaseContractManagerRepo.findPayableAmtNew(purchaseView.getId());
            purchasePaymentDefaultVO.setPaymentAmt(totalPlanAmt);
            purchasePaymentDefaultVO.setAcceptanceType(purchaseView.getAcceptanceType());
            purchasePaymentDefaultVO.setCurrCode(purchaseView.getCurrCode());
            purchasePaymentDefaultVO.setDocNo(purchaseView.getPurchaseContractNo());
            purchasePaymentDefaultVO.setDocName(purchaseView.getPurchaseContractName());
            purchasePaymentDefaultVO.setRelatedProjectNo(purchaseView.getProjNo());
            purchasePaymentDefaultVO.setRelatedSalesContract(purchaseView.getSaleConNo());
            purchasePaymentDefaultVO.setSupplierBookId(purchaseView.getSupplierBookId());
            purchasePaymentDefaultVO.setRelatedTask(purchaseView.getRelatedTask());
            purchasePaymentDefaultVO.setReceivingUnitBookId(purchaseView.getReceivingUnitBookId());
            purchasePaymentDefaultVO.setPayMethod(purchaseView.getPayMethod());
            purchasePaymentDefaultVO.setDemandNo(purchaseView.getDemandNo());
            purchasePaymentDefaultVO.setPaymentCompanyBooKId(purchaseView.getPurchaseCompanyBookId());
            purchasePaymentDefaultVO.setPurchaseContractType(purchaseView.getPurchaseContractType());
        }
        return purchasePaymentDefaultVO;
    }

    public Long findIdByNo(String docNo) {
        return this.purchaseContractManagerDAO.findIdByNo(docNo);
    }

    public PurchaseContractManagerVO queryByNo(String docNo) {
        return this.purchaseContractManagerDAO.queryByNo(docNo);
    }

    @Transactional
    public void purContractArchiving(Long purConId, String stampFileCodes) {
        this.purchaseContractManagerDAO.purContractArchiving(purConId, stampFileCodes);
    }

    public List<PurchaseContractManagerVO> queryBySaleConId(Long saleConId) {
        return this.purchaseContractManagerDAO.queryBySaleConId(saleConId);
    }

    public List<PurchaseContractManagerVO> queryPurContractInfo(PurchaseContractManagerQuery query) {
        return this.purchaseContractManagerDAO.queryPurContractInfo(query);
    }

    public PurchaseContractManagerServiceImpl(PurchaseContractManagerRepo purchaseContractManagerRepo, PurchaseContractManagerDAO purchaseContractManagerDAO, CacheUtil cacheUtil, PrdSystemLogService logService, ChangeFieldLogUtil changeFieldLogUtil, FileUtil fileUtil, PurchasePaymentPlanDAO purchasePaymentPlanDAO, PurchaseContractDetailsDAO purchaseContractDetailsDAO, SaleConContractDAO saleConContractDAO, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, PrdOrgOrganizationDAO daoOrg, PrdProductService productService, ConEpibolyCostConDDAO costConDDAO, UdcUtil udcUtil, TPurchaseContractOverDAO purchaseContractOverDAO, ConEpibolyCostConDDAO conEpibolyCostConDDAO, ConPurchaseDemandDDAO conPurchaseDemandDDAO, BookAccountService bookAccountService, BusinessPartnerService businessPartnerService, PrdSystemRoleService systemRoleService, BusinessSupplierInfoService businessSupplierInfoService) {
        this.purchaseContractManagerRepo = purchaseContractManagerRepo;
        this.purchaseContractManagerDAO = purchaseContractManagerDAO;
        this.cacheUtil = cacheUtil;
        this.logService = logService;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.fileUtil = fileUtil;
        this.purchasePaymentPlanDAO = purchasePaymentPlanDAO;
        this.purchaseContractDetailsDAO = purchaseContractDetailsDAO;
        this.saleConContractDAO = saleConContractDAO;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.daoOrg = daoOrg;
        this.productService = productService;
        this.costConDDAO = costConDDAO;
        this.udcUtil = udcUtil;
        this.purchaseContractOverDAO = purchaseContractOverDAO;
        this.conEpibolyCostConDDAO = conEpibolyCostConDDAO;
        this.conPurchaseDemandDDAO = conPurchaseDemandDDAO;
        this.bookAccountService = bookAccountService;
        this.businessPartnerService = businessPartnerService;
        this.systemRoleService = systemRoleService;
        this.businessSupplierInfoService = businessSupplierInfoService;
    }
}

