/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemBusinessObjectPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemBusinessObjectQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemBusinessObjectService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/system"})
public class PrdSystemBusinessObjectController {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemBusinessObjectController.class);
    private final PrdSystemBusinessObjectService service;

    @PostMapping(value={"/businessObject"})
    public TwOutputUtil insert(PrdSystemBusinessObjectPayload payload) {
        return TwOutputUtil.ok(this.service.insert(payload));
    }

    @PutMapping(value={"/businessObject"})
    public TwOutputUtil update(PrdSystemBusinessObjectPayload payload) {
        return TwOutputUtil.ok(this.service.update(payload));
    }

    @GetMapping(value={"/businessObject/paging"})
    public TwOutputUtil paging(PrdSystemBusinessObjectQuery query) {
        PagingVO paging = this.service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @DeleteMapping(value={"/businessObject/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/businessObject/{id}"})
    public TwOutputUtil get(@PathVariable Long id) {
        return TwOutputUtil.ok(this.service.get(id));
    }

    @GetMapping(value={"/businessObject/listFunction"})
    public TwOutputUtil listFunction() {
        return TwOutputUtil.ok(this.service.listFunction());
    }

    @GetMapping(value={"/businessObject/listObjectConfig"})
    public TwOutputUtil listObjectConfig(PrdSystemBusinessObjectQuery query) {
        return TwOutputUtil.ok(this.service.listObjectConfig(query));
    }

    @GetMapping(value={"/businessObject/listFunctionConfig"})
    public TwOutputUtil listFunctionConfig(PrdSystemBusinessObjectQuery query) {
        return TwOutputUtil.ok(this.service.listFunctionConfig(query));
    }

    @GetMapping(value={"/businessObject/listRuleFunction"})
    public TwOutputUtil listRuleFunction(PrdSystemBusinessObjectQuery query) {
        return TwOutputUtil.ok(this.service.listFunction(query));
    }

    public PrdSystemBusinessObjectController(PrdSystemBusinessObjectService service) {
        this.service = service;
    }
}

