/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemNewFunctionPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemNewFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemNewFunctionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemBusinessObjectVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemNewFunctionVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemNewFunctionConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemBusinessObjectDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemNewFunctionDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemNewFunctionDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemNewFunctionRepo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PrdSystemNewFunctionServiceImpl
implements PrdSystemNewFunctionService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemNewFunctionServiceImpl.class);
    private final PrdSystemNewFunctionRepo repo;
    private final PrdSystemNewFunctionDAO dao;
    private final PrdSystemBusinessObjectDAO businessObjectDAO;

    @Transactional(rollbackFor={Exception.class})
    public PrdSystemNewFunctionVO insert(PrdSystemNewFunctionPayload payload) {
        this.check(payload);
        PrdSystemNewFunctionDO entityDo = PrdSystemNewFunctionConvert.INSTANCE.toDo(payload);
        this.repo.save((Object)entityDo);
        return PrdSystemNewFunctionConvert.INSTANCE.toVo(entityDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdSystemNewFunctionVO update(PrdSystemNewFunctionPayload payload) {
        this.checkUpdate(payload);
        PrdSystemNewFunctionDO entity = this.repo.findById(payload.getId()).orElseGet(PrdSystemNewFunctionDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        if (StringUtils.hasText((String)payload.getFunctionCode()) && !entity.getFunctionCode().equals(payload.getFunctionCode())) {
            Assert.isNull((Object)this.dao.queryByFunctionCode(payload.getFunctionCode()), (String)"functionCode\u4e0d\u53ef\u91cd\u590d");
        }
        PrdSystemNewFunctionDO entityDo = PrdSystemNewFunctionConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        PrdSystemNewFunctionDO save = (PrdSystemNewFunctionDO)((Object)this.repo.save((Object)entity));
        return PrdSystemNewFunctionConvert.INSTANCE.toVo(save);
    }

    private void checkUpdate(PrdSystemNewFunctionPayload payload) {
        if (payload.getId() == null) {
            throw TwException.error("", "id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!CollectionUtils.isEmpty(keys)) {
            this.repo.deleteSoft(keys);
        }
    }

    public PrdSystemNewFunctionVO get(Long id) {
        PrdSystemNewFunctionDO entity = this.repo.findById(id).orElseGet(PrdSystemNewFunctionDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdSystemNewFunctionVO prdSystemNewFunctionVO = PrdSystemNewFunctionConvert.INSTANCE.toVo(entity);
        return prdSystemNewFunctionVO;
    }

    public PagingVO<PrdSystemNewFunctionVO> paging(PrdSystemNewFunctionQuery query) {
        this.checkQuery(query);
        Page pageDo = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        Page pageVo = pageDo.map(PrdSystemNewFunctionConvert.INSTANCE::toVo);
        return PageUtil.toPageVo(pageVo);
    }

    public PagingVO<PrdSystemNewFunctionVO> pagingKeyword(PrdSystemNewFunctionQuery query) {
        this.checkQuery(query);
        return this.dao.queryByKeyword(query);
    }

    private void checkQuery(PrdSystemNewFunctionQuery query) {
        if (query.getObjectId() == null) {
            throw TwException.error("", "objectId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void check(PrdSystemNewFunctionPayload payload) {
        if (!StringUtils.hasText((String)payload.getFunctionCode())) {
            throw TwException.error("", "functionCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)payload.getFunctionName())) {
            throw TwException.error("", "functionName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)payload.getClientType())) {
            throw TwException.error("", "clientType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.hasText((String)payload.getFunctionCode())) {
            Assert.isNull((Object)this.dao.queryByFunctionCode(payload.getFunctionCode()), (String)"objectCode\u5df2\u5b58\u5728");
        }
        if (!StringUtils.hasText((String)payload.getFunctionType())) {
            throw TwException.error("", "functionType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!FunctionTypeEnum.LINK_BUTTON.getName().equals(payload.getFunctionType())) {
            throw TwException.error("", "\u53ea\u80fd\u6dfb\u52a0LINK_BUTTON\u529f\u80fd");
        }
        if (payload.getFunctionStatus() == null) {
            throw TwException.error("", "functionStatus\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (payload.getObjectId() == null) {
            throw TwException.error("", "objectId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void autoCreate(Map<String, List<PrdSystemNewFunctionPayload>> functionMap) {
        ArrayList<String> objectCodes = new ArrayList<String>(functionMap.keySet());
        List<String> referDomainCodes = functionMap.values().stream().flatMap(Collection::stream).map(PrdSystemNewFunctionPayload::getReferDomainCodes).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).distinct().toList();
        objectCodes.addAll(referDomainCodes);
        List<PrdSystemBusinessObjectVO> objectList = this.businessObjectDAO.queryByObjectCodes(objectCodes);
        Map<String, PrdSystemBusinessObjectVO> objectMap = objectList.stream().collect(Collectors.toMap(PrdSystemBusinessObjectVO::getObjectCode, e -> e, (l, r) -> r));
        List<Long> objectIds = objectList.stream().map(BaseViewModel::getId).toList();
        List<PrdSystemNewFunctionVO> existFunctionList = this.dao.queryByObjectIds(objectIds);
        Map<String, PrdSystemNewFunctionVO> existFunctionMap = existFunctionList.stream().collect(Collectors.toMap(PrdSystemNewFunctionVO::getFunctionCode, e -> e, (l, r) -> r));
        ArrayList insertList = new ArrayList();
        ArrayList updateList = new ArrayList();
        functionMap.forEach((k, v) -> {
            if (objectMap.containsKey(k)) {
                PrdSystemBusinessObjectVO businessObject = (PrdSystemBusinessObjectVO)objectMap.get(k);
                v.forEach(f -> {
                    this.buildNewFunctionEntity(existFunctionMap, insertList, updateList, businessObject, (PrdSystemNewFunctionPayload)f, f.getFunctionCode());
                    if (!CollectionUtils.isEmpty((Collection)f.getReferDomainCodes())) {
                        f.getReferDomainCodes().forEach(referDomainCode -> {
                            if (objectMap.containsKey(referDomainCode)) {
                                PrdSystemBusinessObjectVO referDomainBusiness = (PrdSystemBusinessObjectVO)objectMap.get(referDomainCode);
                                this.buildNewFunctionEntity(existFunctionMap, insertList, updateList, referDomainBusiness, (PrdSystemNewFunctionPayload)f, referDomainCode + "/" + f.getFunctionCode());
                            }
                        });
                    }
                });
            }
        });
        List<String> nowFunctionCodes = functionMap.values().stream().flatMap(Collection::stream).map(PrdSystemNewFunctionPayload::getFunctionCode).distinct().toList();
        List<String> referFunctionCodes = functionMap.values().stream().flatMap(Collection::stream).filter(f -> !CollectionUtils.isEmpty((Collection)f.getReferDomainCodes())).map(f -> f.getReferDomainCodes().stream().map(referDomainCode -> referDomainCode + "/" + f.getFunctionCode()).toList()).flatMap(Collection::stream).filter(Objects::nonNull).distinct().toList();
        List<Long> deleteIds = existFunctionList.stream().filter(e -> !nowFunctionCodes.contains(e.getFunctionCode()) && !referFunctionCodes.contains(e.getFunctionCode()) && !FunctionTypeEnum.LINK_BUTTON.getName().equals(e.getFunctionType())).map(BaseViewModel::getId).toList();
        if (!CollectionUtils.isEmpty(insertList)) {
            this.repo.saveAll(insertList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.repo.saveAll(updateList);
        }
        if (!CollectionUtils.isEmpty(deleteIds)) {
            this.dao.deleteByIds(deleteIds);
        }
    }

    private void buildNewFunctionEntity(Map<String, PrdSystemNewFunctionVO> existFunctionMap, List<PrdSystemNewFunctionDO> insertList, List<PrdSystemNewFunctionDO> updateList, PrdSystemBusinessObjectVO businessObject, PrdSystemNewFunctionPayload f, String functionCode) {
        if (functionCode == null) {
            functionCode = f.getFunctionCode();
        }
        if (existFunctionMap.containsKey(functionCode)) {
            PrdSystemNewFunctionVO prdSystemNewFunctionVO = existFunctionMap.get(functionCode);
            PrdSystemNewFunctionDO entityDo = (PrdSystemNewFunctionDO)((Object)PrdSystemNewFunctionConvert.INSTANCE.toEntity(prdSystemNewFunctionVO));
            entityDo.setFunctionName(f.getFunctionName());
            entityDo.setFunctionType(f.getFunctionType());
            entityDo.setClientType(f.getClientType());
            updateList.add(entityDo);
        } else {
            PrdSystemNewFunctionDO entityDo = PrdSystemNewFunctionConvert.INSTANCE.toDo(f);
            entityDo.setObjectId(businessObject.getId());
            entityDo.setFunctionCode(functionCode);
            insertList.add(entityDo);
        }
    }

    public PagingVO<PrdOrgEmployeeVO> pagingUser(PrdOrgEmployeeQuery query) {
        this.checkListUser(query);
        PagingVO<PrdOrgEmployeeVO> pagingVO = this.dao.queryByListUser(query);
        List records = pagingVO.getRecords();
        for (PrdOrgEmployeeVO record : records) {
            record.setRoleDatas(this.dao.queryRoleByUserId(record.getUserId()));
        }
        return pagingVO;
    }

    public List<PrdSystemNewFunctionVO> list(Long objectId) {
        this.checkList(objectId);
        return this.dao.queryByObjectIds(Arrays.asList(objectId));
    }

    public PrdSystemNewFunctionVO getByFunctionCode(String functionCode) {
        return this.dao.queryByFunctionCode(functionCode);
    }

    public List<PrdSystemNewFunctionVO> listFieldConfig(Long objectId) {
        return this.dao.queryByObjectId(objectId);
    }

    public Long getObjectIdByFunctionCode(String codeRegx) {
        return this.dao.getObjectIdByFunctionCode(codeRegx);
    }

    private void checkList(Long objectId) {
        if (ObjectUtils.isEmpty((Object)objectId)) {
            throw TwException.error("", "objectId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkListUser(PrdOrgEmployeeQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getFunctionId())) {
            throw TwException.error("", "functionId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public PrdSystemNewFunctionServiceImpl(PrdSystemNewFunctionRepo repo, PrdSystemNewFunctionDAO dao, PrdSystemBusinessObjectDAO businessObjectDAO) {
        this.repo = repo;
        this.dao = dao;
        this.businessObjectDAO = businessObjectDAO;
    }
}

