package com.elitesland.tw.tw5.server.common.service;

import java.util.concurrent.Callable;

public interface TransactionUtilService {

    /**
     * 开启事务
     */
    void begin();

    /**
     * 提交事务
     */
    void commit();

    /**
     * 回滚事务
     */
    void rollback();

    /**
     * 在事务中执行回调函数
     *
     * @param callable 回调函数
     * @return V
     */
    <V> V executeWithCallable(Callable<V> callable);

    /**
     * 在事务中执行回调函数
     *
     * @param runnable 回调函数
     */
    void executeWithRunnable(Runnable runnable);

}
