package com.elitesland.tw.tw5.server.demo.controller;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.demo.payload.DemoSimplePayload;
import com.elitesland.tw.tw5.api.demo.query.DemoSimpleQuery;
import com.elitesland.tw.tw5.api.demo.service.DemoSimpleService;
import com.elitesland.tw.tw5.api.demo.vo.DemoSimpleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 标准样例controller
 *
 * @author zhangyongqiang
 */
@Api(value = "简单样例")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/demo")
@Slf4j
public class TwSimpleDemoController {

    private final DemoSimpleService service;

    @ApiOperation("新增")
    @PostMapping("/simple")
    //@GlobalTransactional
    public TwOutputUtil insert(DemoSimplePayload payload) {
        GeneralUserDetails user = SecurityContextUtil.currentUser();

        service.insert(payload);
        return TwOutputUtil.ok(payload);
    }

    @ApiOperation("修改")
    @PutMapping("/simple")
    //@GlobalTransactional
    public TwOutputUtil update(DemoSimplePayload payload) {
        service.update(payload);
        return TwOutputUtil.ok(payload);
    }

    @ApiOperation("主键查询")
    @GetMapping("/simple/{key}")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        DemoSimpleVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("分页查询")
    @GetMapping("/simple/paging")
    public TwOutputUtil paging(DemoSimpleQuery query) {
        PagingVO<DemoSimpleVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @ApiOperation("列表查询")
    @GetMapping("/simple/list")
    public TwOutputUtil queryList(DemoSimpleQuery query) {
        List<DemoSimpleVO> vos = service.queryList(query);
        return TwOutputUtil.ok(vos);
    }

    //@GlobalTransactional
    @ApiOperation("删除")
    @PatchMapping("/simple")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }
}
