package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccSubjectTemplateDetailPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccSubjectTemplatePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccSubjectTemplateDetailQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccSubjectTemplateQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccSubjectTemplateService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateDetailVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 新版科目模板管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Api(tags = "新版科目模板管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/acc/accSubjectTemplate")
@Slf4j
public class AccSubjectTemplateController {

    private final AccSubjectTemplateService accSubjectTemplateService;

    /**
     * 科目模板管理-新增第一步
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("科目模板管理-新增第一步")
    public TwOutputUtil<AccSubjectTemplateVO> insert(@RequestBody AccSubjectTemplatePayload payload) {
        return TwOutputUtil.ok(accSubjectTemplateService.insert(payload));
    }

    /**
     * 科目模板管理-新增第二步
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("科目模板管理-新增第二步")
    public TwOutputUtil<AccSubjectTemplateVO> update(@RequestBody AccSubjectTemplatePayload payload) {
        return TwOutputUtil.ok(accSubjectTemplateService.update(payload));
    }

    /**
     * 科目模板管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("科目模板管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccSubjectTemplatePayload payload) {
        return TwOutputUtil.ok(accSubjectTemplateService.updateByKeyDynamic(payload));
    }

    /**
     * 科目模板管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("科目模板管理-主键查询")
    public TwOutputUtil<AccSubjectTemplateVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accSubjectTemplateService.queryByKey(key));
    }

    /**
     * 科目模板管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("科目模板管理-分页")
    public TwOutputUtil<PagingVO<AccSubjectTemplateVO>> paging(AccSubjectTemplateQuery query) {
        return TwOutputUtil.ok(accSubjectTemplateService.queryPaging(query));
    }

    /**
     * 科目模板管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("科目模板管理-查询列表")
    public TwOutputUtil<List<AccSubjectTemplateVO>> queryList(AccSubjectTemplateQuery query) {
        return TwOutputUtil.ok(accSubjectTemplateService.queryListDynamic(query));
    }
//
//    /**
//     * 科目模板管理-删除
//     *
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    @ApiOperation("科目模板管理-删除")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//        accSubjectTemplateService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }

    /**
     * 科目模板管理-修改状态
     *
     * @param keys 主键id
     * @return result
     */
    @GetMapping("/updateStatus")
    @ApiOperation("科目模板管理-修改状态")
    public TwOutputUtil updateStatus(Long[] keys, String status) {
        accSubjectTemplateService.updateStatus(Arrays.asList(keys), status);
        return TwOutputUtil.ok();
    }

    /**
     * 科目模板关联科目-删除明细
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/detail/deleteSoft")
    @ApiOperation("科目模板关联科目-删除明细")
    public TwOutputUtil deleteSoftDetail(Long[] keys) {
        accSubjectTemplateService.deleteSoftDetail(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 科目模板关联科目-批量新增
     *
     * @param payloads 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/detail/bacthInsert")
    @ApiOperation("科目模板关联科目-批量新增")
    public TwOutputUtil<AccSubjectTemplateDetailVO> bacthInsert(@RequestBody List<AccSubjectTemplateDetailPayload> payloads) {
        return TwOutputUtil.ok(accSubjectTemplateService.bacthInsert(payloads));
    }

    /**
     * 科目模板管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/detail/paging")
    @UdcNameClass
    @ApiOperation("科目模板关联科目-分页")
    public TwOutputUtil<PagingVO<AccSubjectTemplateDetailVO>> pagingDetail(AccSubjectTemplateDetailQuery query) {
        return TwOutputUtil.ok(accSubjectTemplateService.queryPagingDetail(query));
    }

    /**
     * 科目模板管理-根据模板id查询预算项目列表
     *
     * @param tmplId 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryBudgetItem/{key}")
    @UdcNameClass
    @ApiOperation("科目模板-根据模板id查询预算项目列表")
    public TwOutputUtil<PagingVO<AccBudgetItemVO>> queryBudgetItemList(Long tmplId) {
        return TwOutputUtil.ok(accSubjectTemplateService.queryBudgetItemList(tmplId));
    }

}

