package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author sunxw
 * @description
 * @Date 2023/12/4
 * <p>
 * 差旅报销额度
 */
@Entity
@Table(name = "acc_reim_trip_std", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_trip_std", comment = "差旅报销额度")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimTripStdDO extends BaseModel implements Serializable {

    @Comment("P职级区间下限")
    @Column()
    private String jobGradePlLow;

    @Comment("P职级区间上限")
    @Column()
    private String jobGradePlUp;

    @Comment("M职级区间下限")
    @Column()
    private String jobGradeMlLow;

    @Comment("M职级区间上限")
    @Column()
    private String jobGradeMlUp;

    @Comment("费用类型 MEAL-餐费 HOTEL-住宿")
    @Column()
    private String feeType;

    @Comment("城市级别")
    @Column()
    private String cityLevel;

    @Comment("项目报销级别")
    @Column()
    private Integer projectFeeLevel;

    @Comment("报销额度")
    @Column()
    private BigDecimal feeAmt;

    public void copy(AccReimTripStdDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
