package com.elitesland.tw.tw5.server.prd.budget.service;


import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.query.ComChangeQuery;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.common.util.TreeListUtil;
import com.elitesland.tw.tw5.api.prd.acc.query.AccSubjectTemplateQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccSubjectTemplateService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetChangePayload;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetPayload;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetSubjectDetailPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetQuery;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetSubjectDetailQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetSubjectDetailService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetChangeVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetCommonVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetSubjectDetailVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectActivityPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanRoleService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConExecConditionService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConExecConditionVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.budget.common.functionEnum.BudgetControlType;
import com.elitesland.tw.tw5.server.prd.budget.common.functionEnum.BudgetRiskLevel;
import com.elitesland.tw.tw5.server.prd.budget.convert.BudgetConvert;
import com.elitesland.tw.tw5.server.prd.budget.convert.BudgetSubjectDetailConvert;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetDAO;
import com.elitesland.tw.tw5.server.prd.budget.entity.BudgetChangeTmpDO;
import com.elitesland.tw.tw5.server.prd.budget.entity.BudgetDO;
import com.elitesland.tw.tw5.server.prd.budget.repo.BudgetChangeTmpRepo;
import com.elitesland.tw.tw5.server.prd.budget.repo.BudgetRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.personplan.constants.PersonPlanTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 预算基本信息
 *
 * @author xxb
 * @date 2023-11-01
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BudgetServiceImpl extends BaseServiceImpl implements BudgetService {

    private final BudgetRepo budgetRepo;
    private final BudgetDAO budgetDAO;

    private final CacheUtil cacheUtil;

    private final ComChangeService changeService;

    private final AccSubjectTemplateService accSubjectTemplateService;

    private final PmsProjectActivityService pmsProjectActivityService;

    private final PrdSystemRoleService roleService;

    private final PmsProjectService pmsProjectService;

    private final WorkflowUtil workflowUtil;

    private final PmsResourcePlanRoleService pmsResourcePlanRoleService;

    private final BudgetSubjectDetailService budgetSubjectDetailService;


    private final BudgetCommonService budgetCommonService;

    private final FileUtil fileUtil;

    //    private final BudgetAppropriationDetailService appropriationDetailService;
    private final TransactionUtilService transactionUtilService;
    private final UdcUtil udcUtil;

    private final SaleConExecConditionService saleConExecConditionService;

    private final PrdMessageConfigService messageConfigService;
    private BigDecimal breakfastScale;
    @Value("${tw5.budget.approp_ratio:0.3}")
    private BigDecimal appropRatio;

    private final PrdOrgSyncLogDAO daoLog;

    private final BudgetChangeTmpRepo budgetChangeTmpRepo;
    private final PersonPlanService personPlanService;

    private final PrdOrgOrganizationService organizationService;

    @Override
    public BudgetVO queryBySource(Long sourceId, String sourceType) {
        // 判断非空
        if (ObjectUtils.isEmpty(sourceId)) {
            throw TwException.error("", "预算类型ID不能为空 !");
        }
        if (ObjectUtils.isEmpty(sourceType)) {
            throw TwException.error("", "预算类型不能为空 !");
        }
        BudgetVO budgetVO = budgetCommonService.querySimpleBySource(sourceId, sourceType);
        if (ObjectUtils.isEmpty(budgetVO)) {
            budgetVO = budgetCommonService.initBudget(sourceId, sourceType);
        } else {
            // 获取 项目、合同 相关信息
            budgetCommonService.addProjectInfo(budgetVO);
        }
        // 组装预算信息
        assemblyBudgetInformation(budgetVO);

        return budgetVO;
    }

    /**
     * 组装预算信息
     *
     * @param budgetVO
     * @return
     */
    public BudgetVO assemblyBudgetInformation(BudgetVO budgetVO) {
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(budgetVO.getSourceType())) {
            /**
             * 合同类型预算有预算活动计划等
             */
            // 只有预算时新建状态下，才展示 资源规划明细
            List<String> strings = Arrays.asList(WorkFlowStatusEnum.NOTSUBMIT.getCode(), WorkFlowStatusEnum.APPROVING_WORK.getCode(), WorkFlowStatusEnum.CREATE_WORK.getCode(), WorkFlowStatusEnum.REJECTED_WORK.getCode());
            if (ObjectUtils.isEmpty(budgetVO.getId()) || strings.contains(budgetVO.getBudgetStatus())) {
                // 获取 资源计划角色明细
                PersonPlanVO res = personPlanService.getByObjIdAndPlanType(budgetVO.getSourceId(), Arrays.asList(PersonPlanTypeEnum.PROJECT.getCode()));
                if (!ObjectUtils.isEmpty(res)) {
                    res = (PersonPlanVO) udcUtil.translate(res);
                    budgetVO.setResourcePlanVO(res);
                }
            }
            // 获取活动信息
            List<PmsProjectActivityVO> activityVOS = pmsProjectActivityService.queryActiveList(budgetVO.getSourceId(), 1);
            activityVOS.forEach(v -> {
                if (ObjectUtils.isEmpty(v.getUsedEqva())) {
                    v.setUsedEqva(BigDecimal.ZERO);
                }
                if (ObjectUtils.isEmpty(v.getUsedEqvaProportion())) {
                    v.setUsedEqvaProportion(BigDecimal.ZERO);
                }
            });
            budgetVO.setActivityVOS(activityVOS);
        }
        // 获取科目名称
        if (!ObjectUtils.isEmpty(budgetVO.getSubjectTempId())) {
            AccSubjectTemplateVO accSubjectTemplateVO = accSubjectTemplateService.queryByKey(budgetVO.getSubjectTempId());
            budgetVO.setSubjectTempName(accSubjectTemplateVO.getTmplName());
        }
        // 获取科目
        if (ObjectUtils.isEmpty(budgetVO.getId())) {
            //  根据模板 获取科目列表
            if (!ObjectUtils.isEmpty(budgetVO.getSubjectTempId())) {
                List<BudgetSubjectDetailVO> subjectDetailVOS = budgetCommonService.queryBySubjectTemplateId(budgetVO.getSourceType(), budgetVO.getSubjectTempId());
                budgetVO.setSubjectDetailVOS(subjectDetailVOS);
            }
        } else {
            List<BudgetSubjectDetailVO> subjectDetailVOS = budgetSubjectDetailService.queryListDyBudgetId(budgetVO.getId());
            budgetVO.setSubjectDetailVOS(subjectDetailVOS);
            //占用使用相关
            opertionOccupyAndUsed(budgetVO, null);
            // 变更总金额相关
            budgetCommonService.countTotalChange(budgetVO);
            budgetVO.setCreator(cacheUtil.getUserName(budgetVO.getCreateUserId()));
            budgetVO.setBudgetFilesData(fileUtil.getFileDatas(budgetVO.getBudgetFiles()));
        }
        //生成科目树
        generateSubjectTree(budgetVO);
        return budgetVO;
    }

    /**
     * 生成树形科目
     *
     * @param budgetVO
     */
    private void generateSubjectTree(BudgetVO budgetVO) {
        List<BudgetSubjectDetailVO> subjectDetailVOS = budgetVO.getSubjectDetailVOS();
        if (!ObjectUtils.isEmpty(subjectDetailVOS)) {
            // 根据accId对subjectDetailVOS进行升序排序
            subjectDetailVOS.sort(Comparator.comparing(BudgetSubjectDetailVO::getAccId));
            //  科目明细 转成树形结构
            TreeListUtil.toTree(subjectDetailVOS);
            budgetVO.setSubjectDetailVOSTree(subjectDetailVOS.stream().filter(v -> v.getAccParentId() == null).collect(Collectors.toList()));
        }
    }

    @Override
//    @Transactional(rollbackFor = Exception.class)
    public Long saveFirstBudget(BudgetPayload payload) {
        // 判断 新增还是修改
        BudgetVO budgetVO = budgetCommonService.querySimpleBySource(payload.getSourceId(), payload.getSourceType());
        if (budgetVO == null) {
            payload.setBudgetCode(generateSeqNum("PMS_BUDGET"));
            payload.setVersionNo(0);
            payload.setApplyResId(GlobalUtil.getLoginUserId());
            payload.setOccupyAmt(BigDecimal.ZERO);
            payload.setUsedAmt(BigDecimal.ZERO);
            payload.setOccupyEqva(BigDecimal.ZERO);
            payload.setUsedEqva(BigDecimal.ZERO);
        } else {
            payload.setId(budgetVO.getId());
            payload.setProcInstId(budgetVO.getProcInstId());
            if (!WorkFlowStatusEnum.CREATE_WORK.getCode().equals(budgetVO.getBudgetStatus())) {
                throw TwException.error("", "仅支持新建状态预算修改");
            }
        }
        //  预算数据验证
        checkBudgetData(payload, budgetVO, false);
        Long id;
        try {
            transactionUtilService.begin();
            // 保存预算信息、预算明细
            id = saveData(payload);
            transactionUtilService.commit();
        } catch (Exception e) {
            transactionUtilService.rollback();
            throw e;
        }

//        // 判断是否是 流程相关
//        if (payload.getSubmitFlag()) {
//            if (ObjectUtils.isEmpty(payload.getProcInstId())) {
//                submitProc(payload);
//            } else {
//                // 只单纯更改状态
//                ProcessInfo processInfo = new ProcessInfo();
//                processInfo.setProcInstStatus(ProcInstStatus.APPROVING);
//                updateStatus(payload.getId(), null, processInfo, payload.getControlType());
//            }
//        }
        return id;
    }

    /**
     * 发起审批流程
     */
    private void submitProc(BudgetPayload payload) {
        // 是否属于外部项目标记
        boolean outerProjectFlag = budgetCommonService.isExternalProject(payload.getPlatType());

        HashMap<String, Object> variables = new HashMap<>();
        String procInstName = "";
        String processDefinitionKey = "";
        // 判断项目类型 【交付项目、贸易含服务项目、运维项目」T&M项目】是否 走外部项目预算
        if (outerProjectFlag) {
            //  P03.外部项目预算申请流程-项目名称
            procInstName = "P03.外部项目预算申请流程" + "-" + payload.getSourceName();
            processDefinitionKey = PmsProcDefKey.PMS_BUDGET_APPLY_EXTERNAL.name();

            //pmo资源负责人
            variables.put("Activity_16c9tju", CollUtil.newArrayList(payload.getPmoResId()));
            //交付负责人
            variables.put("Activity_0wvmy6d", CollUtil.newArrayList(payload.getDeliUserId()));

            //交付BU负责人
            PrdOrgOrganizationVO deliBu = cacheUtil.getOrg(payload.getDeliBuId());
            variables.put("Activity_17d046h", CollUtil.newArrayList(deliBu.getManageId()));

//            // 平台财务负责人 PLAT_FIN_PIC
//          variables.put("Activity_1pmrfrd", roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ALL_PIC.getCode()));
            // 平台首席财务官
            variables.put("Activity_1pmrfrd", roleService.queryUserIdByRoleCode(RoleEnum.PLAT_CFO.getCode()));

            // 运营总裁  OPERATIONS_PRESIDENT
            variables.put("Activity_1qwwso3", roleService.queryUserIdByRoleCode(RoleEnum.OPERATION_PRESIDENT.getCode()));


            //获取 验证参数
            //  variables.putAll(budgetCommonService.getCheckParam(payload.getAppropriationPayload(), payload.getId(), payload.getContractId()));
        } else {
            //  P09.内部项目预算申请流程-项目名称
            procInstName = "P09.内部项目预算申请流程" + "-" + payload.getSourceName();
            processDefinitionKey = PmsProcDefKey.PMS_BUDGET_APPLY_INTERNAL.name();

            //交付负责人
            variables.put("Activity_0w72dta", CollUtil.newArrayList(payload.getDeliUserId()));
        }

        //发起流程审批
        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                processDefinitionKey,
                procInstName,
                payload.getId() + "",
                variables)
        );

        //流程启动成功后，回写业务表数据
        updateStatus(payload.getId(), procInstName, processInfo, payload.getControlType());
    }

    /**
     * 首次预算更新状态
     *
     * @param id
     * @param procInstName
     * @param processInfo
     * @param controlType
     */
    private void updateStatus(Long id, String procInstName, ProcessInfo processInfo, String controlType) {
        BudgetPayload payload0 = new BudgetPayload();
        payload0.setId(id);
        payload0.setProcInstName(procInstName);
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus().ordinal());
        payload0.setApplyDate(LocalDate.now());
        if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            payload0.setBudgetStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        } else if (ProcInstStatus.APPROVED.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            payload0.setBudgetStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        }
        budgetDAO.updateByKeyDynamic(payload0);
    }

    private static void calculateRecursive(BudgetSubjectDetailPayload node, Map<Long, List<BudgetSubjectDetailPayload>> childrenMap, Map<Long, BigDecimal> parentAmounts) {
        BigDecimal nodeAmount = node.getBudgetAmt();
        parentAmounts.put(node.getAccId(), nodeAmount);
        if (childrenMap.containsKey(node.getAccId())) {
            for (BudgetSubjectDetailPayload child : childrenMap.get(node.getAccId())) {
                calculateRecursive(child, childrenMap, parentAmounts);
                nodeAmount = nodeAmount.add(parentAmounts.get(child.getAccId()));
            }
        }
        parentAmounts.put(node.getAccId(), nodeAmount);
    }


    /**
     * 预算数据验证
     *
     * @param payload
     */
    void checkBudgetData(BudgetPayload payload, BudgetVO budgetVO, Boolean changeFlag) {
        // 非空验证
        checkNull(payload);
        // 计算金额相关数据
        countAmount(payload);
        if (changeFlag) {
            //如果是预算变更，要赋值原始值
            payload.setOriginalPlanAmt(budgetVO.getOriginalPlanAmt());
            payload.setOriginalPlanEqva(budgetVO.getOriginalPlanEqva());
            payload.setOriginalPlanEqvaAmt(budgetVO.getOriginalPlanEqvaAmt());
            payload.setOriginalTotalAmt(budgetVO.getOriginalTotalAmt());

            Map<Long, PmsProjectActivityVO> activityVOMap = budgetVO.getActivityVOS().stream().collect(Collectors.toMap(PmsProjectActivityVO::getId, Function.identity()));
            Map<Long, BudgetSubjectDetailVO> detailVOMap = budgetVO.getSubjectDetailVOS().stream().collect(Collectors.toMap(BudgetSubjectDetailVO::getId, Function.identity()));
            payload.getActivityPayloads().forEach(actPayload -> {
                if (actPayload.getId() != null) {
                    PmsProjectActivityVO pmsProjectActivityVO = activityVOMap.get(actPayload.getId());
                    if (pmsProjectActivityVO != null) {
                        actPayload.setOriginalPlanEqva(pmsProjectActivityVO.getOriginalPlanEqva());
                    }
                }
            });
            payload.getSubjectDetailPayloads().forEach(detailPayload -> {
                if (detailPayload.getId() != null) {
                    BudgetSubjectDetailVO budgetSubjectDetailVO = detailVOMap.get(detailPayload.getId());
                    if (budgetSubjectDetailVO != null) {
                        detailPayload.setOriginalAmt(budgetSubjectDetailVO.getOriginalAmt());
                    }
                }
            });
        } else {
            //非变更取对应初始值
            payload.setOriginalPlanAmt(payload.getPlanAmt());
            payload.setOriginalPlanEqva(payload.getPlanEqva());
            payload.setOriginalPlanEqvaAmt(payload.getPlanEqvaAmt());
            payload.setOriginalTotalAmt(payload.getTotalAmt());

            payload.getSubjectDetailPayloads().forEach(v -> v.setOriginalAmt(v.getBudgetAmt()));
            payload.getActivityPayloads().forEach(v -> v.setOriginalPlanEqva(v.getPlanEqva()));
        }
        //当控制策略=“不控制”时，所有科目明细行的控制开关禁用，值为“关闭”
        if (BudgetControlType.NO.getCode().equals(payload.getControlType()) || BudgetControlType.FLEXIBILITY.getCode().equals(payload.getControlType())) {
            payload.getSubjectDetailPayloads().forEach(v -> v.setDetailControlFlag(false));
        }
    }

    /**
     * 计算  金额  和 当量
     */
    void countAmount(BudgetPayload budgetPayload) {
        // 计算所有科目节点的预算金额
        List<BudgetSubjectDetailPayload> subjectDetailPayloads = budgetPayload.getSubjectDetailPayloads();
        // 判断是否需要重新计算父级科目预算金额
        Boolean countSubjectFlag = true;
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(budgetPayload.getSourceType())) {
            // 外部无合同提前入场：平台合同类型=提前入场虚拟合同，且子合同状态=待激活,费用预算部分禁止填写，规划费用金额就是为0
            if (budgetCommonService.isExternalNoContractProject(budgetPayload.getPlatType(), budgetPayload.getContractStatus())) {
                countSubjectFlag = false;
                subjectDetailPayloads.forEach(node -> {
                    node.setBudgetAmt(BigDecimal.ZERO);
                });
            }
        }
        BigDecimal planAmt = BigDecimal.ZERO;
        if (countSubjectFlag) {
            // 构建子节点列表
            Map<Long, List<BudgetSubjectDetailPayload>> childrenMap = subjectDetailPayloads.stream()
                    .filter(p -> p.getAccParentId() != null)
                    .collect(Collectors.groupingBy(BudgetSubjectDetailPayload::getAccParentId, LinkedHashMap::new, Collectors.toList()));
            // 清除父节点的金额,因为要重新计算
            subjectDetailPayloads.forEach(node -> {
                // 最高 父节点 、 中间 父节点
                if ((node.getAccParentId() == null && childrenMap.containsKey(node.getAccId())) || childrenMap.containsKey(node.getAccId()) || ObjectUtils.isEmpty(node.getBudgetAmt())) {
                    node.setBudgetAmt(BigDecimal.ZERO);
                }
            });
            Map<Long, BigDecimal> parentAmounts = new HashMap<>();
            // 递归计算父节点金额
            for (BudgetSubjectDetailPayload node : subjectDetailPayloads) {
                if (node.getAccParentId() == null) {
                    calculateRecursive(node, childrenMap, parentAmounts);
                }
            }
            // 将重新计算的父节点 赋值  并计算 预算总额
            for (BudgetSubjectDetailPayload node : subjectDetailPayloads) {
                BigDecimal budgetAmt = parentAmounts.get(node.getAccId());
                node.setBudgetAmt(budgetAmt);
                // 科目的可用金额 = 当前版本的预算总费用
                node.setAvailableAmt(budgetAmt);
                if (node.getAccParentId() == null) {
                    planAmt = planAmt.add(budgetAmt);
                }
            }
        }
        // 赋值 规划费用金额
        budgetPayload.setPlanAmt(planAmt);

        // 计算 当量 预算  BU和商机 没有活动
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(budgetPayload.getSourceType())) {
            List<PmsProjectActivityPayload> activityPayloads = budgetPayload.getActivityPayloads();
            BigDecimal eqvaBudgetCnt = activityPayloads.stream().filter(v -> !ObjectUtils.isEmpty(v.getPlanEqva()))
                    .map(PmsProjectActivityPayload::getPlanEqva)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            budgetPayload.setPlanEqva(eqvaBudgetCnt);
            budgetPayload.setPlanEqvaAmt(eqvaBudgetCnt.multiply(budgetPayload.getEqvaPrice()));
        }
        //预算总金额 = 规划当量金额+规划费用金额
        budgetPayload.setTotalAmt(budgetPayload.getPlanEqvaAmt().add(budgetPayload.getPlanAmt()));
    }


    /**
     * 非空验证
     *
     * @param payload
     */
    private void checkNull(BudgetPayload payload) {
        if (ObjectUtils.isEmpty(payload.getSourceType())) {
            throw TwException.error("", "费用归属不能为空 !");
        }
        if (ObjectUtils.isEmpty(payload.getSourceId())) {
            throw TwException.error("", "费用归属ID不能为空 !");
        }
        if (ObjectUtils.isEmpty(payload.getSourceCode())) {
            throw TwException.error("", "费用归属编号不能为空 !");
        }
        if (ObjectUtils.isEmpty(payload.getSourceName())) {
            throw TwException.error("", "费用归属名称不能为空 !");
        }
        if (ObjectUtils.isEmpty(payload.getDeliBuId())) {
            throw TwException.error("", "交付BUID不能为空 !");
        }
        if (ObjectUtils.isEmpty(payload.getBudgetName())) {
            throw TwException.error("", "预算名称不能为空 !");
        }
        if (ObjectUtils.isEmpty(payload.getControlType())) {
            throw TwException.error("", "控制策略不能为空!");
        }
        if (ObjectUtils.isEmpty(payload.getEqvaPrice())) {
            throw TwException.error("", "当量预估单价不能为空!");
        }
        if (ObjectUtils.isEmpty(payload.getSubjectTempId())) {
            throw TwException.error("", "subjectTempId不能为空!");
        }
    }

    /**
     * 第一次编辑预算时 保存 预算基本信息、科目明细、活动明细
     *
     * @param payload
     */
    private Long saveData(BudgetPayload payload) {
        Long budgetId = payload.getId();
        if (ObjectUtils.isEmpty(budgetId)) {
            BudgetDO entityDo = BudgetConvert.INSTANCE.toDo(payload);
            entityDo = budgetRepo.save(entityDo);
            budgetId = entityDo.getId();
            payload.setId(budgetId);
        } else {
            budgetDAO.updateByKeyDynamic(payload);

        }
        List<BudgetSubjectDetailPayload> subjectDetailPayloads = payload.getSubjectDetailPayloads();
        if (!ObjectUtils.isEmpty(subjectDetailPayloads)) {
            Long finalBudgetId = budgetId;
            subjectDetailPayloads.forEach(detail -> {
                detail.setBudgetId(finalBudgetId);
            });
            budgetSubjectDetailService.batchSave(subjectDetailPayloads);
        }
        // 保存活动的 规划变量
        List<PmsProjectActivityPayload> activityPayloads = payload.getActivityPayloads();
        if (!ObjectUtils.isEmpty(activityPayloads)) {
            // 不能更改活动的备注
            activityPayloads.forEach(v -> v.setRemark(null));
            pmsProjectActivityService.batchUpdate(activityPayloads);
        }
        return budgetId;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveOPPOAndBUTypeBudget(BudgetPayload payload) {
        //不需要预算控制
        payload.setControlType(BudgetControlType.NO.getCode());
        // 非空验证
        checkNull(payload);
        List<BudgetSubjectDetailPayload> subjectDetailPayloads = payload.getSubjectDetailPayloads();
        if (ObjectUtils.isEmpty(subjectDetailPayloads)) {
            throw TwException.error("", "预算科目明细不能为空!");
        }
        if (ObjectUtils.isEmpty(payload.getPlanEqva())) {
            payload.setPlanEqva(BigDecimal.ZERO);
        }
        if (ObjectUtils.isEmpty(payload.getPlanAmt())) {
            payload.setPlanAmt(BigDecimal.ZERO);
        }
        // 科目明细 费用设为0
        subjectDetailPayloads.forEach(subjectDetailPayload -> {
            subjectDetailPayload.setDetailControlFlag(false);
        });
        // 提交了预算就执行中了
        payload.setBudgetStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        // 判断下是新增还是修改
        BudgetVO budgetVO = budgetCommonService.querySimpleBySource(payload.getSourceId(), payload.getSourceType());
        if (ObjectUtils.isEmpty(budgetVO)) {
            payload.setBudgetCode(generateSeqNum("PMS_BUDGET"));
            payload.setVersionNo(0);
            payload.setApplyResId(GlobalUtil.getLoginUserId());
            payload.setOriginalPlanAmt(payload.getPlanAmt());
            payload.setOriginalPlanEqva(payload.getPlanEqva());
            payload.setOriginalTotalAmt(payload.getTotalAmt());
            payload.setOccupyAmt(BigDecimal.ZERO);
            payload.setUsedAmt(BigDecimal.ZERO);
            payload.setOccupyEqva(BigDecimal.ZERO);
            payload.setUsedEqva(BigDecimal.ZERO);
            payload.setTotalAmt(payload.getPlanEqva().multiply(payload.getEqvaPrice()).add(payload.getPlanAmt()));
            payload.setOriginalTotalAmt(payload.getTotalAmt());
        } else {
            payload.setId(budgetVO.getId());
            payload.setOriginalPlanAmt(budgetVO.getOriginalPlanAmt());
            payload.setOriginalPlanEqva(budgetVO.getOriginalPlanEqva());
            payload.setOriginalTotalAmt(budgetVO.getOriginalTotalAmt());
            if (budgetVO.getSubjectTempId() != null && payload.getSubjectTempId() != null && budgetVO.getSubjectTempId().longValue() != payload.getSubjectTempId().longValue()) {
                //先删除科目明细
                budgetSubjectDetailService.deleteSoftByBudgetId(budgetVO.getId());
            }
        }
        // 保存预算信息、预算明细
        saveData(payload);
    }


    @Override
    public BudgetVO queryBudgetByKey(Long key) {
        BudgetVO budgetVO = budgetDAO.queryByKey(key);
        // 获取 项目、合同 相关信息
        budgetCommonService.addProjectInfo(budgetVO);

        // 组装预算信息
        assemblyBudgetInformation(budgetVO);


        return budgetVO;
    }

    @Override
    public PagingVO<BudgetVO> queryPaging(BudgetQuery query) {
        PagingVO<BudgetVO> pagingVO = budgetDAO.queryPaging(query);
        if (pagingVO.getTotal() > 0) {
            // 项目编号、项目预算总成本、科目模板
            List<Long> subjectTempIds = pagingVO.getRecords().stream().filter(v -> !ObjectUtils.isEmpty(v.getSubjectTempId()))
                    .map(BudgetVO::getSubjectTempId).distinct().collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(subjectTempIds)) {
                AccSubjectTemplateQuery subjectTemplateQuery = new AccSubjectTemplateQuery();
                subjectTemplateQuery.setInIds(subjectTempIds);
                List<AccSubjectTemplateVO> subjectTemplateVOS = accSubjectTemplateService.queryListDynamic(subjectTemplateQuery);
                if (!ObjectUtils.isEmpty(subjectTemplateVOS)) {
                    Map<Long, String> subjectTemplateMap = subjectTemplateVOS.stream().collect(Collectors.toMap(AccSubjectTemplateVO::getId, AccSubjectTemplateVO::getTmplName));
                    pagingVO.getRecords().forEach(v -> {
                        if (!ObjectUtils.isEmpty(v.getSubjectTempId())) {
                            v.setSubjectTempName(subjectTemplateMap.get(v.getSubjectTempId()));
                        }
                    });
                }
            }
            List<String> reasonTypes = new ArrayList<>();
            List<Long> reasonIds = new ArrayList<>();
            pagingVO.getRecords().forEach(budgetVO -> {
                budgetVO.setCreator(cacheUtil.getUserName(budgetVO.getCreateUserId()));
                if (!reasonTypes.contains(budgetVO.getSourceType())) {
                    reasonTypes.add(budgetVO.getSourceType());
                }
                reasonIds.add(budgetVO.getSourceId());
            });
            //重新赋值占用费用金额,	已使用费用金额	已结算当量数/金额
            List<BudgetCommonVO> commonVOList = budgetCommonService.queryBudgetEqvaAndAmts(reasonTypes, reasonIds);
            pagingVO.getRecords().forEach(budgetVO -> {
                Optional<BudgetCommonVO> first = commonVOList.stream().filter(vo -> vo.getReasonType().equals(budgetVO.getSourceType()) && vo.getReasonId().equals(budgetVO.getSourceId())).findFirst();
                if (first.isPresent()) {
                    BudgetCommonVO commonVO = first.get();
                    //处理占用和使用
                    opertionOccupyAndUsed(budgetVO, commonVO);
                } else {
                    budgetVO.setOccupyEqva(BigDecimal.ZERO);
                    budgetVO.setUsedEqva(BigDecimal.ZERO);
                    budgetVO.setOccupyAmt(BigDecimal.ZERO);
                    budgetVO.setUsedAmt(BigDecimal.ZERO);
                }
            });
        }
        return pagingVO;
    }

    /**
     * 处理占用和使用
     */
    void opertionOccupyAndUsed(BudgetVO budgetVO, BudgetCommonVO commonVO) {
        if (commonVO == null) {
            commonVO = new BudgetCommonVO();
            commonVO.setReasonId(budgetVO.getSourceId());
            commonVO.setReasonType(budgetVO.getSourceType());
            commonVO.setContractId(budgetVO.getContractId());
            //占用使用相关
            commonVO = budgetCommonService.queryBudgetEqvaAndAmt(commonVO);
        }
        //1.计算预算总的占用使用
        budgetVO.setOccupyEqva(commonVO.getOccupyEqva());
        budgetVO.setOccupyEqvaAmt(budgetVO.getOccupyEqva().multiply(budgetVO.getEqvaPrice()));
        budgetVO.setUsedEqva(commonVO.getUsedEqva());
        budgetVO.setUsedEqvaAmt(commonVO.getUsedEqva().multiply(budgetVO.getEqvaPrice()));

        budgetVO.setOccupyAmt(commonVO.getOccupyAmt());
        budgetVO.setUsedAmt(commonVO.getUsedAmt());
        // 占用总金额
        budgetVO.setOccupyTotalAmt(budgetVO.getOccupyEqvaAmt().add(budgetVO.getOccupyAmt()));
        // 已使用总金额
        budgetVO.setUsedTotalAmt(budgetVO.getUsedEqvaAmt().add(budgetVO.getUsedAmt()));

        if (budgetVO.getPlanEqva().compareTo(BigDecimal.ZERO) > 0) {
            // 已使用当量总占比
            budgetVO.setUsedEqvaProportion(budgetVO.getUsedEqva().multiply(BigDecimal.valueOf(100)).divide(budgetVO.getPlanEqva(), 4, RoundingMode.HALF_UP));
            //累计投入当量占比
            BigDecimal add = budgetVO.getUsedEqva().add(budgetVO.getOccupyEqva());
            budgetVO.setTotalEqvaProportion(add.multiply(BigDecimal.valueOf(100)).divide(budgetVO.getPlanEqva(), 4, RoundingMode.HALF_UP));
        } else {
            budgetVO.setUsedEqvaProportion(BigDecimal.ZERO);
        }

        // 使用费用占比
        if (budgetVO.getPlanAmt().compareTo(BigDecimal.ZERO) > 0) {
            budgetVO.setUsedAmtProportion(budgetVO.getUsedAmt().multiply(BigDecimal.valueOf(100)).divide(budgetVO.getPlanAmt(), 4, RoundingMode.HALF_UP));
        } else {
            budgetVO.setUsedAmtProportion(BigDecimal.ZERO);
        }
        // 待确认getPlanAmt 使用总占比
        if (budgetVO.getPlanAmt().compareTo(BigDecimal.ZERO) > 0) {
            budgetVO.setUsedTotalProportion(budgetVO.getUsedTotalAmt().multiply(BigDecimal.valueOf(100)).divide(budgetVO.getTotalAmt(), 4, RoundingMode.HALF_UP));
        } else {
            budgetVO.setUsedTotalProportion(BigDecimal.ZERO);
        }
        //2.计算当量预算占用和使用
        List<PmsProjectActivityVO> activityVOS = budgetVO.getActivityVOS();
        if (activityVOS != null) {
            Map<Long, BigDecimal> actOccupyEqvaMap = commonVO.getActOccupyEqvaMap();
            Map<Long, BigDecimal> actUsedEqvaMap = commonVO.getActUsedEqvaMap();
            activityVOS.forEach(activityVO -> {
                activityVO.setOccupyEqva(actOccupyEqvaMap.get(activityVO.getId()));
                activityVO.setUsedEqva(actUsedEqvaMap.get(activityVO.getId()) == null ? BigDecimal.ZERO : actUsedEqvaMap.get(activityVO.getId()));
                if (activityVO.getPlanEqva() == null || activityVO.getPlanEqva().compareTo(BigDecimal.ZERO) == 0) {
                    activityVO.setUsedEqvaProportion(BigDecimal.ZERO);
                } else {
                    activityVO.setUsedEqvaProportion(activityVO.getUsedEqva().multiply(BigDecimal.valueOf(100)).divide(activityVO.getPlanEqva(), 4, RoundingMode.HALF_DOWN));
                }
            });
        }
        List<BudgetSubjectDetailVO> subjectDetailVOS = budgetVO.getSubjectDetailVOS();
        if (subjectDetailVOS != null) {
            Map<Long, BigDecimal> accOccupyAmtMap = commonVO.getAccOccupyAmtMap();
            Map<Long, BigDecimal> accUsedAmtMap = commonVO.getAccUsedAmtMap();

            subjectDetailVOS.forEach(detailVO -> {
                if (detailVO.getAccId() != null) {
                    detailVO.setOccupyAmt(accOccupyAmtMap.get(detailVO.getAccId()));
                    detailVO.setUsedAmt(accUsedAmtMap.get(detailVO.getAccId()) == null ? BigDecimal.ZERO : accUsedAmtMap.get(detailVO.getAccId()));
                    if (detailVO.getBudgetAmt() == null || detailVO.getBudgetAmt().compareTo(BigDecimal.ZERO) == 0) {
                        detailVO.setUsedAmtProportion(BigDecimal.ZERO);
                    } else {
                        detailVO.setUsedAmtProportion(detailVO.getUsedAmt().multiply(BigDecimal.valueOf(100)).divide(detailVO.getBudgetAmt(), 4, RoundingMode.HALF_DOWN));
                    }
                }

            });
        }

    }


    @Override
    public List<BudgetVO> queryList(BudgetQuery query) {
        return budgetDAO.queryListDynamic(query);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<BudgetVO> list = budgetDAO.queryByKeys(keys);
            for (BudgetVO budgetVO : list) {
                if (!WorkFlowStatusEnum.CREATE_WORK.getCode().equals(budgetVO.getBudgetStatus())) {
                    throw TwException.error("", "只有预算状态是是新建的才可以删除！");
                }
            }
            budgetDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<PmsProjectVO> queryProjectNoBudget() {
        BudgetQuery budgetQuery = new BudgetQuery();
        budgetQuery.setSourceType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
        List<BudgetVO> budgetVOS = budgetDAO.queryListDynamic(budgetQuery);
        // 获取项目id集合
        List<Long> projectIds = budgetVOS.stream().map(v -> v.getSourceId()).collect(Collectors.toList());
        PmsProjectQuery projectQuery = new PmsProjectQuery();
        projectQuery.setNotInIds(projectIds);
        return pmsProjectService.queryListDynamic(projectQuery);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void synchronizationTemp(List<Long> keys, Long tmplId) {
        if (ObjectUtils.isEmpty(keys)) {
            throw TwException.error("", "预算集合不能为空");
        }
        if (ObjectUtils.isEmpty(tmplId)) {
            throw TwException.error("", "模板id不能为空");
        }
        //根据模板id 查询模板预算科目
        List<AccBudgetItemVO> budgetItems = accSubjectTemplateService.queryBudgetItemList(tmplId);

        Map<Long, AccBudgetItemVO> budgetItemMap = budgetItems.stream()
                .collect(Collectors.toMap(AccBudgetItemVO::getId, Function.identity(), (o, n) -> o));
        //查询已做预算科目
        BudgetSubjectDetailQuery query = new BudgetSubjectDetailQuery();
        query.setBudgetIds(keys);
        List<BudgetSubjectDetailVO> budgetSubjectDetailVOS = budgetSubjectDetailService.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(budgetSubjectDetailVOS)) {
            //需要保存的数据
            List<BudgetSubjectDetailPayload> subjectDetailPayloads = new ArrayList<>();
            //提取已做预算科目为map结构
            Map<Long, List<BudgetSubjectDetailVO>> collect = budgetSubjectDetailVOS.stream().collect(Collectors.groupingBy(BudgetSubjectDetailVO::getBudgetId));
            keys.forEach(budgetId -> {
                //判断缺少的科目明细
                List<BudgetSubjectDetailVO> twBudgetDetailViews = collect.get(budgetId);
                Map<Long, BudgetSubjectDetailVO> budgetDetailItemMap = twBudgetDetailViews.stream()
                        .collect(Collectors.toMap(BudgetSubjectDetailVO::getAccId, Function.identity(), (o, n) -> o));
                // 查找出 缺少的科目
                Set<Long> missBudgetItemIds = budgetItemMap.keySet().stream().filter(accId -> !budgetDetailItemMap.containsKey(accId)).collect(Collectors.toSet());
                if (!ObjectUtils.isEmpty(missBudgetItemIds)) {
                    //添加科目明细的上级
                    Set<Long> newMissBudgetItemIds = addBudgetItemParent(missBudgetItemIds, budgetItemMap, budgetDetailItemMap);
                    if (!ObjectUtils.isEmpty(newMissBudgetItemIds)) {
                        newMissBudgetItemIds.stream().forEach(budgetItemId -> {
                            BudgetSubjectDetailPayload detail = new BudgetSubjectDetailPayload();
                            detail.setBudgetId(budgetId);
                            detail.setAccId(budgetItemId);
                            detail.setBudgetAmt(BigDecimal.ZERO);
                            detail.setFeeReleasedAmt(BigDecimal.ZERO);
                            detail.setUsedAmt(BigDecimal.ZERO);
                            detail.setOccupyAmt(BigDecimal.ZERO);
                            detail.setDetailControlFlag(false);
                            subjectDetailPayloads.add(detail);
                        });

                    }
                }
            });
            if (subjectDetailPayloads.size() > 0) {
                budgetSubjectDetailService.batchSave(subjectDetailPayloads);
            }
        }

    }

    @Override
    public BudgetVO queryByKey(Long key) {
        return budgetDAO.queryByKey(key);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveBudgetChange(BudgetChangePayload budgetChangePayload) {

        // 数据验证
        BudgetPayload budgetPayload = budgetChangePayload.getBudgetPayload();
        if (ObjectUtils.isEmpty(budgetPayload)) {
            throw TwException.error("", "预算信息不能为空 !");
        }
        String changeDocId = String.valueOf(budgetPayload.getId());
        if (ObjectUtils.isEmpty(changeDocId)) {
            throw TwException.error("", "预算ID不能为空 !");
        }
        BudgetVO budgetVO = budgetDAO.queryByKey(budgetPayload.getId());
        if (budgetVO == null) {
            throw TwException.error("", "预算数据不存在");
        }
        GlobalUtil.getLoginUserId();


//        if (!budgetVO.getBudgetStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.name())) {
//            throw TwException.error("", "预算激活后才可发起变更");
//        }
        if (!ObjectUtils.isEmpty(budgetChangePayload.getId())) {
            ComChangeVO comChangeVO = changeService.queryByKey(budgetChangePayload.getId());
            budgetChangePayload.setApprProcInstId(comChangeVO.getApprProcInstId());
            budgetPayload.setVersionNo(comChangeVO.getVersionNo());
        }
        if (budgetChangePayload.getSubmitFlag() && ObjectUtils.isEmpty(budgetChangePayload.getApprProcInstId())) {
            budgetCommonService.checkOnlyOneProc(budgetVO);
        }
        //组装活动和明细数据
        assemblyBudgetInformation(budgetVO);
        // 清除审批相关数据
        budgetPayload.setProcInstId(null);
        budgetPayload.setProcDefKey(null);
        budgetPayload.setProcInstName(null);
        budgetPayload.setProcInstStatus(null);

        //  预算数据验证
        checkBudgetData(budgetPayload, budgetVO, true);

        // 保存预算 变更信息
        // 判断 新增还是修改
        if (ObjectUtils.isEmpty(budgetChangePayload.getId())) {
            // 获取当前版本预算信息
            BudgetVO budgetOld = queryBySource(budgetPayload.getSourceId(), budgetPayload.getSourceType());
            budgetChangePayload.setId(changeService.save(ChangeTypeEnum.BUDGET_CHANGE.getCode(), budgetOld, budgetPayload, changeDocId));
        } else {
            changeService.update(ChangeTypeEnum.BUDGET_CHANGE.getCode(), changeDocId, budgetPayload);
        }
//
//        // 判断是否是 流程相关
//        if (budgetChangePayload.getSubmitFlag()) {
//            // 只有平台合同类型是 平台内 平台外 无合同入场虚拟合同 才会走外部项目预算变更流程
//            if (ObjectUtils.isEmpty(budgetChangePayload.getApprProcInstId())) {
////                if (SaleConEnum.INTERNAL.getCode().equals(budgetPayload.getPlatType()) ||
////                        SaleConEnum.EXTERNAL.getCode().equals(budgetPayload.getPlatType()) ||
////                        SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode().equals(budgetPayload.getPlatType())) {
////                    // 外部合同项目当量变更
////                    if (BudgetChangeTypeEnum.EQVA.getCode().equals(budgetPayload.getBudgetChangeType())) {
////                        submitOutEqvaChangeProc(budgetChangePayload);
////                    }
////                    // 外部合同项目金额变更
////                    if (BudgetChangeTypeEnum.AMT.getCode().equals(budgetPayload.getBudgetChangeType())) {
////                        submitOutAmtChangeProc(budgetChangePayload);
////                    }
////                } else {
//                // 其他类型保持不变
//                submitChangeProc(budgetChangePayload);
////                }
//            } else {
//                // 只单纯更改状态
//                ComChangePayload changePayload = new ComChangePayload();
//                changePayload.setId(budgetChangePayload.getId());
//                changePayload.setApprProcInstId(budgetChangePayload.getApprProcInstId());
//                changePayload.setApprStatus(ProcInstStatus.APPROVING.name());
//                changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
//                changePayload.setChangeContent(JSONObject.toJSONString(budgetPayload));
//                changePayload.setExtString1(budgetChangePayload.getExtString1());
//                changePayload.setExtString2(budgetChangePayload.getExtString2());
//                changePayload.setExtString3(budgetChangePayload.getExtString3());
//                changeService.updateWorkFlow(changePayload);
//
//                // 因为金额可能会改变 所以重新设置下流程参数
//                SetVariablesPayload payload = new SetVariablesPayload();
//                payload.setProcInstId(budgetChangePayload.getApprProcInstId());
//                // 只有平台合同类型是 平台内 平台外 无合同入场虚拟合同 才会走外部项目预算变更流程
////                if (SaleConEnum.INTERNAL.getCode().equals(budgetPayload.getPlatType()) ||
////                        SaleConEnum.EXTERNAL.getCode().equals(budgetPayload.getPlatType()) ||
////                        SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode().equals(budgetPayload.getPlatType())) {
////                    // 外部合同项目当量变更
////                    if (BudgetChangeTypeEnum.EQVA.getCode().equals(budgetPayload.getBudgetChangeType())) {
////                        HashMap<String, Object> variables = dealOutEqvaChangeVariable(budgetChangePayload.getBudgetPayload());
////                        payload.setVariables(variables);
////                    }
////                    // 外部合同项目金额变更
////                    if (BudgetChangeTypeEnum.AMT.getCode().equals(budgetPayload.getBudgetChangeType())) {
////                        HashMap<String, Object> variables = dealOutAmtChangeVariable(budgetChangePayload.getBudgetPayload());
////                        payload.setVariables(variables);
////                    }
////                } else {
//                // 其他类型保持不变
//                HashMap<String, Object> variables = dealChangeVariable(budgetVO, budgetChangePayload.getBudgetPayload());
//                payload.setVariables(variables);
////                }
//                workflowUtil.setVaribales(payload);
//            }
//        }
    }

    @Override
    public BudgetChangeVO queryBudgetChangeByKey(Long key) {
        ComChangeVO comChangeVO = changeService.queryByKey(key);
        BudgetChangeVO budgetChangeVO = new BudgetChangeVO();
        budgetChangeVO.setId(comChangeVO.getId());
        //变更状态、变更简述、变更说明 、后续措施
        budgetChangeVO.setChangeStatus(comChangeVO.getChangeStatus());
        budgetChangeVO.setExtString1(comChangeVO.getExtString1());
        budgetChangeVO.setExtString2(comChangeVO.getExtString2());
        budgetChangeVO.setExtString3(comChangeVO.getExtString3());
        budgetChangeVO.setApprProcInstId(comChangeVO.getApprProcInstId());

        String changeDocId = comChangeVO.getChangeDocId();
        BudgetPayload maxPayload = JSON.parseObject(comChangeVO.getChangeContent(), BudgetPayload.class);
        BudgetVO currentVersionBudge = BudgetConvert.INSTANCE.toVo(BudgetConvert.INSTANCE.toDo(maxPayload));
        currentVersionBudge.setCreateUserId(comChangeVO.getCreateUserId());
        currentVersionBudge.setCreator(cacheUtil.getUserName(currentVersionBudge.getCreateUserId()));
        currentVersionBudge.setCreateTime(comChangeVO.getCreateTime());
//        currentVersionBudge.setSourceTypeDesc(cacheUtil.getSystemSelectionValueByName("PMS:PROJECT:TYPE", currentVersionBudge.getSourceType()));
//        currentVersionBudge.setBudgetStatusDesc(cacheUtil.getSystemSelectionValueByName("budget:status", currentVersionBudge.getBudgetStatus()));
//        currentVersionBudge.setControlTypeDesc(cacheUtil.getSystemSelectionValueByName("BUDGET:CONTROLTYPE", currentVersionBudge.getControlType()));

        // 组装预算信息
        // 要展示与上一次 的对比 信息
        Map<String, BudgetSubjectDetailPayload> subjectInfo = new HashMap<>();
        Map<String, BigDecimal> activityInfo = new HashMap<>();
        //先查询出当前版本的值
        countSubject(maxPayload, subjectInfo);
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(maxPayload.getSourceType())) {
            // 获取 合同金额、有效合同金额、销售负责人
            budgetCommonService.addProjectInfo(currentVersionBudge);
            currentVersionBudge.setSaleManUserName(cacheUtil.getUserName(currentVersionBudge.getSaleManUserId()));
            // 获取科目名称
            if (!ObjectUtils.isEmpty(currentVersionBudge.getSubjectTempId())) {
                AccSubjectTemplateVO accSubjectTemplateVO = accSubjectTemplateService.queryByKey(currentVersionBudge.getSubjectTempId());
                currentVersionBudge.setSubjectTempName(accSubjectTemplateVO.getTmplName());
            }
            countActivity(maxPayload, activityInfo);
        }

        //当前版本号
        int currentVersionNo = comChangeVO.getVersionNo();
        //上一个版本号
        int previousVersionNo = currentVersionNo - 1;

        ComChangeVO comChangeVOBefore = changeService.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(ChangeTypeEnum.BUDGET_CHANGE.getCode(), comChangeVO.getChangeDocId(), previousVersionNo);
        if (previousVersionNo == 0) {
            BudgetVO previousVersionBudge = JSON.parseObject(comChangeVOBefore.getChangeContent(), BudgetVO.class);
            //科目明细
            List<BudgetSubjectDetailVO> subjectDetailVOS = previousVersionBudge.getSubjectDetailVOS();
            if (!ObjectUtils.isEmpty(subjectDetailVOS)) {
                for (BudgetSubjectDetailVO vo : subjectDetailVOS) {

                    subjectInfo.put(vo.getId() + "_" + previousVersionNo, BudgetSubjectDetailConvert.INSTANCE.toPayload(vo));
                }
            }
            //活动明细
            if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(maxPayload.getSourceType())) {
                List<PmsProjectActivityVO> activityVOS = previousVersionBudge.getActivityVOS();
                if (!ObjectUtils.isEmpty(activityVOS)) {
                    for (PmsProjectActivityVO vo : activityVOS) {
                        activityInfo.put(vo.getId() + "_" + previousVersionNo, vo.getPlanEqva() == null ? BigDecimal.ZERO : vo.getPlanEqva());
                    }
                }
            }
        } else {
            ComChangeVO comChangeVO0 = changeService.findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(ChangeTypeEnum.BUDGET_CHANGE.getCode(), comChangeVO.getChangeDocId(), previousVersionNo);

            BudgetPayload minPayload = JSON.parseObject(comChangeVO0.getChangeContent(), BudgetPayload.class);
            countSubject(minPayload, subjectInfo);
            if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(maxPayload.getSourceType())) {
                countActivity(minPayload, activityInfo);
            }
        }

        //科目明细
        List<BudgetSubjectDetailVO> subjectDetailVOS = budgetSubjectDetailService.queryListDyBudgetId(Long.valueOf(changeDocId));
        if (!ObjectUtils.isEmpty(subjectDetailVOS)) {


            for (BudgetSubjectDetailVO vo : subjectDetailVOS) {
                vo.setAfterValue(BigDecimal.ZERO);
                vo.setBeforeValue(BigDecimal.ZERO);
                BudgetSubjectDetailPayload newDetailPayload = subjectInfo.get(vo.getId() + "_" + currentVersionNo);
                BudgetSubjectDetailPayload oldDetailPayload = subjectInfo.get(vo.getId() + "_" + previousVersionNo);
                if (oldDetailPayload != null) {
                    if (oldDetailPayload.getBudgetAmt() != null) {
                        vo.setBeforeValue(oldDetailPayload.getBudgetAmt());
                    }
                    vo.setRemark(oldDetailPayload.getRemark());
                }
                if (newDetailPayload != null) {
                    if (newDetailPayload.getBudgetAmt() != null) {
                        vo.setAfterValue(newDetailPayload.getBudgetAmt());
                    }
                    vo.setRemark(newDetailPayload.getRemark());
                }
                vo.setDeltaValue(vo.getAfterValue().subtract(vo.getBeforeValue()));
//                vo.getBudgetAmt()
//                vo.setAfterValue(subjectInfo.getOrDefault(vo.getId() + "_" + currentVersionNo, BigDecimal.ZERO));
//                vo.setBeforeValue(subjectInfo.getOrDefault(vo.getId() + "_" + previousVersionNo, BigDecimal.ZERO));

            }
        }
        currentVersionBudge.setSubjectDetailVOS(subjectDetailVOS);
        // 生成科目树
        generateSubjectTree(currentVersionBudge);

        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(maxPayload.getSourceType())) {
            //活动明细
            List<PmsProjectActivityVO> activityVOS = pmsProjectActivityService.queryActiveList(maxPayload.getSourceId(), 1);
            if (!ObjectUtils.isEmpty(activityVOS)) {
                for (PmsProjectActivityVO vo : activityVOS) {
                    vo.setAfterValue(activityInfo.getOrDefault(vo.getId() + "_" + currentVersionNo, BigDecimal.ZERO));
                    vo.setBeforeValue(activityInfo.getOrDefault(vo.getId() + "_" + previousVersionNo, BigDecimal.ZERO));
                    vo.setDeltaValue(vo.getAfterValue().subtract(vo.getBeforeValue()));
                }

                // 添加 变更备注
                List<PmsProjectActivityPayload> activityPayloads = maxPayload.getActivityPayloads();
                if (!ObjectUtils.isEmpty(activityPayloads)) {
                    Map<Long, String> changeRemarks = activityPayloads.stream().filter(v -> !ObjectUtils.isEmpty(v.getChangeRemark())).collect(Collectors.toMap(PmsProjectActivityPayload::getId, PmsProjectActivityPayload::getChangeRemark));
                    if (!ObjectUtils.isEmpty(changeRemarks)) {
                        activityVOS.forEach(v -> v.setChangeRemark(changeRemarks.get(v.getId())));
                    }
                }
            }

            //当量预算变更
            currentVersionBudge.setActivityVOS(activityVOS);
        }
        //  拨付相关金额、当量使用相关、费用使用相关 信息
//        budgetCommonService.getAppropriationInfo(currentVersionBudge);
//        currentVersionBudge.setAllocatedAppropriation(currentVersionBudge.getAllocatedAppropriation().multiply(BigDecimal.valueOf(100)));
//        //处理占用和使用
        opertionOccupyAndUsed(currentVersionBudge, null);
        // 累计变更 相关
        budgetCommonService.countCurrentChange(currentVersionBudge);
        currentVersionBudge.setBudgetFilesData(fileUtil.getFileDatas(currentVersionBudge.getBudgetFiles()));
        budgetChangeVO.setBudgetVO((BudgetVO) udcUtil.translate(currentVersionBudge));
        return budgetChangeVO;
    }
//    /**
//     * 发起变更审批流程
//     */
//    private void submitChangeProc(BudgetChangePayload budgetChangePayload) {
//        ComChangeVO comChangeVO = changeService.queryByKey(budgetChangePayload.getId());
//
//        BudgetPayload budgetPayload = budgetChangePayload.getBudgetPayload();
//        BudgetVO budgetVO = budgetDAO.queryByKey(budgetPayload.getId());
//
//        // 处理变更流程参数
//        HashMap<String, Object> variables = dealChangeVariable(budgetVO, budgetPayload);
//
//        // P05.项目预算变更流程-项目名称
//        String procInstName = "P05.项目预算变更流程" + "-" + budgetPayload.getSourceName();
//
//        //发起流程审批
//        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
//                PmsProcDefKey.PMS_BUDGET_CHANGE.name(),
//                procInstName,
//                budgetChangePayload.getId() + "",
//                variables)
//        );
//        //流程启动成功后，回写业务表数据
//        ComChangePayload changePayload = new ComChangePayload();
//        changePayload.setId(budgetChangePayload.getId());
//        changePayload.setApprProcInstId(processInfo.getProcInstId());
//        changePayload.setApprStatus(ProcInstStatus.APPROVING.name());
//
//        if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
//            changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
//        } else if (ProcInstStatus.APPROVED.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
//            changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
//
//            // 变更成功后的操作
//            changeSuccess(comChangeVO);
//        }
//        budgetPayload.setVersionNo(comChangeVO.getVersionNo());
//        changePayload.setChangeContent(JSONObject.toJSONString(budgetPayload));
//        changePayload.setExtString1(budgetChangePayload.getExtString1());
//        changePayload.setExtString2(budgetChangePayload.getExtString2());
//        changePayload.setExtString3(budgetChangePayload.getExtString3());
//        changePayload.setExtString4(procInstName);
//        changeService.updateWorkFlow(changePayload);
//
//        if (budgetVO.getSourceType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
//            //合同项目发起变更同时取消项目预算需变更代办提示
//            pmsProjectService.updateBudgetAfterUpdateProject(budgetVO.getSourceId());
//        }
//
//    }
//
//    // 处理内部项目预算变更的流程参数
//    private HashMap<String, Object> dealChangeVariable(BudgetVO budgetVO, BudgetPayload budgetPayload) {
//        // 初版预算总金额
//        BigDecimal original = budgetVO.getOriginalTotalAmt();
//        BigDecimal proportion = BigDecimal.ZERO;
//        if (original.compareTo(BigDecimal.ZERO) != 0) {
//            BigDecimal dAmt = budgetPayload.getTotalAmt().subtract(budgetVO.getTotalAmt());
//            proportion = dAmt.divide(original, 4, RoundingMode.UP);
//        }
//        HashMap<String, Object> variables = new HashMap<>();
//        //如果proportion的值小于等于0.1，则返回true
//        variables.put("check1", proportion.compareTo(new BigDecimal(0.1)) < 1);
//        // 如果proportion的值大于0.1并且小于等于0.3，则返回true
//        variables.put("check2", proportion.compareTo(new BigDecimal(0.1)) > 0 && proportion.compareTo(new BigDecimal(0.3)) < 1);
//        //如果proportion的值大于0.3，则返回true
//        variables.put("check3", proportion.compareTo(new BigDecimal(0.3)) > 0);
//
//        // 平台财务负责人 PLAT_FIN_PIC
//        variables.put("Activity_0w3njit", roleService.queryUserIdByRoleCode(RoleEnum.PLAT_FIN_PIC.getCode()));
//        // 运营总裁  OPERATIONS_PRESIDENT
//        variables.put("Activity_1uorpec", roleService.queryUserIdByRoleCode(RoleEnum.OPERATION_PRESIDENT.getCode()));
//        //平台总体负责人 PLAT_ALL_PIC
//        variables.put("Activity_10kt8mw", roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ALL_PIC.getCode()));
//        return variables;
//    }
    ///////////////////////TODO //////////////////////////////////////////


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processStatusChange(ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_APPLY_EXTERNAL.getName()) || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_APPLY_INTERNAL.getName())) {
            //根据业务key查询当前业务对象
            BudgetVO budgetVO = budgetDAO.queryByKey(Long.valueOf(businessKey));
            if (budgetVO != null) {
                BudgetPayload budgetPayload = new BudgetPayload();
                budgetPayload.setId(Long.valueOf(businessKey));
                budgetPayload.setProcInstStatus(procInstStatus.ordinal());
                switch (procInstStatus) {
                    case NOTSUBMIT://创建人提交节点
                        //一般情况将单据状态变成"新建",流程状态改为未提交
                        budgetPayload.setBudgetStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                        break;
                    case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                        //一般情况将单据状态变成"草稿",并且将单据上的"流程实例状态"，"流程实例ID"清成null(不是空字符串)
                        budgetPayload.setBudgetStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                        budgetPayload.setProcInstId(null);
                        budgetPayload.setNullFields(List.of("procInstId"));
                        break;
                    case INVALID://先删除流程再删除单据
                        //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                        budgetPayload.setBudgetStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                        budgetPayload.setProcInstId(null);
                        budgetPayload.setNullFields(List.of("procInstId"));
                        budgetPayload.setDeleteFlag(1);
                        break;
                    case REJECTED://审批人拒绝 - 预算状态：新建 - 阶段拨付状态：拨付审批拒绝
                        budgetPayload.setBudgetStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                        break;
                    case APPROVED://审批人拒绝 - 预算状态：执行中 - 阶段拨付状态：拨付完成
                        budgetPayload.setBudgetStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                        break;
                    case APPROVING:
                        budgetPayload.setBudgetStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                        break;
                }
                budgetDAO.updateByKeyDynamic(budgetPayload);

            }
        } else if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_CHANGE.getName()) || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BGCHANGE_OUT_EQV.getName()) || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BGCHANGE_OUT_AMT.getName())) {
            //根据业务key查询当前业务对象
            ComChangeVO comChangeVO = changeService.queryByKey(Long.valueOf(businessKey));
            if (comChangeVO != null) {
                ComChangePayload changePayload = new ComChangePayload();
                changePayload.setId(comChangeVO.getId());
                changePayload.setApprStatus(procInstStatus.name());
                changePayload.setApprProcInstId(comChangeVO.getApprProcInstId());
                switch (procInstStatus) {
                    case NOTSUBMIT://创建人提交节点
                        //一般情况将单据状态变成"新建",流程状态改为未提交
                        changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                        break;
                    case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                        //一般情况将单据状态变成"草稿",并且将单据上的"流程实例状态"，"流程实例ID"清成null(不是空字符串)
                        changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                        changePayload.setApprProcInstId(null);
                        break;
                    case INVALID://先删除流程再删除单据
                        //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                        changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                        changePayload.setApprProcInstId(null);
                        changePayload.setDeleteFlag(1);
                        break;
                    case REJECTED://审批人拒绝，回到第一个节点
                        changePayload.setChangeStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                        break;
                    case APPROVED:
                        changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                        String taskDefKey = payload.getCommentInfo().getTaskDefKey();
                        //外部项目当量预算变更  0<风暴区<=5% 要知会平台PMO和CFO
                        if ("Activity_0ihafu5".equals(taskDefKey)) {
                            BudgetPayload budgetPayload = JSONObject.parseObject(comChangeVO.getChangeContent(), BudgetPayload.class);
                            String content = "预算名称为[" + budgetPayload.getBudgetName() + "] 的当量预算变更超过风暴区，请知悉";
                            String title = "外部项目当量预算变更提醒";
                            sendMessage(Long.valueOf(businessKey), title, content);
                        }
                        // 变更成功后的操作
                        changeSuccess(comChangeVO);
                        break;
                    case APPROVING:
                        break;
                }
                changeService.updateWorkFlow(changePayload);
            }
        }
    }


//    /**
//     * 发起外部合同项目当量变更审批流程
//     */
//    private void submitOutEqvaChangeProc(BudgetChangePayload budgetChangePayload) {
//        ComChangeVO comChangeVO = changeService.queryByKey(budgetChangePayload.getId());
//        BudgetPayload budgetPayload = budgetChangePayload.getBudgetPayload();
//        BudgetVO budgetVO = budgetDAO.queryByKey(budgetPayload.getId());
//
//        //参数处理
//        HashMap<String, Object> variables = dealOutEqvaChangeVariable(budgetPayload);
//
//        // P05.项目预算变更流程-项目名称
//        String procInstName = "P05.外部项目当量预算变更流程" + "-" + budgetPayload.getSourceName();
//
//        //发起流程审批
//        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
//                PmsProcDefKey.PMS_BGCHANGE_OUT_EQV.name(),
//                procInstName,
//                budgetChangePayload.getId() + "",
//                variables)
//        );
//        //流程启动成功后，回写业务表数据
//        ComChangePayload changePayload = new ComChangePayload();
//        changePayload.setId(budgetChangePayload.getId());
//        changePayload.setApprProcInstId(processInfo.getProcInstId());
//        changePayload.setApprStatus(ProcInstStatus.APPROVING.name());
//
//        if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
//            changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
//        } else if (ProcInstStatus.APPROVED.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
//            changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
//
//            // 变更成功后的操作
//            changeSuccess(comChangeVO);
//        }
//        budgetPayload.setVersionNo(comChangeVO.getVersionNo());
//        changePayload.setChangeContent(JSONObject.toJSONString(budgetPayload));
//        changePayload.setExtString1(budgetChangePayload.getExtString1());
//        changePayload.setExtString2(budgetChangePayload.getExtString2());
//        changePayload.setExtString3(budgetChangePayload.getExtString3());
//        changePayload.setExtString4(procInstName);
//        changeService.updateWorkFlow(changePayload);
//
//        if (budgetVO.getSourceType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
//            //合同项目发起变更同时取消项目预算需变更代办提示
//            pmsProjectService.updateBudgetAfterUpdateProject(budgetVO.getSourceId());
//        }
//    }

//    //处理当量变更的流程参数
//    private HashMap<String, Object> dealOutEqvaChangeVariable(BudgetPayload budgetPayload) {
//        HashMap<String, Object> variables = new HashMap<>();
//        if (budgetPayload.getContractId() == null) {
//            throw TwException.error("", "合同id不能为空");
//        }
//        /**
//         * 执行区 : [0,min(EEQ',CEQ)]
//         * 风暴区 : (min(EEQ',CEQ),max(EEQ',CEQ)]
//         * 雷暴区 : (max(EEQ',CEQ),+∞]
//         *
//         * */
//        //查询合同预算获取
//        SaleConExecConditionVO saleConExecConditionVO = saleConExecConditionService.queryByContractId(budgetPayload.getContractId());
//        if (saleConExecConditionVO.getProjExecEquiv() == null) {
//            throw TwException.error("", "项目执行当量(EEQ)为空，无法提交");
//        }
//        if (saleConExecConditionVO.getEconomicEquiv() == null) {
//            throw TwException.error("", "最经济支付当量(EEQ')为空，无法提交");
//        }
//        if (saleConExecConditionVO.getCalcCheckProjEquiv() == null) {
//            throw TwException.error("", "项目计算核定当量(CEQ')为空，无法提交");
//        }
//        // 最经济支付当量 （EEQ'）
//        BigDecimal economicEquiv = saleConExecConditionVO.getEconomicEquiv();
//        // 项目计算核定当量 (CEQ)
//        BigDecimal calcCheckProjEquiv = saleConExecConditionVO.getCalcCheckProjEquiv();
//        // 变更后的规划当量数
//        BigDecimal planEqva = budgetPayload.getPlanEqva() == null ? BigDecimal.ZERO : budgetPayload.getPlanEqva();
//        // EEQ' CEQ 取小值
//        BigDecimal minEeqCeq = economicEquiv.min(calcCheckProjEquiv);
//        //EEQ' CEQ 取大值
//        BigDecimal maxEeqCeq = economicEquiv.max(calcCheckProjEquiv);
//        // 超过风暴区百分之五
//        BigDecimal upPercentOne = BigDecimal.ZERO;
//        // 超过风暴区百分之十
//        BigDecimal upPercentTwo = BigDecimal.ZERO;
//
//        Boolean executeAreaFlag = false;
//        Boolean stormAreaFlag = false;
//        Boolean thunderstormFlag = false;
//        Boolean upThunderAreaOneFlag = false;
//        Boolean upThunderAreaTwoFlag = false;
//        Boolean upThunderAreaThreeFlag = false;
//
//        PmsProjectVO pmsProjectVO = pmsProjectService.queryByKey(budgetPayload.getSourceId());
//        //项目经理id
//        Long pmResId = pmsProjectVO.getPmResId();
//        // 交付负责人id
//        Long deliUserId = pmsProjectVO.getDeliUserId();
//        List<Long> list = Arrays.asList(pmResId, deliUserId);
//        Long userId = GlobalUtil.getLoginUserId();
//        // 判断变更后的金额处于哪个区域
//        // 执行区
//        if (planEqva.compareTo(minEeqCeq) <= 0) {
//            executeAreaFlag = true;
//            if (CollectionUtils.isEmpty(list) || !list.contains(userId)) {
//                throw TwException.error("", "变更后当量属于执行区，仅项目经理，交付负责人可以发起变更");
//            }
//        }
//        // 风暴区
//        if (planEqva.compareTo(minEeqCeq) > 0 && planEqva.compareTo(maxEeqCeq) <= 0) {
//            stormAreaFlag = true;
//            if (CollectionUtils.isEmpty(list) || !list.contains(userId)) {
//                throw TwException.error("", "变更后当量属于风暴区，仅项目经理，交付负责人可以发起变更");
//            }
//        }
//        // 雷暴区
//        if (planEqva.compareTo(maxEeqCeq) > 0) {
//            thunderstormFlag = true;
//            BigDecimal upPercent = planEqva.subtract(maxEeqCeq).multiply(BigDecimal.valueOf(100)).divide(maxEeqCeq, 2, RoundingMode.HALF_UP);
//            PrdSystemSelectionVO systemSelection = cacheUtil.getSystemSelection(FunctionSelectionEnum.PMS_BUDGET_CHANGE_EQVA_UP_PERCENT.getCode());
//
//            List<PrdSystemSelectionVO> children = systemSelection.getChildren();
//            if (CollectionUtils.isEmpty(children)) {
//                throw TwException.error("", "超出风暴区比例系统启动项不存在，请配置");
//            }
//            for (PrdSystemSelectionVO p : children) {
//                if (BudgetChangePercentSelectKeyEnum.UP_PERCENT_ONE.getCode().equals(p.getSelectionKey())) {
//                    upPercentOne = new BigDecimal(p.getSelectionValue());
//                }
//                if (BudgetChangePercentSelectKeyEnum.UP_PERCENT_TWO.getCode().equals(p.getSelectionKey())) {
//                    upPercentTwo = new BigDecimal(p.getSelectionValue());
//                }
//            }
//            if (deliUserId == null) {
//                throw TwException.error("", "项目缺少交付负责人，请维护");
//            }
//
//            if (!deliUserId.equals(userId)) {
//                throw TwException.error("", "变更后当量超出风暴区，仅交付负责人可以发起变更");
//            }
//            // 超出风暴区0-5%
//            if (upPercent.compareTo(upPercentOne) <= 0) {
//                upThunderAreaOneFlag = true;
//
//            }
//            // 超出风暴区5%
//            if (upPercent.compareTo(upPercentOne) > 0) {
//                upThunderAreaTwoFlag = true;
//            }
//            // 超过10%
//            if (upPercent.compareTo(upPercentTwo) > 0) {
//                upThunderAreaThreeFlag = true;
//            }
//        }
//        // 流程条件判断
//        variables.put("executeAreaFlag", executeAreaFlag);
//        variables.put("stormAreaFlag", stormAreaFlag);
//        variables.put("thunderstormFlag", thunderstormFlag);// 雷暴区
//        variables.put("upThunderAreaOneFlag", upThunderAreaOneFlag);
//        variables.put("upThunderAreaTwoFlag", upThunderAreaTwoFlag);//超出5%没有上限
//        variables.put("upThunderAreaThreeFlag", upThunderAreaThreeFlag);
//        //审批人
//        // 交付负责人审批
//        variables.put("Activity_0q2o3gl", budgetPayload.getDeliUserId());
//        variables.put("Activity_13mizai", budgetPayload.getDeliUserId());
//
//        //是否是T&M、运维项目项目
//        variables.put("TMFlag", false);
//        if (StringUtils.hasText(pmsProjectVO.getWorkType()) && (SaleConWorkTypeEnum.TM.getCode().equals(pmsProjectVO.getWorkType()))) {
//            variables.put("TMFlag", true);
//        }
//        //交付事业部leader
//        Long deliBuId = budgetPayload.getDeliBuId();
//        //由交付bu leader改为交付bu事业部leader #17599
//        PrdOrgOrganizationRefVO org = cacheUtil.getBULevel1ByOrgId(deliBuId);
//        variables.put("Activity_0ihafu5", org.getManageId());
//        variables.put("Activity_0mt4eyh", org.getManageId());
//        variables.put("Activity_1p3i983", org.getManageId());
//        // 事业部PMO审批
//        PrdOrgRoleVO pmoUsersRole = organizationService.queryRoleByOrgIdAndRoleCode(org.getOrgId(), WorkFlowRoleCodeEnum.ORG_PMO.getCode());
//        if (!ObjectUtils.isEmpty(pmoUsersRole)) {
//            String[] pmoUsers = pmoUsersRole.getRoleEmployees().split(",");
//            variables.put("Activity_1sz8obj", Arrays.asList(pmoUsers));
//            variables.put("Activity_0yf5ucf", Arrays.asList(pmoUsers));
//            variables.put("Activity_05saggb", Arrays.asList(pmoUsers));
//        }
//        // 平台PMO审批
//        List<Long> planPmolist = roleService.queryUserIdByRoleCode(RoleEnum.PLAT_PMO.getCode());
//        variables.put("Activity_0ndl43y", planPmolist);
//        variables.put("Activity_1culj8c", planPmolist);
//        // CFO审批
//        variables.put("Activity_025ua9f", roleService.queryUserIdByRoleCode(RoleEnum.PLAT_CFO.getCode()));
//
//
//        return variables;
//    }

    @Override
    public String queryBudgetRiskLevel(Long sourceId, String sourceType, Long contractId) {
        BudgetVO budgetVO = budgetCommonService.querySimpleBySource(sourceId, sourceType);

        SaleConExecConditionVO saleConExecConditionVO = saleConExecConditionService.queryByContractId(contractId);
        // 最经济支付当量 （EEQ'）
        BigDecimal economicEquiv = saleConExecConditionVO.getEconomicEquiv() == null ? BigDecimal.ZERO : saleConExecConditionVO.getEconomicEquiv();
        // 项目计算核定当量 (CEQ)
        BigDecimal calcCheckProjEquiv = saleConExecConditionVO.getCalcCheckProjEquiv() == null ? BigDecimal.ZERO : saleConExecConditionVO.getCalcCheckProjEquiv();
        // 变更后的规划当量数
        BigDecimal planEqva = budgetVO.getPlanEqva() == null ? BigDecimal.ZERO : budgetVO.getPlanEqva();
        // EEQ' CEQ 取小值
        BigDecimal minEeqCeq = economicEquiv.min(calcCheckProjEquiv);
        //EEQ' CEQ 取大值
        BigDecimal maxEeqCeq = economicEquiv.max(calcCheckProjEquiv);

        String riskLevel = "";

        if (planEqva.compareTo(minEeqCeq) <= 0) {
            // 执行区
            riskLevel = BudgetRiskLevel.LEVEL1.getCode();
        }
        if (planEqva.compareTo(minEeqCeq) > 0 && planEqva.compareTo(maxEeqCeq) <= 0) {
            // 风暴区
            riskLevel = BudgetRiskLevel.LEVEL2.getCode();
        }
        if (planEqva.compareTo(maxEeqCeq) > 0) {
            // 雷暴区
            riskLevel = BudgetRiskLevel.LEVEL3.getCode();
        }
        return riskLevel;
    }

    @Override
    public void updateByKeyDynamic(BudgetPayload payload) {
        budgetDAO.updateByKeyDynamic(payload);
    }
//
//    /**
//     * 发起外部项目金额变更审批流程
//     */
//    private void submitOutAmtChangeProc(BudgetChangePayload budgetChangePayload) {
//        ComChangeVO comChangeVO = changeService.queryByKey(budgetChangePayload.getId());
//
//        BudgetPayload budgetPayload = budgetChangePayload.getBudgetPayload();
//        BudgetVO budgetVO = budgetDAO.queryByKey(budgetPayload.getId());
//        HashMap<String, Object> variables = dealOutAmtChangeVariable(budgetPayload);
//        // P05.项目预算变更流程-项目名称
//        String procInstName = "P05.外部项目金额预算变更流程" + "-" + budgetPayload.getSourceName();
//
//        //发起流程审批
//        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
//                PmsProcDefKey.PMS_BGCHANGE_OUT_AMT.name(),
//                procInstName,
//                budgetChangePayload.getId() + "",
//                variables)
//        );
//        //流程启动成功后，回写业务表数据
//        ComChangePayload changePayload = new ComChangePayload();
//        changePayload.setId(budgetChangePayload.getId());
//        changePayload.setApprProcInstId(processInfo.getProcInstId());
//        changePayload.setApprStatus(ProcInstStatus.APPROVING.name());
//
//        if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
//            changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
//        } else if (ProcInstStatus.APPROVED.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
//            changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
//
//            // 变更成功后的操作
//            changeSuccess(comChangeVO);
//        }
//        budgetPayload.setVersionNo(comChangeVO.getVersionNo());
//        changePayload.setChangeContent(JSONObject.toJSONString(budgetPayload));
//        changePayload.setExtString1(budgetChangePayload.getExtString1());
//        changePayload.setExtString2(budgetChangePayload.getExtString2());
//        changePayload.setExtString3(budgetChangePayload.getExtString3());
//        changePayload.setExtString4(procInstName);
//        changeService.updateWorkFlow(changePayload);
//
//        if (budgetVO.getSourceType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
//            //合同项目发起变更同时取消项目预算需变更代办提示
//            pmsProjectService.updateBudgetAfterUpdateProject(budgetVO.getSourceId());
//        }
//
//    }
//
//    // 处理金额预算变更参数
//    private HashMap<String, Object> dealOutAmtChangeVariable(BudgetPayload budgetPayload) {
//        HashMap<String, Object> variables = new HashMap<>();
//        Boolean upTenPercentFlag = false;
//
//        BigDecimal planAmt = budgetPayload.getPlanAmt() == null ? BigDecimal.ZERO : budgetPayload.getPlanAmt();
//        BigDecimal originalPlanAmt = budgetPayload.getOriginalPlanAmt() == null ? BigDecimal.ZERO : budgetPayload.getOriginalPlanAmt();
//        PrdSystemSelectionVO systemSelection = cacheUtil.getSystemSelection(FunctionSelectionEnum.PMS_BUDGET_CHANGE_AMT_UP_PERCENT.getCode());
//        List<PrdSystemSelectionVO> children = systemSelection.getChildren();
//        if (CollectionUtils.isEmpty(children)) {
//            throw TwException.error("", "外部项目金额预算变更超出比例系统选择项不存在，请配置");
//        }
//
//        // 如果变更后是0那么直接就是false
//        if (planAmt.compareTo(BigDecimal.ZERO) != 0) {
//            // 如果变更前的金额是0 那么直接就是true 否则就计算比例
//            if (originalPlanAmt.compareTo(BigDecimal.ZERO) != 0) {
//                BigDecimal divide = planAmt.subtract(originalPlanAmt).multiply(BigDecimal.valueOf(100)).divide(originalPlanAmt, 2, RoundingMode.HALF_UP);
//                if (divide.compareTo(new BigDecimal(children.get(0).getSelectionValue())) > 0) {
//                    upTenPercentFlag = true;
//                }
//            } else {
//                upTenPercentFlag = true;
//            }
//        }
//        //交付bu leader
//        Long deliBuId = budgetPayload.getDeliBuId();
//        PrdOrgOrganizationVO org = cacheUtil.getOrg(deliBuId);
//        variables.put("Activity_1akhvui", org.getManageId());
//        //超出比例是否大于百分之十
//        variables.put("upTenPercentFlag", upTenPercentFlag);
//        //平台财务负责人
//        variables.put("Activity_145h7j6", roleService.queryUserIdByRoleCode(RoleEnum.PLAT_FIN_PIC.getCode()));
//        return variables;
//    }
//
//

    /**
     * 变更成功后的操作
     *
     * @param comChangeVO
     */
    @Override
    public void changeSuccess(ComChangeVO comChangeVO) {
        // 保存预算基本信息 、 科目信息 、活动信息
        BudgetPayload budgetPayload = JSON.parseObject(comChangeVO.getChangeContent(), BudgetPayload.class);
        budgetPayload.setVersionNo(comChangeVO.getVersionNo());
        budgetPayload.setProcInstId(null);
        saveData(budgetPayload);

        //	Sprint5_TW5.0_(2024/03/18~2024/03/30) #16003 项目详情中的总预算信息与项目预算的关联关系去掉
        // 如果变更后的费用超过项目预计总费用、项目预计总当量，项目详情页这两个字段的数据更新为最新的预算总费用，当量预算总数
//        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(budgetPayload.getSourceType())) {
//            PmsProjectPayload pmsProjectPayload = new PmsProjectPayload();
//            pmsProjectPayload.setId(budgetPayload.getSourceId());
//            pmsProjectPayload.setTotalReimbursement(budgetPayload.getTotalAmt());
//            pmsProjectPayload.setTotalEqva(budgetPayload.getPlanEqva());
//            pmsProjectService.updateByKeyDynamic(pmsProjectPayload);
//        }

        //预算相关流程审批完成后，涉及到知会财务相关人员
        // budgetCommonService.messNotice(budgetPayload.getId(), comChangeVO.getExtString4());
    }


    /**
     * 计算科目当前版本规划金额
     *
     * @param budgetPayload
     * @param subjectInfo
     */
    private void countSubject(BudgetPayload budgetPayload, Map<String, BudgetSubjectDetailPayload> subjectInfo) {
        int version = budgetPayload.getVersionNo();
        List<BudgetSubjectDetailPayload> subjectDetailPayloads = budgetPayload.getSubjectDetailPayloads();
        if (!ObjectUtils.isEmpty(subjectDetailPayloads)) {
            for (BudgetSubjectDetailPayload payload : subjectDetailPayloads) {
//                subjectInfo.put(payload.getId() + "_" + version, payload.getBudgetAmt() == null ? BigDecimal.ZERO : payload.getBudgetAmt());
                subjectInfo.put(payload.getId() + "_" + version, payload);


            }
        }
    }

    /**
     * 计算活动当前版本规划当量
     *
     * @param budgetPayload
     * @param activityInfo
     */
    private void countActivity(BudgetPayload budgetPayload, Map<String, BigDecimal> activityInfo) {
        int version = budgetPayload.getVersionNo();
        List<PmsProjectActivityPayload> activityPayloads = budgetPayload.getActivityPayloads();
        if (!ObjectUtils.isEmpty(activityPayloads)) {
            for (PmsProjectActivityPayload payload : activityPayloads) {
                activityInfo.put(payload.getId() + "_" + version, payload.getPlanEqva() == null ? BigDecimal.ZERO : payload.getPlanEqva());
            }
        }
    }


    private Set<Long> addBudgetItemParent(Set<Long> missBudgetItemIds, Map<Long, AccBudgetItemVO> budgetItemMap, Map<Long, BudgetSubjectDetailVO> budgetDetailItemMap) {
        Set<Long> newMissBudgetItemIds = new HashSet<>(missBudgetItemIds);
        for (Long key : missBudgetItemIds) {
            addParent(budgetItemMap, key, newMissBudgetItemIds, budgetDetailItemMap);
        }
        return newMissBudgetItemIds;
    }

    private void addParent(Map<Long, AccBudgetItemVO> budgetItemMap, Long key, Set<Long> newMissBudgetItemIds, Map<Long, BudgetSubjectDetailVO> budgetDetailItemMap) {
        Long parentId = budgetItemMap.get(key).getParentId();
        if (parentId == null) {
            return;
        }
        // 判断父级有了就不再添加了
        if (budgetDetailItemMap.get(parentId) == null) {
            newMissBudgetItemIds.add(parentId);
        }
        addParent(budgetItemMap, parentId, newMissBudgetItemIds, budgetDetailItemMap);
    }

    public void sendMessage(Long objectId, String messageTitle, String content) {
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(2);
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.systemMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(0);
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(3);
        ado.setMessageContent(content);
        List<Long> list = new ArrayList();
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_CFO.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_PMO.getCode()));
        if (!CollectionUtils.isEmpty(list)) {
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            //保存信息
            messageConfigService.insert(ado);
        }

    }

    @Override
    @Transactional
    public void syncBudgetChangeTmp() {

        String syncType = "budget_change";
        LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        if (localDateTime == null) {
            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            localDateTime = localDateTime.minusSeconds(180);
        }
        ComChangeQuery query = new ComChangeQuery();
        query.setChangeType("BUDGET_CHANGE_APPLY");
        query.setModifyTimeStart(localDateTime);
        List<ComChangeVO> budgetChangeList = changeService.changeSearch(query);
        for (ComChangeVO comChangeVO : budgetChangeList) {
            BudgetChangeVO budgetChangeVO = queryBudgetChangeByKey(comChangeVO.getId());
            BudgetVO budgetVO = budgetChangeVO.getBudgetVO();
            List<PmsProjectActivityVO> activityVOS = budgetVO.getActivityVOS();
            BigDecimal deltaEqva = activityVOS.stream()
                    .map(PmsProjectActivityVO::getDeltaValue)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            List<BudgetSubjectDetailVO> subjectDetailVOS = budgetVO.getSubjectDetailVOS();
            BigDecimal deltaAmt = subjectDetailVOS.stream()
                    .map(BudgetSubjectDetailVO::getDeltaValue)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            BudgetChangeTmpDO budgetChangeTmpSave = new BudgetChangeTmpDO();
            budgetChangeTmpSave.setBudgetId(budgetVO.getId());
            budgetChangeTmpSave.setDeleteEqva(deltaEqva);
            budgetChangeTmpSave.setDeleteAmt(deltaAmt);
            budgetChangeTmpSave.setProjectId(budgetVO.getSourceId());
            budgetChangeTmpSave.setApplyTime(comChangeVO.getCreateTime());
            budgetChangeTmpRepo.save(budgetChangeTmpSave);
        }
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        daoLog.save(logDO);
    }


}
