package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityCompetitorPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityCompetitorService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityCompetitorVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 商机竞争对手管理
 *
 * @author carl.wang
 * @date
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
// @PermissionDomain(domain = PermissionDomainEnum.COMPETITOR)
@Slf4j
public class CrmOpportunityCompetitorController {
    private final CrmOpportunityCompetitorService service;
    private final CrmOpportunityService opportunityService;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/oppo/competitor/insert")
    public TwOutputUtil insert(CrmOpportunityCompetitorPayload payload) {
        CrmOpportunityCompetitorVO vo = service.insert(payload);
        opportunityService.checkIntegrity(payload.getOppoId());
        return TwOutputUtil.ok(vo);
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/oppo/competitor/update")
    public TwOutputUtil update(CrmOpportunityCompetitorPayload payload) {
        service.update(payload);
        opportunityService.checkIntegrity(payload.getOppoId());
        return TwOutputUtil.ok();
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/oppo/competitor/updateFromV4")
    public TwOutputUtil updateFromV4(CrmOpportunityCompetitorPayload payload) {
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 列表查询
     *
     * @param oppoId 商机id
     * @return result
     */
    @GetMapping("/oppo/competitor/queryList")
//    @PermissionFunction(functions = {
//            @FunctionDetail(functionCode = FunctionCodeEnum.COMPETITOR_PAGE, type = FunctionTypeEnum.TAB, referDomain = {PermissionDomainEnum.BUSINESS_OPPORTUNITY})
//    })
    public TwOutputUtil queryList(Long oppoId) {
        return TwOutputUtil.ok(service.queryList(oppoId));
    }

    /**
     * 删除
     *
     * @param oppoId 商机id
     * @param keys   主键id
     * @return result
     */
    @DeleteMapping("/oppo/competitor/deleteSoft")
    public TwOutputUtil deleteSoft(Long oppoId, Long[] keys) {
        service.deleteSoft(oppoId, Arrays.asList(keys));
        opportunityService.checkIntegrity(oppoId);
        return TwOutputUtil.ok();
    }
}
