package com.elitesland.tw.tw5.server.prd.humanresources.ability.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdLevelConfigDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdLevelConfigDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdLevelConfigDtlVO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.PrdLevelConfigDtlDO;

import com.elitesland.tw.tw5.server.prd.humanresources.ability.repo.PrdLevelConfigDtlRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.dao.PrdLevelConfigDtlDao;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdLevelConfigDtlService;

import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdLevelConfigDtlConvert;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.elitescloud.boot.exception.BusinessException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;
import org.apache.commons.lang3.StringUtils;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-18
 * @desc : 级别维护明细表Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdLevelConfigDtlServiceImpl implements PrdLevelConfigDtlService {


    private final PrdLevelConfigDtlDao prdLevelConfigDtlDao;

    private final PrdLevelConfigDtlRepo prdLevelConfigDtlRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdLevelConfigDtlVO save(PrdLevelConfigDtlPayload prdLevelConfigDtlPayload) {

        checkData(prdLevelConfigDtlPayload);
        PrdLevelConfigDtlDO prdLevelConfigDtlDO = new PrdLevelConfigDtlDO();
        prdLevelConfigDtlDO = PrdLevelConfigDtlConvert.INSTANCE.p2d(prdLevelConfigDtlPayload);
        PrdLevelConfigDtlDO res = prdLevelConfigDtlRepo.save(prdLevelConfigDtlDO);
        return PrdLevelConfigDtlConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdLevelConfigDtlVO update(PrdLevelConfigDtlPayload prdLevelConfigDtlPayload) {

        Assert.notNull(prdLevelConfigDtlPayload.getId(), "id is null");
        PrdLevelConfigDtlVO res = save(prdLevelConfigDtlPayload);
        return res;

    }


    @Override
    public PrdLevelConfigDtlVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdLevelConfigDtlVO res = prdLevelConfigDtlDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PrdLevelConfigDtlVO> page(PrdLevelConfigDtlQuery prdLevelConfigDtlQuery) {

        PagingVO<PrdLevelConfigDtlVO> res = prdLevelConfigDtlDao.page(prdLevelConfigDtlQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdLevelConfigDtlDao.del(ids);
        return res;

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long delByMasId(Long id) {

        Long res = prdLevelConfigDtlDao.delByMasId(id);
        return res;
    }


    /**
     * 数据校验
     *
     * @param prdLevelConfigDtlPayload
     */
    private void checkData(PrdLevelConfigDtlPayload prdLevelConfigDtlPayload) {

        if (StringUtils.isBlank(prdLevelConfigDtlPayload.getName())) {
            throw new BusinessException("明细名称不能为空");
        }
        if (StringUtils.isBlank(prdLevelConfigDtlPayload.getDocNo())) {
            throw new BusinessException("明细名称编号不能为空");
        }

    }


}

