package com.elitesland.tw.tw5.server.prd.inv.service;


import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceVerDetailPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceVerDetailQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceVerDetailService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVerDetailVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.BillVerDetailPayload;
import com.elitesland.tw.tw5.api.prd.purchase.service.BillVerDetailService;
import com.elitesland.tw.tw5.api.prd.purchase.service.CostUndertakeDepartmentService;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.inv.convert.InvInvoiceVerDetailConvert;
import com.elitesland.tw.tw5.server.prd.inv.dao.InvInvoiceVerDetailDAO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvInvoiceVerDetailDO;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvInvoiceVerDetailRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 发票核销明细表
 *
 * @author zoey
 * @date 2023-12-05
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class InvInvoiceVerDetailServiceImpl extends BaseServiceImpl implements InvInvoiceVerDetailService {

    private final InvInvoiceVerDetailRepo invInvoiceVerDetailRepo;
    private final InvInvoiceVerDetailDAO invInvoiceVerDetailDAO;
    private final FileUtil fileUtil;
    @Autowired
    @Lazy
    private InvInvoiceService invInvoiceService;

    @Autowired
    @Lazy
    private CostUndertakeDepartmentService costUndertakeDepartmentService;

    @Autowired
    @Lazy
    private BillVerDetailService billVerDetailService;

    @Override
    public PagingVO<InvInvoiceVerDetailVO> queryPaging(InvInvoiceVerDetailQuery query) {
        return invInvoiceVerDetailDAO.queryPaging(query);
    }

    @Override
    public List<InvInvoiceVerDetailVO> queryListDynamic(InvInvoiceVerDetailQuery query) {
        return invInvoiceVerDetailDAO.queryListDynamic(query);
    }

    @Override
    public InvInvoiceVerDetailVO queryByKey(Long key) {
        InvInvoiceVerDetailDO entity = invInvoiceVerDetailRepo.findById(key).orElseGet(InvInvoiceVerDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        InvInvoiceVerDetailVO vo = InvInvoiceVerDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public InvInvoiceVerDetailVO insert(InvInvoiceVerDetailPayload payload) {
        InvInvoiceVerDetailDO entityDo = InvInvoiceVerDetailConvert.INSTANCE.toDo(payload);
        return InvInvoiceVerDetailConvert.INSTANCE.toVo(invInvoiceVerDetailRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public InvInvoiceVerDetailVO update(InvInvoiceVerDetailPayload payload) {
        InvInvoiceVerDetailDO entity = invInvoiceVerDetailRepo.findById(payload.getId()).orElseGet(InvInvoiceVerDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        InvInvoiceVerDetailDO entityDo = InvInvoiceVerDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return InvInvoiceVerDetailConvert.INSTANCE.toVo(invInvoiceVerDetailRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(InvInvoiceVerDetailPayload payload) {
        InvInvoiceVerDetailDO entity = invInvoiceVerDetailRepo.findById(payload.getId()).orElseGet(InvInvoiceVerDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = invInvoiceVerDetailDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            invInvoiceVerDetailDAO.deleteSoft(keys);
        }
    }

    @Override
    public void insertAll(List<InvInvoiceVerDetailPayload> invInvoiceVerDetailPayloads) {
        invInvoiceVerDetailRepo.saveAll(InvInvoiceVerDetailConvert.INSTANCE.toDoList(invInvoiceVerDetailPayloads));
    }

    @Override
    public void deleteByPaymentApplyId(Long paymentApplyId) {
        invInvoiceVerDetailDAO.deleteByPaymentApplyId(paymentApplyId);
    }

    @Override
    public List<InvInvoiceVerDetailVO> queryListByPaymentApplyId(String docType, Long paymentApplyId) {
        return invInvoiceVerDetailDAO.queryListByPaymentApplyId(docType, paymentApplyId);
    }

    @Override
    public List<InvInvoiceVerDetailVO> queryListByJdePaymentApplyId(String docType, Long paymentApplyId) {
        return invInvoiceVerDetailDAO.queryListByJdePaymentApplyId(docType, paymentApplyId);
    }
}
