package com.elitesland.tw.tw5.server.prd.my.entity;


import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Entity
@Table(name = "reward_leave_apply", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "reward_leave_apply", comment = "奖励假申请表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class RewardLeaveApplyDO extends BaseModel {

    @Comment("事由类型")
    @Column()
    private String reasonType;

    @Comment("事由号")
    @Column()
    private Long reasonId;

    @Comment("事由名称")
    @Column()
    private String reasonName;

    @Comment("预计开始日期")
    @Column()
    private LocalDate planStartDate;

    @Comment("预计结束日期")
    @Column()
    private LocalDate planEndDate;

    @Comment("预计上线日期")
    @Column()
    private LocalDate planOnlineDate;

    @Comment("预算总人天")
    @Column()
    private BigDecimal totalDays;

    @Comment("原始规划当量")
    @Column()
    private BigDecimal originalPlanEqva;

    @Comment("变更当量")
    @Column()
    private BigDecimal planEqvaChange;

    @Comment("累计投入当量占比")
    @Column()
    private BigDecimal totalEqvaProportion;

    @Comment("报告完工百分比")
    @Column()
    private BigDecimal reprotCompPercent;

    @Comment("项目风险等级")
    @Column()
    private String riskLevel;

    @Comment("有效期")
    @Column()
    private LocalDate expirationDate;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    public void copy(RewardLeaveApplyDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
