package com.elitesland.tw.tw5.server.prd.my.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDate;

/**
 * @author sunxw
 * @description 假期表
 * @Date 2023/5/8
 */
@Entity
@Table(name = "t_vacation", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_vacation", comment = "假期表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class VacationDO extends BaseModel {

    /**
     * 请假单号
     */
    @Comment("日期")
    @Column()
    private LocalDate naturalDate;

    /**
     * 工作小时数
     */
    @Comment("工作小时数")
    @Column()
    private Float workHours;

    /**
     * JDE是否导出工时
     */
    @Comment("JDE是否导出工时")
    @Column()
    private Byte jdeExportFlag;

}
