package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceRemarkPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceRemarkQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceRemarkService;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceRemarkVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceRemarkConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceRemarkDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceRemarkDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceRemarkRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.*;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class TAttendanceRemarkServiceImpl extends BaseServiceImpl implements TAttendanceRemarkService {

    private final TAttendanceRemarkRepo tAttendanceRemarkRepo;
    private final TAttendanceRemarkDAO tAttendanceRemarkDAO;
    private final PrdOrgSyncLogDAO daoLog;
    private final HttpUtil httpUtil;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService orgService;

    @Value("${tw4.attendance.remark}")
    private String attendanceRemarkTo5Url;

    @Override
    public PagingVO<TAttendanceRemarkVO> queryPaging(TAttendanceRemarkQuery query) {
        return tAttendanceRemarkDAO.queryPaging(query);
    }

    @Override
    public List<TAttendanceRemarkVO> queryListDynamic(TAttendanceRemarkQuery query) {
        return tAttendanceRemarkDAO.queryListDynamic(query);
    }

    @Override
    public TAttendanceRemarkVO queryByKey(Long key) {
        TAttendanceRemarkDO entity = tAttendanceRemarkRepo.findById(key).orElseGet(TAttendanceRemarkDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TAttendanceRemarkVO vo = TAttendanceRemarkConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TAttendanceRemarkVO insert(TAttendanceRemarkPayload payload) {
        TAttendanceRemarkDO entityDo = TAttendanceRemarkConvert.INSTANCE.toDo(payload);
        return TAttendanceRemarkConvert.INSTANCE.toVo(tAttendanceRemarkRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TAttendanceRemarkVO update(TAttendanceRemarkPayload payload) {
        TAttendanceRemarkDO entity = tAttendanceRemarkRepo.findById(payload.getId()).orElseGet(TAttendanceRemarkDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TAttendanceRemarkDO entityDo = TAttendanceRemarkConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TAttendanceRemarkConvert.INSTANCE.toVo(tAttendanceRemarkRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TAttendanceRemarkPayload payload) {
        TAttendanceRemarkDO entity = tAttendanceRemarkRepo.findById(payload.getId()).orElseGet(TAttendanceRemarkDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tAttendanceRemarkDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tAttendanceRemarkDAO.deleteSoft(keys);
        }
    }

    @Override
    public Long queryByAttendanceNormalId(Long attendanceNormalId) {
        return tAttendanceRemarkDAO.queryByAttendanceNormalId(attendanceNormalId);
    }

    @Override
    public void attendanceRemarkTo5(String param) {
        String syncType = "attendanceRemarkTo5";
        LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        if (localDateTime == null) {
            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            localDateTime = localDateTime.minusSeconds(10);
        }
        XxlJobLogger.log("syncVacationApply localDateTime：" + localDateTime);
        //TODO参数内容待确定
        //同步到5.0
        Map<String, Long> reqMap = new HashMap<>();
        final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        reqMap.put("asyncTime", asyncTimeLong);
        //同步到5.0
        XxlJobLogger.log("syncVacationApplyDetail syncTime：" + asyncTimeLong);
        String result = httpUtil.sendSyncGet(attendanceRemarkTo5Url, reqMap);
        Map<String, Object> data = (Map) JSONObject.parse(result);
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if (("true".equals(data.get("ok") + ""))) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                final Object datum = data.get("datum");
                List<Map<String, Object>> attendanceRemarkData = (List<Map<String, Object>>) datum;
                //用户请假申请数据构建
                List<TAttendanceRemarkDO> tAttendanceRemarkDOList = new ArrayList<>();
                //查询5.0已有的数据，对新旧数据进行对比，如有变动，进行更新操作
                List<Long> tw4AttendanceRemarkIds = attendanceRemarkData.stream()
                        .map(attendanceRemark -> ((Integer) (attendanceRemark.get("id") == null ? 0 : attendanceRemark.get("id"))).longValue())
                        .collect(Collectors.toList());
                //根据4.0id获取表中旧值，决定进行插入或更新
                List<TAttendanceRemarkDO> oldTAttendanceRemarkDOs = tAttendanceRemarkRepo.selectByIdV4List(tw4AttendanceRemarkIds);
                //idV4相等的进行更新操作
                for (TAttendanceRemarkDO attendanceRemarkDO : oldTAttendanceRemarkDOs) {
                    Long attendanceRemarkIdV4 = attendanceRemarkDO.getAttendanceRemarkIdV4();
                    for (Map applyData : attendanceRemarkData) {
                        Long attendanceRemarkIdV4FromV4 = ((Integer) ((null == applyData.get("id") ? 0 : applyData.get("id")))).longValue();
                        if (attendanceRemarkIdV4.equals(attendanceRemarkIdV4FromV4)) {
                            //有则更新表中记录,并跳出内层循环
                            TAttendanceRemarkDO attendanceRemarkDO1 = this.translateFromV4(applyData, v4AndV5UserIds);
                            attendanceRemarkDO1.setId(attendanceRemarkDO.getId());
                            tAttendanceRemarkDOList.add(attendanceRemarkDO1);
                            break;
                        }
                    }
                }
                tAttendanceRemarkRepo.saveAll(tAttendanceRemarkDOList);

                //筛选出不存在的，直接插入
                List<Map<String, Object>> newDatas = attendanceRemarkData.stream().filter(applyData -> {
                    boolean flag = true;
                    Long applyId = ((Integer) (applyData.get("id") == null ? 0 : applyData.get("id"))).longValue();
                    for (TAttendanceRemarkDO attendanceRemarkDO : oldTAttendanceRemarkDOs) {
                        if (attendanceRemarkDO.getAttendanceRemarkIdV4().equals(applyId)) {
                            flag = false;
                        }
                    }
                    return flag;
                }).collect(Collectors.toList());
                List<TAttendanceRemarkDO> newTAttendanceRemarkDOs = new ArrayList<>();
                //插入新数据
                for (Map<String, Object> newData : newDatas) {
                    TAttendanceRemarkDO attendanceRemarkDO1 = this.translateFromV4(newData, v4AndV5UserIds);
                    newTAttendanceRemarkDOs.add(attendanceRemarkDO1);
                }
                tAttendanceRemarkRepo.saveAll(newTAttendanceRemarkDOs);
                syncData = "更新了正常打卡" + attendanceRemarkData.size() + "条数据";
            } else {
                syncData = "正常打卡数据未变化";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        daoLog.save(logDO);
        log.info("【正常打卡信息同步，同步日志：{}】", logDO);
    }


    /**
     * 翻译
     *
     * @param attendanceRemarkData         v4的数据
     * @param v4AndV5UserIds    v4与v5对应的userId
     * @return
     */
    private TAttendanceRemarkDO translateFromV4(Map attendanceRemarkData, Map<Long, Long> v4AndV5UserIds) {
        TAttendanceRemarkDO attendanceRemarkDO = BeanUtil.mapToBean(TAttendanceRemarkDO.class, attendanceRemarkData, Arrays.asList("id", "createTime", "createUserId"));
        if (null != attendanceRemarkData.get("id")) {
            attendanceRemarkDO.setAttendanceRemarkIdV4(((Integer) attendanceRemarkData.get("id")).longValue());
        }
        if (null != attendanceRemarkData.get("attendanceResId")) {
            Long attendanceResId = ((Integer) attendanceRemarkData.get("attendanceResId")).longValue();
            attendanceRemarkDO.setAttendanceResId(v4AndV5UserIds.get(attendanceResId));
        }
        return attendanceRemarkDO;
    }
}

