package com.elitesland.tw.tw5.server.prd.org.dao;

import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeEqvaRatioQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeEqvaRatioVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeEqvaRatioDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeEqvaRatioDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgEmployeeEqvaRatioRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2023/6/2 - 14:17
 */
@Repository
@RequiredArgsConstructor
public class PrdOrgEmployeeEqvaRatioDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPrdOrgEmployeeEqvaRatioDO qdo = QPrdOrgEmployeeEqvaRatioDO.prdOrgEmployeeEqvaRatioDO;

    private final PrdOrgEmployeeEqvaRatioRepo employeeEqvaRatioRepo;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeEqvaRatioVO> getJpaQuerySelect() {
        JPAQuery<PrdOrgEmployeeEqvaRatioVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeEqvaRatioVO.class,
                qdo.id,
                qdo.eqvaRatio,
                qdo.orgId,
                qdo.userId,
                qdo.startDate,
                qdo.endDate
        )).from(qdo);
        return jpaQuery;
    }

    /**
     * 获取当量系数列表
     *
     * @param userId 用户
     * @param orgId  组织
     * @return 结果
     */
    public List<PrdOrgEmployeeEqvaRatioVO> getEqvaRatioList(Long userId, Long orgId) {
        JPAQuery<PrdOrgEmployeeEqvaRatioVO> jpaQuery = getJpaQuerySelect();
        if (orgId != null) {
            jpaQuery.where(qdo.orgId.eq(orgId));
        }
        jpaQuery.where(qdo.userId.eq(userId));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, null));
        return jpaQuery.fetch();
    }

    public List<PrdOrgEmployeeEqvaRatioVO> getEqvaRatioListByDate(PrdOrgEmployeeEqvaRatioQuery query) {
        JPAQuery<PrdOrgEmployeeEqvaRatioVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.userId.eq(query.getUserId()));
        if (!ObjectUtils.isEmpty(query.getStartDate())) {
            jpaQuery.where(qdo.endDate.gt(query.getStartDate()).or(qdo.endDate.isNull()));
        }
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            jpaQuery.where(qdo.startDate.lt(query.getEndDate()));
        }
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, null));
        return jpaQuery.fetch();
    }

    public void saveGrade(PrdOrgEmployeeEqvaRatioDO employeeEqvaRatioDO) {
        employeeEqvaRatioRepo.save(employeeEqvaRatioDO);
    }

    @Transactional
    public void updateEqvaDate(Long userId, LocalDate date) {
        jpaQueryFactory.update(qdo)
                .set(qdo.endDate, date)
                .where(qdo.userId.eq(userId))
                .where(qdo.endDate.isNull())
                .execute();
    }

}
