package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.BuProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.BuProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * BU项目管理
 *
 * @author carl
 * @date 2023-11-29
 */
@Api(tags = "BU项目管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/bu/buProject")
@Slf4j
public class BuProjectController {

    private final BuProjectService buProjectService;

    /**
     * BU项目管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("BU项目管理-新增")
    public TwOutputUtil<BuProjectVO> insert(@RequestBody BuProjectPayload payload) {
        return TwOutputUtil.ok(buProjectService.insertOrUpdate(payload));
    }
//
//    /**
//     * BU项目管理-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("BU项目管理-更新")
//    public TwOutputUtil<BuProjectVO> update(@RequestBody BuProjectPayload payload) {
//        return TwOutputUtil.ok(buProjectService.update(payload));
//    }
//
//    /**
//     * BU项目管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping("update")
//    @ApiOperation("BU项目管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
//    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BuProjectPayload payload) {
//        return TwOutputUtil.ok(buProjectService.updateByKeyDynamic(payload));
//    }

    /**
     * BU项目管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("BU项目管理-主键查询")
    public TwOutputUtil<BuProjectVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(buProjectService.queryByKey(key));
    }

    /**
     * BU项目管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("BU项目管理-分页")
    public TwOutputUtil<PagingVO<BuProjectVO>> paging(BuProjectQuery query) {
        return TwOutputUtil.ok(buProjectService.queryPaging(query));
    }

    /**
     * BU项目管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("BU项目管理-查询列表")
    public TwOutputUtil<List<BuProjectVO>> queryList(BuProjectQuery query) {
        return TwOutputUtil.ok(buProjectService.queryListDynamic(query));
    }

    @GetMapping("/listByMember")
    @UdcNameClass
    @ApiOperation("我的BU项目列表")
    public TwOutputUtil<List<BuProjectVO>> listByMember(BuProjectQuery query) {
        return TwOutputUtil.ok(buProjectService.queryListDynamic(query));
    }

//    /**
//     * BU项目管理-删除
//     *
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    @ApiOperation("BU项目管理-删除")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//        buProjectService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }

}

