package com.elitesland.tw.tw5.server.prd.product.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 产品成功案例
 *
 * @author likunpeng
 * @date 2023-05-22
 */
@Entity
@Table(name = "prd_product_case", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_product_case", comment = "产品成功案例")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdProductCaseDO extends BaseModel implements Serializable  {
    /** 记录唯一ID */
    @Comment("记录唯一ID")
    @Column()
    private Long prodId;
    /** 案例名称 */
    @Comment("案例名称")
    @Column()
    private String caseName;
    /** 案例描述 */
    @Comment("案例描述")
    @Column()
    private String caseDesc;
    /** 联系信息 */
    @Comment("联系信息")
    @Column()
    private String contactDesc;
    /** 案例图片路径 */
    @Comment("案例图片路径")
    @Column()
    private String casePicPath;

    public void copy(PrdProductCaseDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
