package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;

/**
 * ConInvSettingMonthController
 *
 * @author zoey
 * @date 2024-03-14
 */
@Entity
@Table(name = "con_inv_setting_month", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_inv_setting_month", comment = "ConInvSettingMonthController")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConInvSettingMonthDO extends BaseModel implements Serializable  {
    /** 开票月份 */
    @Comment("开票月份")
    @Column()
    private Integer invMonth;
    /** 开票额度 */
    @Comment("开票额度")
    @Column()
    private BigDecimal invLimit;
    /** 预警值 */
    @Comment("预警值")
    @Column()
    private BigDecimal warnPercent;

    /** 开票配置主表id */
    @Comment("开票配置主表id")
    @Column()
    private Long invSettingId;

    public void copy(ConInvSettingMonthDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
