package com.elitesland.tw.tw5.server.prd.system.entity;


import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @Author Bill
 * @Date 2023/9/15 11:20
 **/
@Entity
@Table(name = "prd_system_business_object")
@org.hibernate.annotations.Table(appliesTo = "prd_system_business_object", comment = "系统业务对象表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PrdSystemBusinessObjectDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -1909709734447934533L;

    @Comment("对象编号")
    @Column(name = "object_code")
    private String objectCode;

    @Comment("对象名称")
    @Column(name = "object_name")
    private String objectName;

    @Comment("对象状态")
    @Column(name = "object_status")
    private Integer objectStatus;

    @Comment("对象版本")
    @Column(name = "object_version")
    private String objectVersion;

    public PrdSystemBusinessObjectDO() {
    }

    public void copy(PrdSystemBusinessObjectDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }


}
