package com.elitesland.tw.tw5.server.prd.system.service;


import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSiteRefPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSiteRefQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSiteRefService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSiteRefVO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemSiteRefConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemSiteRefDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemSiteRefDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemSiteRefRepo;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 业务地点关系表
 *
 * @author zoey
 * @date 2024-04-22
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemSiteRefServiceImpl extends BaseServiceImpl implements PrdSystemSiteRefService {

    private final PrdSystemSiteRefRepo prdSystemSiteRefRepo;
    private final PrdSystemSiteRefDAO prdSystemSiteRefDAO;

    @Override
    public PagingVO<PrdSystemSiteRefVO> queryPaging(PrdSystemSiteRefQuery query){
        return prdSystemSiteRefDAO.queryPaging(query);
    }

    @Override
    public List<PrdSystemSiteRefVO> queryListDynamic(PrdSystemSiteRefQuery query){
        return prdSystemSiteRefDAO.queryListDynamic(query);
    }

    @Override
    public PrdSystemSiteRefVO queryByKey(Long key) {
        PrdSystemSiteRefDO entity = prdSystemSiteRefRepo.findById(key).orElseGet(PrdSystemSiteRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdSystemSiteRefVO vo = PrdSystemSiteRefConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdSystemSiteRefVO insert(PrdSystemSiteRefPayload payload) {
        PrdSystemSiteRefDO entityDo = PrdSystemSiteRefConvert.INSTANCE.toDo(payload);
        return PrdSystemSiteRefConvert.INSTANCE.toVo(prdSystemSiteRefRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdSystemSiteRefVO update(PrdSystemSiteRefPayload payload) {
        PrdSystemSiteRefDO entity = prdSystemSiteRefRepo.findById(payload.getId()).orElseGet(PrdSystemSiteRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdSystemSiteRefDO entityDo = PrdSystemSiteRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdSystemSiteRefConvert.INSTANCE.toVo(prdSystemSiteRefRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PrdSystemSiteRefPayload payload) {
        PrdSystemSiteRefDO entity = prdSystemSiteRefRepo.findById(payload.getId()).orElseGet(PrdSystemSiteRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = prdSystemSiteRefDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            prdSystemSiteRefDAO.deleteSoft(keys);
        }
    }

}
