package com.elitesland.tw.tw5.server.common.repo;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;

import java.util.List;
import java.util.Map;

/**
 * @Author carl.wang
 * @Description
 * @date
 **/
public interface TransferUtilRepo extends JpaRepository<BaseModel, Long>, QuerydslPredicateExecutor<BaseModel>, JpaSpecificationExecutor<BaseModel> {

    /**
     * 查询组织数据
     *
     * @param orgIds
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT id ,org_id_v4 as orgIdV4 FROM prd_org_organization  where id in (?1) and delete_flag=0")
    List<Map<String, Long>> queryTw4Orgs(List<Long> orgIds);

    /**
     * 查询组织数据
     *
     * @param orgIds
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT id ,org_id_v4 as orgIdV4 FROM prd_org_organization where change_id = 0 and org_id_v4 in (?1) ")
    List<Map<String, Long>> queryTw5Orgs(List<Long> orgIds);

    /**
     * 获取Tw5组织员工关系数据
     *
     * @param refds
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT id ,ref_id_v4 as refIdV4 FROM prd_org_employee_ref  where ref_id_v4 in (?1) ")
    List<Map<String, Long>> queryTw5OrgRefUsers(List<Long> refds);

    /**
     * 查询员工数据
     *
     * @param userIds
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT user_id as userId,user_id_v4 as userIdV4 FROM prd_org_employee  where user_id in (?1) and delete_flag=0")
    List<Map<String, Long>> queryTw4Employees(List<Long> userIds);

    /**
     * 查询员工数据
     *
     * @param userIds
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT user_id as userId,user_id_v4 as userIdV4 FROM prd_org_employee  where user_id in (?1) and delete_flag=0")
    List<PrdOrgEmployeeDO> queryTw4ByUserIdList(List<Long> userIds);
    /**
     * 查询员工数据
     *
     * @param userIds
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT a.id as id,a.sort_index as sotrIndex,a.bangwo8adviser_id as bangwo8AdviserId,a.user_id as userId,a.user_id_v4 as userIdV4 ,a.person_id as personId,a.wecom_id as wecomId,a.employee_name as employeeName, b.email as email ,b.enabled as enabled,b.mobile as mobile" +
            " FROM prd_org_employee a LEFT JOIN prd_org_person b on a.person_id=b.id where user_id_v4 in (?1) ")
    List<Map<String, Object>> queryTw5Employees(List<Long> userIds);


    /**
     * 查询tw4.0 用户ids
     *
     * @param userIds
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT user_id_v4 FROM prd_org_employee  where user_id in (?1) and delete_flag=0")
    List<Long> queryEmployeeTw4Ids(List<Long> userIds);

    /**
     * 查询tw4.0 用户ids
     *
     * @param userIds
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT user_id,user_id_v4 FROM prd_org_employee  where user_id in (?1) and delete_flag=0")
    Map queryEmployeeTw4IdsByUserId(List<Long> userIds);

    /**
     * 查询地址簿数据  update wly
     *
     * @param bookIds
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT id,book_id_v4 as bookIdV4 FROM prd_ab  where id in (?1) and delete_flag=0")
    List<Map<String, Long>> queryTw4Books(List<Long> bookIds);
    /**
     * 查询商机id数据
     *
     * @param oppoIds
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT id,oppo_id_v4 as oppoIdV4 FROM crm_opportunity  where id in (?1) and delete_flag=0")
    List<Map<String, Long>> queryOppoTw4Maps(List<Long> oppoIds);

    /**
     * 查询地址簿数据
     *
     * @param bookIds
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT id,book_id_v4 as bookIdV4 FROM prd_ab  where book_id_v4 in (?1) and delete_flag=0")
    List<Map<String, Long>> queryTw5Books(List<Long> bookIds);

    /**
     * 查询内部公司数据
     *
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT id,book_id_v4 as bookIdV4 FROM prd_ab  where book_type = (?1) and relate_type = (?2) and delete_flag=0")
    List<Map<String, Long>> queryInterCompanyTw5Maps(String bookType, String relateType);

}
