package com.elitesland.tw.tw5.server.prd.acc.service;


import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingContinuousPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingContinuousQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingContinuousService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingContinuousVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingVO;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimSettingTypeEnum;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingContinuousConvert;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSettingContinuousDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingContinuousDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingContinuousRepo;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 报销配置连号规则配置
 *
 * @author zoey
 * @date 2024-04-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AccReimSettingContinuousServiceImpl extends BaseServiceImpl implements AccReimSettingContinuousService {

    private final AccReimSettingContinuousRepo accReimSettingContinuousRepo;
    private final AccReimSettingContinuousDAO accReimSettingContinuousDAO;
    private final AccReimSettingService accReimSettingService;
    private final AccReimSettingRepo accReimSettingRepo;
    private final CacheUtil cacheUtil;
    private final InvInvoiceService invInvoiceService;

    @Override
    public PagingVO<AccReimSettingContinuousVO> queryPaging(AccReimSettingContinuousQuery query){
        return accReimSettingContinuousDAO.queryPaging(query);
    }

    @Override
    public List<AccReimSettingContinuousVO> queryListDynamic(AccReimSettingContinuousQuery query){
        return accReimSettingContinuousDAO.queryListDynamic(query);
    }

    @Override
    public AccReimSettingContinuousVO queryByKey(Long key) {
        // 当前配置表
        AccReimSettingContinuousDO entity = accReimSettingContinuousRepo.findById(key).orElseGet(AccReimSettingContinuousDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimSettingContinuousVO vo = AccReimSettingContinuousConvert.INSTANCE.toVo(entity);
        // 查询基础配置表
        AccReimSettingQuery accReimSettingQuery = new AccReimSettingQuery();
        accReimSettingQuery.setSpecificReimSettingId(key);
        accReimSettingQuery.setReimSettingType(AccReimSettingTypeEnum.SERIATE.getCode());
        List<AccReimSettingVO> accReimSettingVOS = accReimSettingService.queryListDynamic(accReimSettingQuery);
        if(!CollectionUtils.isEmpty(accReimSettingVOS)){
            vo.setAccReimSettingVO(accReimSettingVOS.get(0));
        }
        translateList(Collections.singletonList(vo));
        return vo;

    }

    private void translateList(List<AccReimSettingContinuousVO> voList){
        for (AccReimSettingContinuousVO vo : voList) {
            if(StringUtils.hasText(vo.getInvoiceType())){
                // 报销单据类型
                List<String> invoiceTypes = new ArrayList<>();
                for (String reimDocType : vo.getInvoiceType().split(",")) {
                    String reimDocTypeName = cacheUtil.transferSystemSelection("INV:INPUT_INV_TYPE",reimDocType);
                    invoiceTypes.add(reimDocTypeName);
                }
                String invoiceTypeDesc = String.join(",", invoiceTypes);
                vo.setInvoiceTypeDesc(invoiceTypeDesc);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AccReimSettingContinuousVO insert(AccReimSettingContinuousPayload payload) {


        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();

        // 保存当前配置表
        AccReimSettingContinuousDO entityDo = AccReimSettingContinuousConvert.INSTANCE.toDo(payload);
        AccReimSettingContinuousVO accReimSettingContinuousVO = AccReimSettingContinuousConvert.INSTANCE.toVo(accReimSettingContinuousRepo.save(entityDo));
        // 保存基础配置表
        Long id = accReimSettingContinuousVO.getId();
        accReimSettingPayload.setSpecificReimSettingId(id);
        accReimSettingPayload.setReimSettingType(AccReimSettingTypeEnum.SERIATE.getCode());
        // 判断重复
        accReimSettingService.checkRepeat(accReimSettingPayload);
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo(accReimSettingRepo.save(accReimSettingDO));
        accReimSettingContinuousVO.setAccReimSettingVO(accReimSettingVO);

        return accReimSettingContinuousVO;

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AccReimSettingContinuousVO update(AccReimSettingContinuousPayload payload) {
        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();
        // 判断重复
        accReimSettingService.checkRepeat(accReimSettingPayload);
        // 保存当前配置表
        AccReimSettingContinuousDO entity = accReimSettingContinuousRepo.findById(payload.getId()).orElseGet(AccReimSettingContinuousDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimSettingContinuousDO entityDo = AccReimSettingContinuousConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        AccReimSettingContinuousVO accReimSettingContinuousVO = AccReimSettingContinuousConvert.INSTANCE.toVo(accReimSettingContinuousRepo.save(entity));
        // 保存基础配置表
        AccReimSettingDO accReimSettingEntity = accReimSettingRepo.findById(accReimSettingPayload.getId()).orElseGet(AccReimSettingDO::new);
        Assert.notNull(accReimSettingEntity.getId(), "不存在");
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        accReimSettingEntity.copy(accReimSettingDO);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo(accReimSettingRepo.save(accReimSettingEntity));
        accReimSettingContinuousVO.setAccReimSettingVO(accReimSettingVO);
        return accReimSettingContinuousVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(AccReimSettingContinuousPayload payload) {
        AccReimSettingContinuousDO entity = accReimSettingContinuousRepo.findById(payload.getId()).orElseGet(AccReimSettingContinuousDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = accReimSettingContinuousDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            accReimSettingContinuousDAO.deleteSoft(keys);
        }
    }

    @Override
    public AccReimSettingContinuousVO ruleCheck(Long key, List<InvInvoiceVO> invInvoiceVOS,Long reimUserId) {

        AccReimSettingContinuousVO accReimSettingContinuousVO = queryByKey(key);
        String invoiceType = accReimSettingContinuousVO.getInvoiceType();
        List<String> invoiceTypeList = Arrays.stream(invoiceType.split(",")).collect(Collectors.toList());

        AccReimSettingVO accReimSettingVO = accReimSettingContinuousVO.getAccReimSettingVO();
        // 剔除白名单人员
        String whiteList = accReimSettingVO.getWhiteList();
        if(StringUtils.hasText(whiteList)){
            List<Long> idList = Arrays.stream(whiteList.split(",")).map(Long::parseLong).collect(Collectors.toList());
            //当前登录人
            if(idList.contains(reimUserId)){
                return accReimSettingContinuousVO;
            }
        }

        String continuousInvoiceNosStr ="";
        String remindText ="";
        String errorText ="";
        //invoiceNo是多个
        for (InvInvoiceVO invInvoiceVO: invInvoiceVOS) {
            String invNo = invInvoiceVO.getInvoiceNo();
//            InvInvoiceQuery invInvoiceQuery = new InvInvoiceQuery();
//            invInvoiceQuery.setInvoiceNo(invNo);
//            List<InvInvoiceVO> invInvoiceVOS = invInvoiceService.queryListDynamic(invInvoiceQuery);
//            InvInvoiceVO invInvoiceVO = new InvInvoiceVO();
//            if(!CollectionUtils.isEmpty(invInvoiceVOS)){
//                invInvoiceVO = invInvoiceVOS.get(0);
//            }else{
//                throw TwException.error("","未找到对应的发票");
//            }
            // 满足规则第一条件
            if(invoiceTypeList.contains(invInvoiceVO.getInvType())){
                InvInvoiceQuery invInvoiceQuery1 = new InvInvoiceQuery();
                invInvoiceQuery1.setInvoiceDateGt(LocalDate.now().minusDays(accReimSettingContinuousVO.getCheckDays()));
                invInvoiceQuery1.setInvType(invInvoiceVO.getInvType());

                List<String> invoiceNos= new ArrayList<>();
                // 这里跨度要小，否则会出现问题，如果最后两位时99，结果就不对了
                String tailChar = invNo.substring(invNo.length() - 3);
                String headChar = invNo.substring(0, invNo.length() - 3);
                Integer checkStep = accReimSettingContinuousVO.getCheckStep();
                try{
                    Integer tailInt = Integer.parseInt(tailChar);
                    for(int i=1;i<checkStep+1;i++){
                        int tailAdd = tailInt + i;
                        int tailSubtract = tailInt - i;


                        String tailAddStr = padZero(tailAdd);
                        String tailSubtractStr = padZero(tailSubtract);
                        String invoiceNoAdd = headChar + tailAddStr;
                        String invoiceNoSubtract = headChar + tailSubtractStr;
                        invoiceNos.add(invoiceNoAdd);
                        invoiceNos.add(invoiceNoSubtract);
                    }
                }catch (Exception e){
                    //如果最后两位连数字都不是，不校验重复
                    return accReimSettingContinuousVO;
                }
                invInvoiceQuery1.setInvoiceNoIn(invoiceNos);

                String checkRange = accReimSettingContinuousVO.getCheckRange();
                if(checkRange.equals("OWN")){
                    invInvoiceQuery1.setInvOwnerId(invInvoiceVO.getInvOwnerId());
                }
                List<InvInvoiceVO> invInvoiceVOS1 = invInvoiceService.queryListDynamic(invInvoiceQuery1);
                if(!CollectionUtils.isEmpty(invInvoiceVOS1)){
                    String continuousInvoiceNos = invInvoiceVOS1.stream().map(e -> e.getInvoiceNo()).collect(Collectors.joining(","));
                    continuousInvoiceNosStr=continuousInvoiceNosStr.length()<1?continuousInvoiceNosStr+continuousInvoiceNos:continuousInvoiceNosStr+","+continuousInvoiceNos;
//                    AccReimSettingVO accReimSettingVO = accReimSettingContinuousVO.getAccReimSettingVO();
                    if(accReimSettingVO.getRemindText()!=null){
                        String remindTextCopy = accReimSettingVO.getRemindText();
                        remindTextCopy=remindTextCopy.replace("#{1}",invNo).replace("#{2}",continuousInvoiceNos);
                        remindText=remindText.length()<1?remindText+remindTextCopy:remindText+","+remindTextCopy;
                    }
                    if(accReimSettingVO.getErrorText()!=null){
                        String errorTextCopy = accReimSettingVO.getErrorText();
                        errorTextCopy=errorTextCopy.replace("#{1}",invNo).replace("#{2}",continuousInvoiceNos);
                        errorText=errorText.length()<1?errorText+errorTextCopy:errorText+","+errorTextCopy;
                    }
                }
            }
        }
        accReimSettingContinuousVO.setContinuousInvoiceNos(continuousInvoiceNosStr);
//        AccReimSettingVO accReimSettingVO = accReimSettingContinuousVO.getAccReimSettingVO();
        accReimSettingVO.setRemindText(remindText);
        accReimSettingVO.setErrorText(errorText);
        return accReimSettingContinuousVO;
    }


    public static String padZero(int number) {
        // 将整数转换为字符串
        String numberStr = String.valueOf(number);

        // 如果字符串长度不足 3 位，则在前面补零
        while (numberStr.length() < 3) {
            numberStr = "0" + numberStr;
        }

        return numberStr;
    }

}
