package com.elitesland.tw.tw5.server.prd.common;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.workflow.params.ProcDefDTO;
import com.elitescloud.cloudt.workflow.params.TaskNodeConfigDTO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.workFlow.TwWorkflowAssignType;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgRoleDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgRoleRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.ApprovePayload;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Component
@RequiredArgsConstructor
@Slf4j
public class WorkflowUtil {
    private final WorkflowService workflowService;

    private final PrdSystemRoleService prdSystemRoleService;
    private final PrdOrgRoleRepo prevOrgRoleRepo;
    private final PrdOrgOrganizationService prevOrgOrganizationService;

    private final EntityManager entityManager;

    private final TransactionUtilService transactionUtilService;


    /**
     * 创建工作流
     *
     * @param payload
     * @param startUserId 流程发起指定创建人
     * @return
     */
    public ProcessInfo startProcess(StartProcessPayload payload, Long... startUserId) {
        String starterId = null;
        if (startUserId != null && startUserId.length > 0) {
            starterId = startUserId[0] + "";
        }
        payload.setStarterId(starterId);
        WorkflowResult<ProcessInfo> workflowResult = workflowService.startProcess(payload);
        System.out.println("workflowResult:::" + workflowResult.toString());
        if (workflowResult != null) {
            if (workflowResult.isSuccess()) {
                return workflowResult.getData();
            } else {
                throw TwException.error("", "工作流创建异常:" + workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "工作流创建返回值异常，请联系管理员！");
        }

    }

    public Map<String, Object> setTwCustomAssign(String definitionKey, Object context, HashMap<String, Object> variables) {
        // 处理TW自定义配置型节点审批人
        Map<String, Object> contextMap = BeanUtil.beanToMap(context);

        WorkflowResult<List<TaskNodeConfigDTO>> nodeConfig = workflowService.getNodeConfig(definitionKey, null);
        if (nodeConfig.isSuccess()) {
            List<TaskNodeConfigDTO> data = nodeConfig.getData();
            for (TaskNodeConfigDTO taskNodeConfigDTO : data) {
                if (TwWorkflowAssignType.TW_SYSTEM_ROLE.name().equals(taskNodeConfigDTO.getCustomParams())) {
                    String systemRole = taskNodeConfigDTO.getCustomParams2();
                    List<Long> userIds = prdSystemRoleService.queryUserIdByRoleCode(systemRole);
                    variables.put(taskNodeConfigDTO.getTaskDefId(), CollUtil.newArrayList(userIds));
                    continue;
                }
                if (TwWorkflowAssignType.TW_ORG_ROLE.name().equals(taskNodeConfigDTO.getCustomParams())) {
                    String orgRole = taskNodeConfigDTO.getCustomParams2();
                    Optional<PrdOrgRoleDO> orgRoleDO = prevOrgRoleRepo.findById(Long.valueOf(orgRole));
                    String userIds = orgRoleDO.orElse(new PrdOrgRoleDO()).getRoleEmployees();
                    if (userIds == null) {
                        userIds = "";
                    }
                    variables.put(taskNodeConfigDTO.getTaskDefId(), CollUtil.newArrayList(userIds.split(",")));
                    continue;
                }
                if (TwWorkflowAssignType.DOC_USER_FIELD.name().equals(taskNodeConfigDTO.getCustomParams())) {
                    String docUserField = taskNodeConfigDTO.getCustomParams2();
                    String userIds = contextMap.get(docUserField).toString();
                    if (userIds == null) {
                        userIds = "";
                    }
                    variables.put(taskNodeConfigDTO.getTaskDefId(), CollUtil.newArrayList(userIds.split(",")));
                    continue;
                }
                if (TwWorkflowAssignType.DOC_ORG_FIELD.name().equals(taskNodeConfigDTO.getCustomParams())) {
                    String docOrgField = taskNodeConfigDTO.getCustomParams2();
                    System.out.println("contextMap:::" + contextMap + " /docOrgField:" + docOrgField);
                    String orgId = contextMap.get(docOrgField).toString();
                    String userIds = "";
                    if (orgId != null && !orgId.trim().isEmpty()) {
                        PrdOrgOrganizationVO prdOrgOrganizationVO = prevOrgOrganizationService.queryDetailSimpleByOrgId(Long.valueOf(orgId));
                        if (prdOrgOrganizationVO != null) {
                            userIds = prdOrgOrganizationVO.getManageId() + "";
                        }
                    }

                    variables.put(taskNodeConfigDTO.getTaskDefId(), CollUtil.newArrayList(userIds.split(",")));
                    continue;
                }
            }
        }
        return variables;
    }

    public ProcessInfo simpleStartProcess(StartProcessPayload payload, Object context, Long... startUserId) {
        String starterId = null;
        if (startUserId != null && startUserId.length > 0) {
            starterId = startUserId[0] + "";
        }
        payload.setStarterId(starterId);

        setTwCustomAssign(payload.getProcessDefinitionKey(), context, payload.getVariables());

        WorkflowResult<ProcessInfo> workflowResult = workflowService.startProcess(payload);
        System.out.println("workflowResult:::" + workflowResult.toString());
        if (workflowResult.isSuccess()) {
            ProcessInfo data = workflowResult.getData();

            WorkflowResult<ProcDefDTO> procDefResult = workflowService.getProcDef(payload.getProcessDefinitionKey());
            String tableName = procDefResult.getData().getEs2();

            transactionUtilService.executeWithRunnable(() -> {
                String sql = "UPDATE " + tableName + " SET proc_inst_id = ?1 WHERE id = ?2";
                //String sql = "UPDATE " + tableName + " SET proc_inst_id = ?1, submit_time = ?2 WHERE id = ?3";
                // 使用EntityManager执行原生SQL
                Query query = entityManager.createNativeQuery(sql)
                        .setParameter(1, data.getProcInstId())
//                        .setParameter(2, LocalDateTime.now())
                        .setParameter(2, payload.getBusinessKey());
                query.executeUpdate();
            });


//            workflowCommonRepo.commonWorkflowUpdate(tableName, data.getProcInstId(), data.getProcInstStatus().name(), LocalDateTime.now(), payload.getBusinessKey());
            return data;
        } else {
            throw TwException.error("", "工作流创建异常:" + workflowResult.getMsg());
        }

    }

    /**
     * 删除工作流
     *
     * @param payload
     */
    public void deleteProcess(DeleteProcessPayload payload) {
        WorkflowResult workflowResult = workflowService.deleteProcess(payload);
        if (workflowResult != null) {
            if (!workflowResult.isSuccess()) {
                throw TwException.error("", workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "工作流删除异常，请联系管理员！");
        }
    }

    /**
     * 修改流程实例节点审批人
     *
     * @param payload
     */
    public void setVariables(SetVariablesPayload payload) {
        WorkflowResult workflowResult = workflowService.setVariables(payload);
        if (workflowResult != null) {
            if (!workflowResult.isSuccess()) {
                throw TwException.error("", workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "修改节点审批人异常，请联系管理员！");
        }
    }

    //设置属性值
    public void setVaribales(SetVariablesPayload payload) {
        WorkflowResult workflowResult = workflowService.setVariables(payload);
        if (workflowResult != null) {
            if (!workflowResult.isSuccess()) {
                throw TwException.error("", workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "工作流更改参数异常，请联系管理员！");
        }
    }

    //推流程
    public void approve(ApprovePayload payload) {
        WorkflowResult workflowResult = workflowService.approve(payload);
        if (workflowResult != null) {
            if (!workflowResult.isSuccess()) {
                throw TwException.error("", workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "工作流推进异常，请联系管理员！");
        }
    }

    //获取工作流当前节点信息
    public TaskInfo currentTaskInfo(String procInstId) {
        WorkflowResult<TaskInfo> workflowResult = workflowService.currentTaskInfo(procInstId);
        if (workflowResult != null) {
            if (workflowResult.isSuccess()) {
                return workflowResult.getData();
            } else {
                throw TwException.error("", "工作流获取信息异常:" + workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "工作流信息获取异常，请联系管理员！");
        }
    }
}
