package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationMemberListPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationMemberPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationMemberQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationMemberService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationMemberVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.*;

import static java.util.stream.Collectors.collectingAndThen;
import static java.util.stream.Collectors.toCollection;

/**
 * 客户经营-经营团队成员
 *
 * @author duwh
 * @date 2022/11/18
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmCustomerOperationMemberController {

    private final CrmCustomerOperationMemberService service;
    private final CrmCustomerOperationService crmCustomerOperationService;
    private final CacheUtil cacheUtil;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/customerOperationMember")
    public TwOutputUtil insert(CrmCustomerOperationMemberPayload payload) {
        return TwOutputUtil.ok(service.insert(payload));
    }

    /**
     * 批量新增
     * 先清空，再全部新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/customerOperationMember/saveAll")
    public TwOutputUtil saveAll(@RequestBody CrmCustomerOperationMemberListPayload payload) {
        return TwOutputUtil.ok(service.saveAll(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("/customerOperationMember")
    public TwOutputUtil update(CrmCustomerOperationMemberPayload payload) {
        return TwOutputUtil.ok(service.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/customerOperationMember/{key}")
    //@UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        CrmCustomerOperationMemberVO prdFileVO = service.queryByKey(key);
        return TwOutputUtil.ok(prdFileVO);
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/customerOperationMember/paging")
    //@UdcNameClass
    public TwOutputUtil paging(CrmCustomerOperationMemberQuery query) {
        // 客户经营主键 不能为空
        if (null == query.getOperId()) {
            return TwOutputUtil.error("", "operId不能为空", null);
        }
        // 授权结束时间小于当前时间
        query.setEndTime(LocalDateTime.now());
        query.setDisabledFlag(0);
        PagingVO<CrmCustomerOperationMemberVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 查询列表  可用于下拉选择
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/customerOperationMember/list")
    //@UdcNameClass
    public TwOutputUtil queryList(CrmCustomerOperationMemberQuery query) {
        // 客户经营主键 不能为空
        final Long operId = query.getOperId();
        if (null == operId) {
            return TwOutputUtil.error("", "operId不能为空", null);
        }
        // 授权结束时间小于当前时间
        query.setEndTime(LocalDateTime.now());
        query.setDisabledFlag(0);
        List<CrmCustomerOperationMemberVO> list = new ArrayList<>();
        List<CrmCustomerOperationMemberVO> vos = service.queryList(query);
        list.addAll(vos);
        // 管理人员 添加到列表中
        final CrmCustomerOperationVO operationVO = crmCustomerOperationService.queryByKey(operId);
        if (null != operationVO) {
            // 销售经营部负责人 saleOperManagerId
            // addManagerUserInfo(list, operationVO.getSaleOperManagerId());
            //客户经营部负责人 custOperManagerId
            // addManagerUserInfo(list, operationVO.getCustOperManagerId());
            // 渠道经营负责人 channelUserId
            // addManagerUserInfo(list, operationVO.getChannelUserId());

            // 产品负责人 productUserId   (企业及生态伙伴)
            addManagerUserInfo(list, operationVO.getProductUserId());

            // 服务负责人 serviceUserId
            addManagerUserInfo(list, operationVO.getServiceUserId());
            // 商务负责人 businessUserId
            addManagerUserInfo(list, operationVO.getBusinessUserId());
            // 关怀负责人 careUserId
            addManagerUserInfo(list, operationVO.getCareUserId());
            // 运维售后负责人 operationUserId
            addManagerUserInfo(list, operationVO.getOperationUserId());
        }
        // 去重
        list = list.stream().collect(
            collectingAndThen(
                toCollection(() -> new TreeSet<>(Comparator.comparing(CrmCustomerOperationMemberVO::getUserId))), ArrayList::new)
        );
        return TwOutputUtil.ok(list);
    }

    private void addManagerUserInfo(List<CrmCustomerOperationMemberVO> list, Long userId) {
        if (null != userId) {
            list.add(new CrmCustomerOperationMemberVO(userId, cacheUtil.getUserName(userId)));
        }
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/customerOperationMember/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
